/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.file;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import jsc.Utilities;
import jsc.swt.file.AppFile;
import jsc.swt.file.ExampleFileFilter;

public class AppFileActions {
    static String writeFileErrorMessage = "\nCheck the following.\nIs the file name valid for your system?\nIs there sufficient free space on your disk?\nAre you allowed to write to the disk?";
    String confirmCloseMessage = "Save changes to file?";
    boolean changed;
    Component app;
    AppFile appFile;
    File currentFile = null;
    FileFilter filter;
    String defaultFileName;
    protected JFileChooser openFileChooser;
    protected JFileChooser saveFileChooser;

    public AppFileActions(Component component, AppFile appFile, FileFilter fileFilter, String string) {
        this.app = component;
        this.appFile = appFile;
        this.filter = fileFilter;
        this.defaultFileName = string;
        this.openFileChooser = new JFileChooser();
        this.openFileChooser.addChoosableFileFilter(fileFilter);
        this.openFileChooser.setApproveButtonToolTipText("Open file");
        this.saveFileChooser = new JFileChooser();
        this.saveFileChooser.addChoosableFileFilter(fileFilter);
        this.saveFileChooser.setApproveButtonToolTipText("Save file");
    }

    public AppFileActions(Component component, AppFile appFile, String string, String string2) {
        this(component, appFile, new ExampleFileFilter(string2, string + " file"), new String("*." + string2));
    }

    public boolean confirmClose() {
        int n;
        return !this.changed || !((n = JOptionPane.showConfirmDialog(this.app, this.confirmCloseMessage, " Confirm", 1)) == 0 ? !this.save(false) : n == 2);
    }

    public File getFile() {
        return this.currentFile;
    }

    public AbstractAction getOpenAction(String string, Icon icon) {
        return new OpenAction(string, icon);
    }

    public String getPath() {
        return this.currentFile.getParent();
    }

    public AbstractAction getSaveAction(String string, Icon icon) {
        return new SaveAction(string, icon);
    }

    public AbstractAction getSaveAsAction(String string) {
        return new SaveAsAction(string);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean save(boolean bl) {
        File file = this.currentFile;
        if (bl || file == null || file.isDirectory() || !file.isFile()) {
            if (file != null && file.isDirectory()) {
                this.saveFileChooser.setCurrentDirectory(file);
            }
            if (!this.saveFileChooser.isTraversable(file)) {
                this.saveFileChooser.setCurrentDirectory(Utilities.getUserDirectory());
            }
            if (file == null || file.isDirectory()) {
                this.saveFileChooser.setSelectedFile(new File(this.defaultFileName));
            } else {
                this.saveFileChooser.setSelectedFile(file);
            }
            int n = this.saveFileChooser.showSaveDialog(this.app);
            if (n == 0) {
                file = this.saveFileChooser.getSelectedFile();
                if (file == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.appFile.write(file)) {
            this.appFile.setFile(file);
            this.currentFile = file;
            this.setChanged(false);
            return true;
        }
        this.showFileWriteErrorMessage(file);
        return false;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setConfirmCloseMessage(String string) {
        this.confirmCloseMessage = string;
    }

    public void setDefaultFileName(String string) {
        this.defaultFileName = string;
    }

    public void setFile(File file) {
        this.currentFile = file;
    }

    public void setWriteFileErrorMessage(String string) {
        writeFileErrorMessage = string;
    }

    public void showFileWriteErrorMessage(File file) {
        JOptionPane.showMessageDialog(this.app, "Cannot save to file " + file.getName() + writeFileErrorMessage, "Error", 0);
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppFileActions.this.save(true);
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppFileActions.this.save(false);
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            if (!AppFileActions.this.confirmClose()) {
                return;
            }
            if (AppFileActions.this.currentFile == null) {
                AppFileActions.this.openFileChooser.setCurrentDirectory(Utilities.getUserDirectory());
            } else {
                AppFileActions.this.openFileChooser.setCurrentDirectory(AppFileActions.this.currentFile);
            }
            int n = AppFileActions.this.openFileChooser.showOpenDialog(AppFileActions.this.app);
            if (n == 0 && (file = AppFileActions.this.openFileChooser.getSelectedFile()) != null) {
                if (AppFileActions.this.appFile.read(file)) {
                    AppFileActions.this.currentFile = file;
                    AppFileActions.this.appFile.setFile(file);
                } else {
                    JOptionPane.showMessageDialog(AppFileActions.this.app, "Cannot read file " + file.getName() + "\nThe file must exist and be a file previously saved by this program.", "Error", 0);
                }
            }
        }
    }
}

