/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.mdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultDesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import jsc.swt.accessory.Calculator;
import jsc.swt.control.ToolBar;
import jsc.swt.file.ExampleFileFilter;
import jsc.swt.help.HelpAction;
import jsc.swt.mdi.MDIWindow;
import jsc.swt.menu.LookAndFeelMenu;

public abstract class MDIApplication
extends JFrame {
    public static final int NO_WINDOW = 0;
    public static final int CLOSE_CANCELLED = 1;
    public static final int CLOSE_CONFIRMED = 2;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu windowMenu;
    protected JMenu optionsMenu;
    protected JMenu helpMenu;
    protected ToolBar toolBar;
    protected JDesktopPane desktop;
    protected JFrame parent;
    Hashtable windowHashtable = new Hashtable(10);
    CopyAction copyAction;
    CutAction cutAction;
    ClearAction clearAction;
    PasteAction pasteAction;
    Object aboutMessage;
    String initialHelpPage;
    String browserPath = "iexporer.exe";
    String appTitle;
    File currentFile = null;
    String appFileExtension;
    int untitledWindowCount = 0;
    Calculator calculator;
    ImageIcon windowIcon = null;

    public MDIApplication(String string, String string2, String string3, String string4, String string5, Object object) {
        super(" " + string);
        Object object2;
        Object object3;
        this.appTitle = string;
        this.appFileExtension = string4;
        this.aboutMessage = object;
        this.initialHelpPage = string5;
        this.parent = this;
        this.addWindowListener(new WL());
        if (string2 != null) {
            object3 = Toolkit.getDefaultToolkit();
            object2 = ((Toolkit)object3).getImage(string2);
            this.setIconImage((Image)object2);
        }
        if (string3 != null) {
            this.windowIcon = new ImageIcon(string3);
        }
        this.menuBar = new JMenuBar();
        this.menuBar.setBorder(new BevelBorder(0));
        this.fileMenu = new JMenu("File");
        this.menuBar.add(this.fileMenu);
        object3 = new NewAction("New...", new ImageIcon("images/new.gif"));
        object2 = new OpenAction("Open...", new ImageIcon("images/open.gif"));
        SaveAction saveAction = new SaveAction("Save", new ImageIcon("images/save.gif"));
        SaveAsAction saveAsAction = new SaveAsAction("Save as...");
        ExitAction exitAction = new ExitAction("Exit");
        JMenuItem jMenuItem = this.fileMenu.add((Action)object3);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        jMenuItem = this.fileMenu.add((Action)object2);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        jMenuItem = this.fileMenu.add(saveAction);
        this.fileMenu.add(saveAsAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.fileMenu.addSeparator();
        this.fileMenu.add(exitAction);
        this.editMenu = new JMenu("Edit");
        this.menuBar.add(this.editMenu);
        this.cutAction = new CutAction("Cut", new ImageIcon("images/cut.gif"));
        this.clearAction = new ClearAction("Delete");
        this.copyAction = new CopyAction("Copy", new ImageIcon("images/copy.gif"));
        this.pasteAction = new PasteAction("Paste", new ImageIcon("images/paste.gif"));
        SelectAllAction selectAllAction = new SelectAllAction("Select all");
        SelectNoneAction selectNoneAction = new SelectNoneAction("Select none");
        jMenuItem = this.editMenu.add(this.cutAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        jMenuItem = this.editMenu.add(this.copyAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        jMenuItem = this.editMenu.add(this.pasteAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2, false));
        this.editMenu.add(this.clearAction);
        this.editMenu.addSeparator();
        jMenuItem = this.editMenu.add(selectAllAction);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.editMenu.add(selectNoneAction);
        this.optionsMenu = new JMenu("Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show toolbar", true);
        jCheckBoxMenuItem.addActionListener(new ShowToolBarListener());
        this.optionsMenu.add(jCheckBoxMenuItem);
        LookAndFeelMenu lookAndFeelMenu = new LookAndFeelMenu(this.parent);
        this.optionsMenu.add(lookAndFeelMenu);
        this.menuBar.add(this.optionsMenu);
        this.windowMenu = new JMenu("Window");
        this.menuBar.add(this.windowMenu);
        CascadeAction cascadeAction = new CascadeAction("Cascade");
        this.windowMenu.add(cascadeAction);
        TileAction tileAction = new TileAction("Tile");
        this.windowMenu.add(tileAction);
        CloseAllAction closeAllAction = new CloseAllAction("Close all");
        this.windowMenu.add(closeAllAction);
        this.windowMenu.addSeparator();
        this.helpMenu = new JMenu("Help");
        this.menuBar.add(this.helpMenu);
        CalculatorAction calculatorAction = new CalculatorAction("Calculator...", new ImageIcon("images/calculator.gif"));
        this.helpMenu.add(calculatorAction);
        HelpAction helpAction = new HelpAction(this.parent, "Help topics...", new ImageIcon("images/help.gif"), this.browserPath, string5);
        this.helpMenu.add(helpAction);
        AboutAction aboutAction = new AboutAction("About...");
        this.helpMenu.add(aboutAction);
        this.toolBar = new ToolBar(this.appTitle + " tool bar", new Dimension(30, 30));
        this.toolBar.add((Action)object3, "New");
        this.toolBar.add((Action)object2, "Open file");
        this.toolBar.add(saveAction, "Save file");
        this.toolBar.addSeparator();
        this.setEditEnabled(false);
        if (this.getToolkit().getSystemClipboard().getContents(this) == null) {
            this.pasteAction.setEnabled(false);
        }
        this.toolBar.add(this.cutAction, "Cut");
        this.toolBar.add(this.copyAction, "Copy");
        this.toolBar.add(this.pasteAction, "Paste");
        this.toolBar.addSeparator();
        this.toolBar.add(helpAction, "Help");
        this.toolBar.add(calculatorAction, "Calculator");
        this.setJMenuBar(this.menuBar);
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
        this.desktop.setDesktopManager(new WindowManager());
        this.toolBar.addToDesktop(this.desktop);
        this.calculator = new Calculator(this.parent);
    }

    public void closeAllWindows() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            try {
                jInternalFrameArray[n].setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public abstract MDIWindow createWindow(File var1);

    public void fileWriteErrorMessage(File file) {
        JOptionPane.showMessageDialog(this.parent, "Cannot save window to file " + file.getName() + "\nCheck the following." + "\nIs the file name valid for your system?" + "\nIs there sufficient free space on your disk?" + "\nAre you allowed to write to the disk?", "Error", 0);
    }

    public MDIWindow getActiveWindow() {
        MDIWindow mDIWindow = (MDIWindow)this.desktop.getSelectedFrame();
        return mDIWindow;
    }

    void newWindow(File file) {
        MDIWindow mDIWindow = this.createWindow(file);
        if (mDIWindow == null) {
            return;
        }
        if (file == null) {
            mDIWindow.setTitle("Untitled " + ++this.untitledWindowCount);
        }
        mDIWindow.setApp(this);
        if (this.windowIcon != null) {
            mDIWindow.setFrameIcon(this.windowIcon);
        }
        mDIWindow.setBounds(0, this.toolBar.getVisibleHeight(), 400, 300);
        this.desktop.add((Component)mDIWindow, JLayeredPane.DEFAULT_LAYER);
        mDIWindow.setVisible(true);
        JMenuItem jMenuItem = this.windowMenu.add(new WindowAction(mDIWindow.getTitle(), mDIWindow));
        this.windowHashtable.put(mDIWindow, jMenuItem);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201 && this.saveQuery() == 1) {
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    public boolean save(boolean bl, MDIWindow mDIWindow) {
        if (mDIWindow == null) {
            return false;
        }
        File file = mDIWindow.getFile();
        if (bl || file == null) {
            JFileChooser jFileChooser = new JFileChooser(this.currentFile);
            String[] stringArray = new String[]{this.appFileExtension};
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter(stringArray, this.appTitle + " file");
            jFileChooser.addChoosableFileFilter(exampleFileFilter);
            jFileChooser.setApproveButtonToolTipText("Save window to file");
            if (file == null) {
                jFileChooser.setSelectedFile(new File("*." + this.appFileExtension));
            } else {
                jFileChooser.setSelectedFile(file);
            }
            int n = jFileChooser.showSaveDialog(this.parent);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (mDIWindow.write(file)) {
            mDIWindow.setFile(file);
            this.setTitle(file.getName());
            mDIWindow.setChanged(false);
            this.currentFile = file;
            return true;
        }
        this.fileWriteErrorMessage(file);
        return false;
    }

    protected int saveQuery() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        int n = jInternalFrameArray.length - 1;
        while (n >= 0) {
            int n2;
            MDIWindow mDIWindow = (MDIWindow)jInternalFrameArray[n];
            if (mDIWindow.isChanged() && ((n2 = JOptionPane.showConfirmDialog(this.parent, mDIWindow.getTitle() + " has changed." + "\nDo you want to save it?", "Closing " + this.appTitle, 1)) == 0 ? !this.save(false, mDIWindow) : n2 == 2)) {
                return 1;
            }
            --n;
        }
        return 2;
    }

    public void setClearEnabled(boolean bl) {
        this.clearAction.setEnabled(bl);
    }

    public void setCopyEnabled(boolean bl) {
        this.copyAction.setEnabled(bl);
    }

    public void setCutEnabled(boolean bl) {
        this.cutAction.setEnabled(bl);
    }

    public void setEditEnabled(boolean bl) {
        this.copyAction.setEnabled(bl);
        this.cutAction.setEnabled(bl);
        this.clearAction.setEnabled(bl);
    }

    public void setPasteEnabled(boolean bl) {
        this.pasteAction.setEnabled(bl);
    }

    public void setTitle(String string) {
        super.setTitle(this.appTitle + " - " + string);
    }

    class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    class WindowManager
    extends DefaultDesktopManager {
        WindowManager() {
        }

        public void activateFrame(JInternalFrame jInternalFrame) {
            super.activateFrame(jInternalFrame);
            MDIApplication.this.setTitle(jInternalFrame.getTitle());
            jInternalFrame.requestFocus();
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
            System.out.println("MDI Window closing");
            Object v = MDIApplication.this.windowHashtable.get(jInternalFrame);
            if (v != null) {
                MDIApplication.this.windowMenu.remove((JMenuItem)v);
                MDIApplication.this.windowHashtable.remove(jInternalFrame);
                System.out.println("Removing window menu item");
            }
            super.closeFrame(jInternalFrame);
            MDIApplication.this.desktop.remove(jInternalFrame);
            jInternalFrame = null;
            if (MDIApplication.this.getActiveWindow() == null) {
                MDIApplication.this.setTitle("");
            }
        }
    }

    class WindowAction
    extends AbstractAction {
        JInternalFrame f;

        public WindowAction(String string, JInternalFrame jInternalFrame) {
            super(string);
            this.f = jInternalFrame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.f.setIcon(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.f.toFront();
            try {
                this.f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }

        public JInternalFrame getWindow() {
            return this.f;
        }
    }

    class TileAction
    extends AbstractAction {
        public TileAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JInternalFrame[] jInternalFrameArray = MDIApplication.this.desktop.getAllFrames();
            int n2 = jInternalFrameArray.length;
            if (n2 == 0) {
                return;
            }
            int n3 = (int)Math.sqrt(n2);
            int n4 = n3;
            if (n4 * (n = n3) < n2 && n4 * ++n < n2) {
                ++n4;
            }
            Dimension dimension = MDIApplication.this.desktop.getSize();
            int n5 = dimension.width / n;
            int n6 = dimension.height / n4 - MDIApplication.this.toolBar.getVisibleHeight();
            int n7 = 0;
            int n8 = MDIApplication.this.toolBar.getVisibleHeight();
            int n9 = 0;
            while (n9 < n4) {
                int n10 = 0;
                while (n10 < n && n9 * n + n10 < n2) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n9 * n + n10];
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jInternalFrame.setBounds(new Rectangle(n7, n8, n5, n6));
                    n7 += n5;
                    ++n10;
                }
                n8 += n6;
                n7 = 0;
                ++n9;
            }
        }
    }

    class ShowToolBarListener
    implements ActionListener {
        ShowToolBarListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.toolBar.setVisible(!MDIApplication.this.toolBar.isVisible());
        }
    }

    class SelectNoneAction
    extends AbstractAction {
        public SelectNoneAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.selectNone();
            mDIWindow.setSelection(false);
            MDIApplication.this.setEditEnabled(false);
        }
    }

    class SelectAllAction
    extends AbstractAction {
        public SelectAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.selectAll();
            mDIWindow.setSelection(true);
            MDIApplication.this.setEditEnabled(true);
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.save(true, MDIApplication.this.getActiveWindow());
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.save(false, MDIApplication.this.getActiveWindow());
        }
    }

    class PasteAction
    extends AbstractAction {
        public PasteAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.paste();
            mDIWindow.setChanged(true);
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(MDIApplication.this.currentFile);
            String[] stringArray = new String[]{MDIApplication.this.appFileExtension};
            ExampleFileFilter exampleFileFilter = new ExampleFileFilter(stringArray, MDIApplication.this.appTitle + " files");
            jFileChooser.addChoosableFileFilter(exampleFileFilter);
            jFileChooser.setApproveButtonToolTipText("Open file");
            int n = jFileChooser.showOpenDialog(MDIApplication.this.parent);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                MDIApplication.this.newWindow(file);
                MDIApplication.this.currentFile = file;
            }
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.newWindow(null);
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.dispatchEvent(new WindowEvent(MDIApplication.this, 201));
        }
    }

    class CutAction
    extends AbstractAction {
        public CutAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.copy();
            mDIWindow.clear();
            mDIWindow.setChanged(true);
            MDIApplication.this.pasteAction.setEnabled(true);
        }
    }

    class CopyAction
    extends AbstractAction {
        public CopyAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.copy();
            MDIApplication.this.pasteAction.setEnabled(true);
        }
    }

    class CloseAllAction
    extends AbstractAction {
        public CloseAllAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.closeAllWindows();
        }
    }

    class ClearAction
    extends AbstractAction {
        public ClearAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIWindow mDIWindow = MDIApplication.this.getActiveWindow();
            if (mDIWindow == null) {
                return;
            }
            mDIWindow.clear();
            mDIWindow.setChanged(true);
        }
    }

    class CascadeAction
    extends AbstractAction {
        public CascadeAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame[] jInternalFrameArray = MDIApplication.this.desktop.getAllFrames();
            int n = 0;
            int n2 = MDIApplication.this.toolBar.getVisibleHeight();
            int n3 = jInternalFrameArray.length - 1;
            while (n3 >= 0) {
                Rectangle rectangle = jInternalFrameArray[n3].getNormalBounds();
                rectangle.setLocation(n, n2);
                jInternalFrameArray[n3].setBounds(rectangle);
                n += 20;
                n2 += 25;
                try {
                    jInternalFrameArray[n3].setIcon(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jInternalFrameArray[n3].show();
                --n3;
            }
        }
    }

    class CalculatorAction
    extends AbstractAction {
        public CalculatorAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MDIApplication.this.calculator.show();
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(MDIApplication.this.parent, MDIApplication.this.aboutMessage, "About " + MDIApplication.this.appTitle, -1);
        }
    }
}

