/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot;

import jsc.swt.plot.AxisModel;

public class PiAxisModel
implements AxisModel {
    String label;
    int minNumerator;
    int maxNumerator;
    int denominator;

    public PiAxisModel(String string, int n, int n2, int n3) {
        if (n3 < 1) {
            throw new IllegalArgumentException("Denominator must be > 0.");
        }
        if (n >= n2) {
            throw new IllegalArgumentException("minNumerator must be < maxNumerator.");
        }
        this.label = string;
        this.minNumerator = n;
        this.maxNumerator = n2;
        this.denominator = n3;
    }

    public PiAxisModel() {
        this("", -1, 1, 1);
    }

    public Object clone() {
        return this.copy();
    }

    public PiAxisModel copy() {
        PiAxisModel piAxisModel = new PiAxisModel(this.label, this.minNumerator, this.maxNumerator, this.denominator);
        return piAxisModel;
    }

    public double getLength() {
        return (double)(this.maxNumerator - this.minNumerator) * Math.PI / (double)this.denominator;
    }

    public double getMin() {
        return (double)this.minNumerator * Math.PI / (double)this.denominator;
    }

    public double getMax() {
        return (double)this.maxNumerator * Math.PI / (double)this.denominator;
    }

    public int getTickCount() {
        return 1 + this.maxNumerator - this.minNumerator;
    }

    public double getFirstTickValue() {
        return this.getMin();
    }

    public double getLastTickValue() {
        return this.getMax();
    }

    public String getTickLabel(int n) {
        int n2 = this.minNumerator + n;
        if (n2 == 0) {
            return "0";
        }
        if (this.denominator == 1) {
            return n2 == 1 ? "\u03c0" : n2 + "\u03c0";
        }
        if (n2 % this.denominator == 0) {
            if ((n2 /= this.denominator) == 1) {
                return "\u03c0";
            }
            if (n2 == -1) {
                return "-\u03c0";
            }
            return n2 + "\u03c0";
        }
        if (n2 == 1) {
            return "\u03c0/" + this.denominator;
        }
        if (n2 == -1) {
            return "-\u03c0/" + this.denominator;
        }
        return n2 + "\u03c0" + "/" + this.denominator;
    }

    public double getTickValue(int n) {
        return (double)(this.minNumerator + n) * Math.PI / (double)this.denominator;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }
}

