/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import jsc.descriptive.FrequencyTable;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot2d.AxesPlot;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VPolygon;
import jsc.util.Maths;

public class Histogram2D
extends AxesPlot {
    public static final int FREQUENCY = 0;
    public static final int RELATIVE = 1;
    public static final int NORMALIZED = 2;
    private static final double ONE_THIRD = 0.3333333333333333;
    int type = 0;

    public Histogram2D(String string, AxisModel axisModel, AxisModel axisModel2) {
        super(axisModel, axisModel2, string);
        this.setAntialiasing(false);
    }

    public PlotObject addBars(FrequencyTable frequencyTable, Paint paint) {
        return this.addBars(frequencyTable, PlotShape.defaultColour, paint, PlotShape.defaultStroke, true);
    }

    public PlotObject addBars(FrequencyTable frequencyTable, Color color, Stroke stroke) {
        return this.addBars(frequencyTable, color, color, stroke, false);
    }

    public PlotObject addBars(FrequencyTable frequencyTable, Color color, Paint paint, Stroke stroke, boolean bl) {
        int n = frequencyTable.getNumberOfBins();
        int n2 = 2 + n + n;
        VPoint[] vPointArray = new VPoint[n2];
        int n3 = 0;
        double d = 0.0;
        vPointArray[0] = new VPoint(frequencyTable.getBoundary(0), 0.0);
        int n4 = 0;
        while (n4 < n) {
            switch (this.type) {
                case 0: {
                    d = frequencyTable.getFrequency(n4);
                    break;
                }
                case 1: {
                    d = frequencyTable.getProportion(n4);
                    break;
                }
                case 2: {
                    d = frequencyTable.getNormalizedFrequency(n4);
                }
            }
            vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4), d);
            vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4 + 1), d);
            ++n4;
        }
        vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4), 0.0);
        PlotShape plotShape = new PlotShape(new VPolygon(vPointArray), color, stroke, paint, bl);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public static int doaneBins(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Too few observations.");
        }
        return (int)Math.round(3.0 * Maths.log10(n) * Maths.log2(n));
    }

    public int getType() {
        return this.type;
    }

    public static int scottBins(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Too few observations.");
        }
        return (int)Math.round(Math.pow(n, 0.3333333333333333) / 0.6);
    }

    public static double scottBinWidth(int n, double d) {
        if (n < 1 || d <= 0.0) {
            throw new IllegalArgumentException("Cannot calculate class interval.");
        }
        return 3.49 * d * Math.pow(n, -0.3333333333333333);
    }

    public static double scottBinWidth(int n, double d, double d2) {
        if (n < 1 || d >= d2) {
            throw new IllegalArgumentException("Cannot calculate class interval.");
        }
        return 0.6 * (d2 - d) * Math.pow(n, -0.3333333333333333);
    }

    public void setType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid histogram type.");
        }
        this.type = n;
    }
}

