/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import jsc.descriptive.FrequencyTable;
import jsc.descriptive.Tally;
import jsc.distributions.Distribution;
import jsc.swt.plot.AxisModel;
import jsc.swt.plot.PlotFunction;
import jsc.swt.plot2d.FunctionPlot2D;
import jsc.swt.plot2d.PlotShape;
import jsc.swt.virtualgraphics.LineBars;
import jsc.swt.virtualgraphics.RectangularBars;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VPolygon;

public class PdfPlot
extends FunctionPlot2D
implements PlotFunction,
Cloneable {
    Distribution D;

    public PdfPlot(AxisModel axisModel, AxisModel axisModel2, String string) {
        super(axisModel, axisModel2, string);
    }

    public PlotShape addBars(FrequencyTable frequencyTable, Paint paint) {
        return this.addBars(frequencyTable, PlotShape.defaultColour, paint, PlotShape.defaultStroke, true);
    }

    public PlotShape addBars(FrequencyTable frequencyTable, Color color, Stroke stroke) {
        return this.addBars(frequencyTable, color, color, stroke, false);
    }

    public PlotShape addBars(FrequencyTable frequencyTable, Color color, Paint paint, Stroke stroke, boolean bl) {
        int n = frequencyTable.getNumberOfBins();
        int n2 = 2 + n + n;
        VPoint[] vPointArray = new VPoint[n2];
        int n3 = 0;
        double d = 0.0;
        vPointArray[0] = new VPoint(frequencyTable.getBoundary(0), 0.0);
        int n4 = 0;
        while (n4 < n) {
            d = frequencyTable.getNormalizedFrequency(n4);
            vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4), d);
            vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4 + 1), d);
            ++n4;
        }
        vPointArray[++n3] = new VPoint(frequencyTable.getBoundary(n4), 0.0);
        PlotShape plotShape = new PlotShape(new VPolygon(vPointArray), color, stroke, paint, bl);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public PlotShape addBars(Tally tally, double d, Color color, Paint paint, boolean bl, double d2) {
        int n = tally.getNumberOfBins();
        VPoint[] vPointArray = new VPoint[n];
        int n2 = 0;
        while (n2 < n) {
            vPointArray[n2] = new VPoint((double)tally.getBinValue(n2) + d2, tally.getProportion(n2));
            ++n2;
        }
        PlotShape plotShape = bl ? new PlotShape(new LineBars(vPointArray), color, new BasicStroke((float)d, 0, 1)) : new PlotShape((Shape)new RectangularBars(vPointArray, d), paint);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public PlotShape addPdf(Distribution distribution, int n, Color color) {
        return this.addPdf(distribution, this.horizontalAxis.getMin(), this.horizontalAxis.getMax(), n, color, PlotShape.defaultStroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addPdf(Distribution distribution, int n, Color color, Stroke stroke) {
        return this.addPdf(distribution, this.horizontalAxis.getMin(), this.horizontalAxis.getMax(), n, color, stroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addPdf(Distribution distribution, double d, double d2, int n, Color color, boolean bl) {
        return this.addPdf(distribution, d, d2, n, color, PlotShape.defaultStroke, color, bl);
    }

    public PlotShape addPdf(Distribution distribution, double d, double d2, int n, Color color, Stroke stroke) {
        return this.addPdf(distribution, d, d2, n, color, stroke, PlotShape.defaultPaint, false);
    }

    public PlotShape addPdf(Distribution distribution, double d, double d2, int n, Color color, Stroke stroke, Paint paint, boolean bl) {
        this.D = distribution;
        return this.addFunction(this, d, d2, n, color, stroke, paint, bl);
    }

    public PlotShape addPmf(Distribution distribution, int n, int n2, double d, Color color, Paint paint, boolean bl) {
        return this.addPmf(distribution, 1 + n2 - n, n, 1.0, d, color, paint, bl, 0.0);
    }

    public PlotShape addPmf(Distribution distribution, int n, double d, double d2, double d3, Color color, Paint paint, boolean bl) {
        return this.addPmf(distribution, n, d, d2, d3, color, paint, bl, 0.0);
    }

    public PlotShape addPmf(Distribution distribution, int n, double d, double d2, double d3, Color color, Paint paint, boolean bl, double d4) {
        VPoint[] vPointArray = new VPoint[n];
        int n2 = 0;
        while (n2 < n) {
            double d5 = d + (double)n2 * d2;
            vPointArray[n2] = new VPoint(d5 + d4, distribution.pdf(d5));
            ++n2;
        }
        PlotShape plotShape = bl ? new PlotShape(new LineBars(vPointArray), color, new BasicStroke((float)d3, 0, 1)) : new PlotShape((Shape)new RectangularBars(vPointArray, d3), paint);
        this.addObject(plotShape);
        this.repaint();
        return plotShape;
    }

    public double getOrdinate(double d) {
        try {
            return this.D.pdf(d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Double.NaN;
        }
    }
}

