/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.SeriesMarker;
import com.xeiam.xchart.StyleManager;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.hypermodules.internal.SwingWrapper;
import org.cytoscape.hypermodules.internal.statistics.LogRankTest;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class ChartDisplay {
    private ArrayList<String[]> clinicalValues;
    private ArrayList<String[]> sampleValues;
    public CyNetwork network;
    private HashMap<String, String> allGeneSamplesMap;
    private String[] allPatients;
    private boolean[] status;
    private double[] followupDays;
    private double[] censor;
    private LogRankTest lrt;

    public ChartDisplay(ArrayList<String[]> clinicalValues, ArrayList<String[]> sampleValues, CyNetwork network) {
        this.clinicalValues = clinicalValues;
        this.sampleValues = sampleValues;
        this.network = network;
        this.allGeneSamplesMap = new HashMap();
        for (int i = 0; i < sampleValues.size(); ++i) {
            if (this.allGeneSamplesMap.get(sampleValues.get(i)[0]) != null) {
                String sti = this.allGeneSamplesMap.get(sampleValues.get(i)[0]);
                sti = sti + ":" + sampleValues.get(i)[1];
                this.allGeneSamplesMap.put(sampleValues.get(i)[0], sti);
                continue;
            }
            this.allGeneSamplesMap.put(sampleValues.get(i)[0], sampleValues.get(i)[1]);
        }
        for (CyNode cynode : this.network.getNodeList()) {
            if (this.allGeneSamplesMap.get(this.network.getRow((CyIdentifiable)cynode).get("name", String.class)) != null) continue;
            String[] inconsistency = new String[]{(String)this.network.getRow((CyIdentifiable)cynode).get("name", String.class), "no_sample"};
            sampleValues.add(inconsistency);
            this.allGeneSamplesMap.put(sampleValues.get(sampleValues.size() - 1)[0], sampleValues.get(sampleValues.size() - 1)[1]);
        }
        this.initClinicals();
        this.lrt = new LogRankTest(this.followupDays);
    }

    public void initClinicals() {
        int k;
        this.allPatients = new String[5];
        this.allPatients = new String[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.allPatients[k] = this.clinicalValues.get(k)[0];
        }
        this.status = new boolean[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.status[k] = this.clinicalValues.get(k)[1].toUpperCase().equals("DECEASED") || this.clinicalValues.get(k)[1].toUpperCase().equals("NO") || this.clinicalValues.get(k)[1].toUpperCase().equals("N") || this.clinicalValues.get(k)[1].equals("1");
        }
        this.followupDays = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.followupDays[k] = Double.valueOf(this.clinicalValues.get(k)[2]);
        }
        this.censor = new double[this.clinicalValues.size()];
        for (k = 0; k < this.clinicalValues.size(); ++k) {
            this.censor[k] = this.status[k] ? 1.0 : 0.0;
        }
    }

    public void display(String s) {
        int i;
        int i2;
        int i3;
        String[] genes = s.split(":");
        HashSet<String> truePatients = new HashSet<String>();
        for (int i4 = 0; i4 < genes.length; ++i4) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i4]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                if (thesePatients[t].equals("no_sample")) continue;
                truePatients.add(thesePatients[t]);
            }
        }
        int alpha = truePatients.size();
        double[] time1 = new double[alpha];
        double[] time2 = new double[this.allPatients.length - alpha];
        double[] censor1 = new double[alpha];
        double[] censor2 = new double[this.allPatients.length - alpha];
        int x = 0;
        int y = 0;
        for (int i5 = 0; i5 < this.allPatients.length; ++i5) {
            if (truePatients.contains(this.allPatients[i5])) {
                time1[x] = this.followupDays[i5];
                censor1[x] = this.censor[i5];
                ++x;
                continue;
            }
            time2[y] = this.followupDays[i5];
            censor2[y] = this.censor[i5];
            ++y;
        }
        ArrayDeque<Double> sortedTime1 = new ArrayDeque<Double>();
        ArrayDeque<Double> sortedTime2 = new ArrayDeque<Double>();
        ArrayDeque<Double> sortedCensor1 = new ArrayDeque<Double>();
        ArrayDeque<Double> sortedCensor2 = new ArrayDeque<Double>();
        for (i3 = 0; i3 < time1.length; ++i3) {
            sortedTime1.add(time1[i3]);
            sortedCensor1.add(censor1[i3]);
        }
        for (i3 = 0; i3 < time2.length; ++i3) {
            sortedTime2.add(time2[i3]);
            sortedCensor2.add(censor2[i3]);
        }
        Double[] lrvalue = this.lrt.logRank(sortedTime1, sortedTime2, sortedCensor1, sortedCensor2);
        ArrayList<Double> xData1 = new ArrayList<Double>();
        ArrayList<Double> xData2 = new ArrayList<Double>();
        ArrayList<Double> yData1 = new ArrayList<Double>();
        ArrayList<Double> yData2 = new ArrayList<Double>();
        double survival = 1.0;
        double numPeopleLeft = alpha;
        xData1.add(0.0);
        yData1.add(1.0);
        xData2.add(0.0);
        yData2.add(1.0);
        for (i2 = 0; i2 < censor1.length; ++i2) {
            if (censor1[i2] == 1.0) {
                xData1.add(time1[i2]);
                xData1.add(time1[i2]);
                yData1.add(survival);
                survival = (numPeopleLeft -= 1.0) / (double)alpha;
                yData1.add(survival);
                continue;
            }
            xData1.add(time1[i2]);
            yData1.add(survival);
            numPeopleLeft -= 1.0;
        }
        survival = 1.0;
        numPeopleLeft = this.allPatients.length - alpha;
        for (i2 = 0; i2 < censor2.length; ++i2) {
            if (censor2[i2] == 1.0) {
                xData2.add(time2[i2]);
                xData2.add(time2[i2]);
                yData2.add(survival);
                survival = (numPeopleLeft -= 1.0) / (double)(this.allPatients.length - alpha);
                yData2.add(survival);
                continue;
            }
            xData2.add(time2[i2]);
            yData2.add(survival);
            numPeopleLeft -= 1.0;
        }
        double[] xd1 = new double[xData1.size()];
        double[] xd2 = new double[xData2.size()];
        double[] yd1 = new double[yData1.size()];
        double[] yd2 = new double[yData2.size()];
        for (i = 0; i < xData1.size(); ++i) {
            xd1[i] = (Double)xData1.get(i);
            yd1[i] = (Double)yData1.get(i);
        }
        for (i = 0; i < xData2.size(); ++i) {
            xd2[i] = (Double)xData2.get(i);
            yd2[i] = (Double)yData2.get(i);
        }
        Chart chart = new ChartBuilder().width(800).height(600).theme(StyleManager.ChartTheme.GGPlot2).build();
        chart.setChartTitle("Kaplan-Meier Survival Analysis - log-rank p=" + ChartDisplay.roundToSignificantFigures(lrvalue[2], 3));
        chart.setXAxisTitle("Module genes: " + s);
        chart.setYAxisTitle("Survival Probability");
        chart.getStyleManager().setYAxisMin(0.0);
        chart.getStyleManager().setYAxisMax(1.0);
        Series series = chart.addSeries("Module-linked patients", xd1, yd1);
        Series series2 = chart.addSeries("Other patients", xd2, yd2);
        series.setLineColor(Color.RED);
        series.setMarker(SeriesMarker.CIRCLE);
        series.setMarkerColor(Color.RED);
        series2.setLineColor(Color.BLACK);
        series2.setMarker(SeriesMarker.TRIANGLE_UP);
        series2.setMarkerColor(Color.BLACK);
        new SwingWrapper(chart, lrvalue[2]).displayChart();
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }
}

