/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.xeiam.xchart.Chart;
import com.xeiam.xchart.ChartBuilder;
import com.xeiam.xchart.Series;
import com.xeiam.xchart.StyleManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.cytoscape.hypermodules.internal.SwingWrapper;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class ChartDisplayFisher {
    private ArrayList<String[]> otherValues;
    private ArrayList<String[]> sampleValues;
    public CyNetwork network;
    private HashMap<String, String> allGeneSamplesMap;
    private String[] allPatients;
    private String[] variable;
    private HashSet<String> allVariables;
    private ArrayList<String> allVariableNames;
    private Multimap<String, String> variable2patients;
    double[] percentages;
    double selectedP;
    String foregroundvariable;

    public ChartDisplayFisher(String foregroundvariable, Double selectedP, ArrayList<String[]> otherValues, ArrayList<String[]> sampleValues, CyNetwork network) {
        this.foregroundvariable = foregroundvariable;
        this.otherValues = otherValues;
        this.sampleValues = sampleValues;
        this.network = network;
        this.selectedP = selectedP;
        this.allGeneSamplesMap = new HashMap();
        for (int i = 0; i < sampleValues.size(); ++i) {
            if (this.allGeneSamplesMap.get(sampleValues.get(i)[0]) != null) {
                String sti = this.allGeneSamplesMap.get(sampleValues.get(i)[0]);
                sti = sti + ":" + sampleValues.get(i)[1];
                this.allGeneSamplesMap.put(sampleValues.get(i)[0], sti);
                continue;
            }
            this.allGeneSamplesMap.put(sampleValues.get(i)[0], sampleValues.get(i)[1]);
        }
        for (CyNode cynode : this.network.getNodeList()) {
            if (this.allGeneSamplesMap.get(this.network.getRow((CyIdentifiable)cynode).get("name", String.class)) != null) continue;
            String[] inconsistency = new String[]{(String)this.network.getRow((CyIdentifiable)cynode).get("name", String.class), "no_sample"};
            sampleValues.add(inconsistency);
            this.allGeneSamplesMap.put(sampleValues.get(sampleValues.size() - 1)[0], sampleValues.get(sampleValues.size() - 1)[1]);
        }
        this.initOther();
    }

    public void initOther() {
        int i;
        this.allPatients = new String[this.otherValues.size()];
        for (i = 0; i < this.otherValues.size(); ++i) {
            this.allPatients[i] = this.otherValues.get(i)[0];
        }
        this.allVariables = new HashSet();
        this.variable = new String[this.otherValues.size()];
        for (i = 0; i < this.otherValues.size(); ++i) {
            this.variable[i] = this.otherValues.get(i)[1];
            this.allVariables.add(this.otherValues.get(i)[1]);
        }
        this.variable2patients = ArrayListMultimap.create();
        for (String s : this.allVariables) {
            for (int i2 = 0; i2 < this.variable.length; ++i2) {
                if (!this.variable[i2].equals(s)) continue;
                this.variable2patients.put((Object)s, (Object)this.variable[i2]);
            }
        }
        this.allVariableNames = new ArrayList();
        for (String s : this.allVariables) {
            this.allVariableNames.add(s);
        }
        this.percentages = new double[this.allVariableNames.size()];
        int i3 = 0;
        for (String s : this.allVariableNames) {
            this.percentages[i3] = (double)this.variable2patients.get((Object)s).size() / (double)this.allPatients.length;
            ++i3;
        }
    }

    public void display(String s) {
        String[] genes = s.split(":");
        ArrayList<String> patients = new ArrayList<String>();
        for (int i = 0; i < genes.length; ++i) {
            String[] thesePatients = this.allGeneSamplesMap.get(genes[i]).split(":");
            for (int t = 0; t < thesePatients.length; ++t) {
                patients.add(thesePatients[t]);
            }
        }
        boolean[] var2patients = new boolean[this.otherValues.size()];
        for (int k = 0; k < this.otherValues.size(); ++k) {
            var2patients[k] = false;
            for (int l = 0; l < patients.size(); ++l) {
                if (!((String)patients.get(l)).equals(this.otherValues.get(k)[0])) continue;
                var2patients[k] = true;
            }
        }
        int alpha = 0;
        for (int k = 0; k < var2patients.length; ++k) {
            if (!var2patients[k]) continue;
            ++alpha;
        }
        HashMap<String, Integer> matrix = new HashMap<String, Integer>();
        for (String x : this.allVariableNames) {
            matrix.put(x, 0);
        }
        double of = 0.0;
        double nof = 0.0;
        for (int k = 0; k < this.otherValues.size(); ++k) {
            if (!var2patients[k]) continue;
            if (this.otherValues.get(k)[1].equals(this.foregroundvariable)) {
                of += 1.0;
                continue;
            }
            nof += 1.0;
        }
        ArrayList<Double> observed = new ArrayList<Double>();
        observed.add(of);
        observed.add(nof);
        double ef = 100.0;
        double otheref = 0.0;
        for (int i = 0; i < this.percentages.length; ++i) {
            if (this.allVariableNames.get(i).equals(this.foregroundvariable)) {
                ef = this.percentages[i] * (double)alpha;
                continue;
            }
            otheref += this.percentages[i];
        }
        ArrayList<Long> expected = new ArrayList<Long>();
        expected.add(Math.round(ef));
        expected.add(Math.round(otheref *= (double)alpha));
        String[] toChart = new String[this.allVariableNames.size()];
        toChart[0] = this.foregroundvariable;
        toChart[1] = "NOT " + this.foregroundvariable;
        Chart chart = null;
        chart = new ChartBuilder().chartType(StyleManager.ChartType.Bar).width(800).height(600).title("Number of Patients with status " + this.foregroundvariable + " in module, p = " + ChartDisplayFisher.roundToSignificantFigures(this.selectedP, 6)).xAxisTitle("Module - " + s).yAxisTitle("Number of Patients").theme(StyleManager.ChartTheme.GGPlot2).build();
        Series s1 = chart.addSeries("observed", new ArrayList<String>(Arrays.asList(toChart[0], toChart[1])), new ArrayList<Number>(Arrays.asList((Number)observed.get(0), (Number)observed.get(1))));
        Series s2 = chart.addSeries("expected", new ArrayList<String>(Arrays.asList(toChart[0], toChart[1])), new ArrayList<Number>(Arrays.asList((Number)expected.get(0), (Number)expected.get(1))));
        s1.setMarkerColor(Color.orange);
        s1.setLineColor(Color.orange);
        s2.setMarkerColor(Color.gray);
        s2.setLineColor(Color.gray);
        new SwingWrapper(chart, 0.0).displayFisherChart();
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }
}

