/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal;

import com.xeiam.xchart.Chart;
import com.xeiam.xchart.XChartPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SwingWrapper {
    private List<Chart> charts = new ArrayList<Chart>();
    private int numRows;
    private int numColumns;
    private double d;

    public SwingWrapper(Chart chart, Double d) {
        this.d = d;
        this.charts.add(chart);
    }

    public SwingWrapper(List<Chart> charts) {
        this.charts = charts;
        this.numRows = (int)(Math.sqrt(charts.size()) + 0.5);
        this.numColumns = (int)((double)charts.size() / (double)this.numRows + 1.0);
    }

    public SwingWrapper(List<Chart> charts, int numRows, int numColumns) {
        this.charts = charts;
        this.numRows = numRows;
        this.numColumns = numColumns;
    }

    public void displayFisherChart() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Fisher's Exact Test Observed vs Expected");
                frame.setDefaultCloseOperation(2);
                XChartPanel chartPanel = new XChartPanel((Chart)SwingWrapper.this.charts.get(0));
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public void displayChart() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Kaplan-Meier Survival Curve Comparison - pValue: " + String.valueOf(SwingWrapper.this.d));
                frame.setDefaultCloseOperation(2);
                XChartPanel chartPanel = new XChartPanel((Chart)SwingWrapper.this.charts.get(0));
                frame.add((Component)chartPanel);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public void displayChartMatrix() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(2);
                frame.getContentPane().setLayout(new GridLayout(SwingWrapper.this.numRows, SwingWrapper.this.numColumns));
                for (Chart chart : SwingWrapper.this.charts) {
                    JPanel chartPanel;
                    if (chart != null) {
                        chartPanel = new XChartPanel(chart);
                        frame.add(chartPanel);
                        continue;
                    }
                    chartPanel = new JPanel();
                    frame.getContentPane().add(chartPanel);
                }
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

