/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import JSci.maths.statistics.ChiSqrDistribution;

public class CoxPh {
    private static final int LARGE = 22;
    private static final int SMALL = -200;
    private static int maxiter = 20;
    private static final int method = 1;
    private static final double EPS = Math.pow(10.0, -9.0);
    private static final double toler = Math.pow(2.220446 * Math.pow(10.0, -16.0), 0.75);
    private double[] weights;
    private double[] time;
    private double[] status;
    private double[] covar1;
    private double ll0;

    public CoxPh(int length, double[] time, double[] status, double[] covar1) {
        this.weights = new double[length];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 1.0;
        }
        this.time = time;
        this.status = status;
        this.covar1 = covar1;
    }

    public void coxInit() {
        double[][] covar2 = new double[1][this.covar1.length];
        covar2[0] = this.covar1;
        double[] coxResult2 = this.coxfit(this.time, this.status, covar2);
        this.ll0 = coxResult2[1];
    }

    public double cox(double[] covar0) {
        double[][] covar = new double[2][this.covar1.length];
        covar[0] = covar0;
        covar[1] = this.covar1;
        maxiter = 20;
        double[] coxResult = this.coxfit(this.time, this.status, covar);
        System.out.println(coxResult[1]);
        double subtract = coxResult[1] - this.ll0;
        double pValue = 1.0 - new ChiSqrDistribution(1.0).cumulative(Math.abs(2.0 * subtract));
        return pValue;
    }

    public double[] coxfit(double[] time, double[] status, double[][] covar) {
        int flag;
        int person;
        int i;
        int[] strata = new int[time.length];
        int nused = time.length;
        int nvar = covar.length;
        double denom = 0.0;
        double newlk = 0.0;
        double[] a = new double[nvar];
        double[] newbeta = new double[nvar];
        double[] a2 = new double[nvar];
        double[] mark = new double[nused];
        double[] wtave = new double[nused];
        double[] means = new double[nvar];
        double[][] imat = new double[nvar][nvar];
        double[][] cmat = new double[nvar][nvar];
        double[][] cmat2 = new double[nvar][nvar];
        double[] loglik = new double[2];
        double[] u = new double[nvar];
        double[] offset = new double[nused];
        double[] beta = new double[nvar];
        int sctest = 1;
        double temp = 0.0;
        int j = 0;
        for (i = nused - 1; i > 0; --i) {
            if (time[i] == time[i - 1] && strata[i - 1] != 1) {
                j = (int)((double)j + status[i]);
                temp += status[i] * this.weights[i];
                mark[i] = 0.0;
                continue;
            }
            mark[i] = (double)j + status[i];
            if (mark[i] > 0.0) {
                wtave[i] = (temp + status[i] * this.weights[i]) / mark[i];
            }
            temp = 0.0;
            j = 0;
        }
        mark[0] = (double)j + status[0];
        if (mark[0] > 0.0) {
            wtave[0] = (temp + status[0] * this.weights[0]) / mark[0];
        }
        for (i = 0; i < nvar; ++i) {
            temp = 0.0;
            for (person = 0; person < nused; ++person) {
                temp += covar[i][person];
            }
            means[i] = temp /= (double)nused;
            person = 0;
            while (person < nused) {
                double[] dArray = covar[i];
                int n = person++;
                dArray[n] = dArray[n] - temp;
            }
        }
        strata[nused - 1] = 1;
        loglik[1] = 0.0;
        for (i = 0; i < nvar; ++i) {
            u[i] = 0.0;
            for (j = 0; j < nvar; ++j) {
                imat[i][j] = 0.0;
            }
        }
        double efron_wt = 0.0;
        for (person = nused - 1; person >= 0; --person) {
            double temp2;
            double d2;
            int k;
            int person2 = person;
            if (strata[person] == 1) {
                denom = 0.0;
                for (i = 0; i < nvar; ++i) {
                    a[i] = 0.0;
                    a2[i] = 0.0;
                    for (j = 0; j < nvar; ++j) {
                        cmat[i][j] = 0.0;
                        cmat2[i][j] = 0.0;
                    }
                }
            }
            double zbeta = offset[person];
            for (i = 0; i < nvar; ++i) {
                zbeta += beta[i] * covar[i][person];
            }
            zbeta = this.coxsafe(zbeta);
            double risk = Math.exp(zbeta) * this.weights[person];
            denom += risk;
            efron_wt += status[person] * risk;
            for (i = 0; i < nvar; ++i) {
                int n = i;
                a[n] = a[n] + risk * covar[i][person];
                for (j = 0; j <= i; ++j) {
                    double[] dArray = cmat[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + risk * covar[i][person] * covar[j][person];
                }
            }
            if (status[person] == 1.0) {
                loglik[1] = loglik[1] + this.weights[person] * zbeta;
                for (i = 0; i < nvar; ++i) {
                    int n = i;
                    u[n] = u[n] + this.weights[person] * covar[i][person];
                    int n3 = i;
                    a2[n3] = a2[n3] + risk * covar[i][person];
                    for (j = 0; j <= i; ++j) {
                        double[] dArray = cmat2[i];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + risk * covar[i][person] * covar[j][person];
                    }
                }
            }
            if (mark[person] > 0.0) {
                double ndead = mark[person];
                k = 0;
                while ((double)k < ndead) {
                    temp = (double)k * 1.0 / ndead;
                    d2 = denom - temp * efron_wt;
                    loglik[1] = loglik[1] - wtave[person] * Math.log(d2);
                    for (i = 0; i < nvar; ++i) {
                        temp2 = (a[i] - temp * a2[i]) / d2;
                        int n = i;
                        u[n] = u[n] - wtave[person] * temp2;
                        for (j = 0; j <= i; ++j) {
                            double[] dArray = imat[j];
                            int n5 = i;
                            dArray[n5] = dArray[n5] + wtave[person] * ((cmat[i][j] - temp * cmat2[i][j]) / d2 - temp2 * (a[j] - temp * a2[j]) / d2);
                        }
                    }
                    ++k;
                }
                efron_wt = 0.0;
                for (i = 0; i < nvar; ++i) {
                    a2[i] = 0.0;
                    for (j = 0; j < nvar; ++j) {
                        cmat2[i][j] = 0.0;
                    }
                }
            }
            loglik[0] = loglik[1];
            for (i = 0; i < nvar; ++i) {
                a[i] = u[i];
            }
            flag = this.cholesky2(imat, nvar, toler);
            this.chsolve2(imat, nvar, a);
            sctest = 0;
            for (i = 0; i < nvar; ++i) {
                sctest = (int)((double)sctest + u[i] * a[i]);
            }
            for (i = 0; i < nvar; ++i) {
                newbeta[i] = beta[i] + a[i];
            }
            if (maxiter == 0) {
                this.chinv2(imat, nvar);
                for (i = 1; i < nvar; ++i) {
                    for (j = 0; j < i; ++j) {
                        imat[i][j] = imat[j][i];
                    }
                }
                return null;
            }
            boolean halving = false;
            for (int iter = 1; iter <= maxiter; ++iter) {
                newlk = 0.0;
                for (i = 0; i < nvar; ++i) {
                    u[i] = 0.0;
                    for (j = 0; j < nvar; ++j) {
                        imat[i][j] = 0.0;
                    }
                }
                for (person = nused - 1; person >= 0; --person) {
                    if (strata[person] == 1) {
                        efron_wt = 0.0;
                        denom = 0.0;
                        for (i = 0; i < nvar; ++i) {
                            a[i] = 0.0;
                            a2[i] = 0.0;
                            for (j = 0; j < nvar; ++j) {
                                cmat[i][j] = 0.0;
                                cmat2[i][j] = 0.0;
                            }
                        }
                    }
                    zbeta = offset[person];
                    for (i = 0; i < nvar; ++i) {
                        zbeta += newbeta[i] * covar[i][person];
                    }
                    zbeta = this.coxsafe(zbeta);
                    risk = Math.exp(zbeta) * this.weights[person];
                    denom += risk;
                    efron_wt += status[person] * risk;
                    for (i = 0; i < nvar; ++i) {
                        int n = i;
                        a[n] = a[n] + risk * covar[i][person];
                        for (j = 0; j <= i; ++j) {
                            double[] dArray = cmat[i];
                            int n6 = j;
                            dArray[n6] = dArray[n6] + risk * covar[i][person] * covar[j][person];
                        }
                    }
                    if (status[person] == 1.0) {
                        newlk += this.weights[person] * zbeta;
                        for (i = 0; i < nvar; ++i) {
                            int n = i;
                            u[n] = u[n] + this.weights[person] * covar[i][person];
                            int n7 = i;
                            a2[n7] = a2[n7] + risk * covar[i][person];
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = cmat2[i];
                                int n8 = j;
                                dArray[n8] = dArray[n8] + risk * covar[i][person] * covar[j][person];
                            }
                        }
                    }
                    if (!(mark[person] > 0.0)) continue;
                    k = 0;
                    while ((double)k < mark[person]) {
                        temp = (double)k * 1.0 / mark[person];
                        d2 = denom - temp * efron_wt;
                        newlk -= wtave[person] * Math.log(d2);
                        for (i = 0; i < nvar; ++i) {
                            temp2 = (a[i] - temp * a2[i]) / d2;
                            int n = i;
                            u[n] = u[n] - wtave[person] * temp2;
                            for (j = 0; j <= i; ++j) {
                                double[] dArray = imat[j];
                                int n9 = i;
                                dArray[n9] = dArray[n9] + wtave[person] * ((cmat[i][j] - temp * cmat2[i][j]) / d2 - temp2 * (a[j] - temp * a2[j]) / d2);
                            }
                        }
                        ++k;
                    }
                    efron_wt = 0.0;
                    for (i = 0; i < nvar; ++i) {
                        a2[i] = 0.0;
                        for (j = 0; j < nvar; ++j) {
                            cmat2[i][j] = 0.0;
                        }
                    }
                }
                flag = this.cholesky2(imat, nvar, toler);
                if (Math.abs(1.0 - loglik[1] / newlk) <= EPS && !halving) {
                    loglik[1] = newlk;
                    this.chinv2(imat, nvar);
                    for (i = 1; i < nvar; ++i) {
                        for (j = 0; j < i; ++j) {
                            imat[i][j] = imat[j][i];
                        }
                    }
                    for (i = 0; i < nvar; ++i) {
                        beta[i] = newbeta[i];
                    }
                    maxiter = iter;
                    return loglik;
                }
                if (iter == maxiter) break;
                if (newlk < loglik[1]) {
                    halving = true;
                    for (i = 0; i < nvar; ++i) {
                        newbeta[i] = (newbeta[i] + beta[i]) / 2.0;
                    }
                    continue;
                }
                halving = false;
                loglik[1] = newlk;
                this.chsolve2(imat, nvar, u);
                j = 0;
                for (i = 0; i < nvar; ++i) {
                    beta[i] = newbeta[i];
                    newbeta[i] = newbeta[i] + u[i];
                }
            }
            person = person2;
        }
        loglik[1] = newlk;
        this.chinv2(imat, nvar);
        for (i = 1; i < nvar; ++i) {
            for (j = 0; j < i; ++j) {
                imat[i][j] = imat[j][i];
            }
        }
        for (i = 0; i < nvar; ++i) {
            beta[i] = newbeta[i];
        }
        flag = 1000;
        return loglik;
    }

    public int cholesky2(double[][] matrix, int n, double toler) {
        int j;
        int i;
        int nonneg = 1;
        double eps = Math.pow(10.0, -15.0);
        for (i = 0; i < n; ++i) {
            if (matrix[i][i] > eps) {
                eps = matrix[i][i];
            }
            for (j = i + 1; j < n; ++j) {
                matrix[j][i] = matrix[i][j];
            }
        }
        eps *= toler;
        int rank = 0;
        for (i = 0; i < n; ++i) {
            double pivot = matrix[i][i];
            if (pivot < eps) {
                matrix[i][i] = 0.0;
                if (!(pivot < -8.0 * eps)) continue;
                nonneg = -1;
                continue;
            }
            ++rank;
            for (j = i + 1; j < n; ++j) {
                double temp;
                matrix[j][i] = temp = matrix[j][i] / pivot;
                double[] dArray = matrix[j];
                int n2 = j;
                dArray[n2] = dArray[n2] - temp * temp * pivot;
                for (int k = j + 1; k < n; ++k) {
                    double[] dArray2 = matrix[k];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] - temp * matrix[k][i];
                }
            }
        }
        return rank * nonneg;
    }

    public void chsolve2(double[][] matrix, int n, double[] y) {
        int j;
        double temp;
        int i;
        for (i = 0; i < n; ++i) {
            temp = y[i];
            for (j = 0; j < i; ++j) {
                temp -= y[j] * matrix[i][j];
            }
            y[i] = temp;
        }
        for (i = n - 1; i >= 0; --i) {
            if (matrix[i][i] == 0.0) {
                y[i] = 0.0;
                continue;
            }
            temp = y[i] / matrix[i][i];
            for (j = i + 1; j < n; ++j) {
                temp -= y[j] * matrix[j][i];
            }
            y[i] = temp;
        }
    }

    public void chinv2(double[][] matrix, int n) {
        int k;
        int j;
        int i;
        for (i = 0; i < n; ++i) {
            if (!(matrix[i][i] > 0.0)) continue;
            matrix[i][i] = 1.0 / matrix[i][i];
            for (j = i + 1; j < n; ++j) {
                matrix[j][i] = -matrix[j][i];
                for (k = 0; k < i; ++k) {
                    double[] dArray = matrix[j];
                    int n2 = k;
                    dArray[n2] = dArray[n2] + matrix[j][i] * matrix[i][k];
                }
            }
        }
        for (i = 0; i < n; ++i) {
            if (matrix[i][i] == 0.0) {
                for (j = 0; j < i; ++j) {
                    matrix[j][i] = 0.0;
                }
                for (j = i; j < n; ++j) {
                    matrix[i][j] = 0.0;
                }
                continue;
            }
            for (j = i + 1; j < n; ++j) {
                double temp = matrix[j][i] * matrix[j][j];
                if (j != i) {
                    matrix[i][j] = temp;
                }
                for (k = i; k < j; ++k) {
                    double[] dArray = matrix[i];
                    int n3 = k;
                    dArray[n3] = dArray[n3] + temp * matrix[j][k];
                }
            }
        }
    }

    public double coxsafe(double a) {
        if (a < -200.0) {
            return -200.0;
        }
        if (a > 22.0) {
            return 22.0;
        }
        return a;
    }
}

