/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FDRAdjust {
    private HashMap<String, Double> this_true;
    private Multimap<String, Double> this_rand;
    private static final int RESULT_SCALE = 100;

    public FDRAdjust(HashMap<String, Double> this_true, Multimap<String, Double> this_rand) {
        this.this_true = this_true;
        this.this_rand = this_rand;
    }

    public HashMap<String, Double> fdrAdjust() {
        int i;
        if (this.this_rand.isEmpty()) {
            return this.this_true;
        }
        HashMap<String, Double> adjustedResults = new HashMap<String, Double>();
        ArrayListMultimap reversedResults = ArrayListMultimap.create();
        for (String reverse : this.this_true.keySet()) {
            reversedResults.put((Object)this.this_true.get(reverse), (Object)reverse);
        }
        ArrayList<Double> resultDoubles = new ArrayList<Double>();
        int k = 0;
        for (String result : this.this_true.keySet()) {
            resultDoubles.add(this.this_true.get(result));
            ++k;
        }
        Collections.sort(resultDoubles);
        double[] randomResultDoubles = new double[this.this_rand.size()];
        k = 0;
        for (String result : this.this_rand.keySet()) {
            for (Double getDouble : this.this_rand.get((Object)result)) {
                randomResultDoubles[k] = getDouble;
                ++k;
            }
        }
        double[] toAdjust = new double[resultDoubles.size()];
        for (i = 0; i < toAdjust.length; ++i) {
            toAdjust[i] = this.lengthWhich((Double)resultDoubles.get(i), randomResultDoubles) / (double)randomResultDoubles.length;
        }
        for (i = 0; i < resultDoubles.size(); ++i) {
            for (String s : reversedResults.get(resultDoubles.get(i))) {
                adjustedResults.put(s, toAdjust[i]);
            }
        }
        return adjustedResults;
    }

    public double lengthWhich(double real, double[] random) {
        double count = 0.0;
        for (int i = 0; i < random.length; ++i) {
            if (!(random[i] <= real)) continue;
            count += 1.0;
        }
        return count;
    }
}

