/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import com.google.common.math.BigIntegerMath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class FishersExact {
    public int[][] thisMatrix;
    private int[] n;
    private int[] v;
    private int[] d;
    private int[] r;
    private int N;
    private int nRows;
    private int nColumns;
    private int[] columnTotals;
    private ArrayList<Double> pValues;

    public FishersExact(int[][] thisMatrix) {
        this.thisMatrix = thisMatrix;
    }

    public static void printMatrix(int[][] mat) {
        System.out.print("\n");
        for (int[] is : mat) {
            System.out.print("[");
            for (int i = 0; i < is.length; ++i) {
                System.out.print((i == 0 ? "" : ", ") + is[i]);
            }
            System.out.print("]\n");
        }
        System.out.print("\n");
    }

    public double fisher2c() {
        int i;
        double p = 0.0;
        int nRows = this.thisMatrix.length;
        int nColumns = this.thisMatrix[0].length;
        int[] rowTotals = new int[nRows];
        int[] columnTotals = new int[nColumns];
        for (i = 0; i < nRows; ++i) {
            rowTotals[i] = this.findSumRow(i, nColumns);
        }
        for (i = 0; i < nColumns; ++i) {
            columnTotals[i] = this.findSumColumn(i, nRows);
        }
        int N = 0;
        for (int i2 = 0; i2 < rowTotals.length; ++i2) {
            N += rowTotals[i2];
        }
        int[] n = new int[nRows + 1];
        int[] d = new int[nRows];
        int[] v = new int[nRows];
        int[] r = new int[nRows];
        n[0] = 0;
        for (int i3 = 1; i3 < n.length; ++i3) {
            n[i3] = rowTotals[i3 - 1];
        }
        d[0] = 0;
        v[0] = columnTotals[0];
        r[0] = N;
        this.n = n;
        this.r = r;
        this.v = v;
        this.d = d;
        this.nRows = nRows;
        this.nColumns = nColumns;
        this.columnTotals = columnTotals;
        this.N = N;
        this.pValues = new ArrayList();
        int level = 1;
        this.enumerate(level);
        for (int i4 = 1; i4 < nRows; ++i4) {
            d[i4] = this.thisMatrix[i4 - 1][0];
        }
        Double original = this.calculateStatistic();
        for (int i5 = 0; i5 < this.pValues.size(); ++i5) {
            if (!(this.pValues.get(i5) <= original)) continue;
            p += this.pValues.get(i5).doubleValue();
        }
        p = (double)Math.round(p * 1.0E8) / 1.0E8;
        return p;
    }

    private void enumerate(int level) {
        if (level == this.nRows) {
            this.pValues.add(this.calculateStatistic());
            return;
        }
        this.v[level] = this.v[level - 1] - this.d[level - 1];
        this.r[level] = this.r[level - 1] - this.n[level];
        int hibound = this.n[level] < this.v[level] ? this.n[level] : this.v[level];
        int lobound = this.v[level] - this.r[level] > 0 ? this.v[level] - this.r[level] : 0;
        int i = lobound;
        while (i <= hibound) {
            this.d[level] = i++;
            this.enumerate(level + 1);
        }
    }

    private Double calculateStatistic() {
        int i;
        int[][] matrix = new int[this.nRows][this.nColumns];
        int sum = 0;
        for (int i2 = 0; i2 < this.nRows - 1; ++i2) {
            sum += this.d[i2 + 1];
            matrix[i2][0] = this.d[i2 + 1];
        }
        BigInteger numerator = new BigInteger("1");
        BigInteger denominator = BigIntegerMath.factorial((int)this.N);
        matrix[this.nRows - 1][0] = this.columnTotals[0] - sum;
        for (i = 0; i < this.nRows; ++i) {
            matrix[i][1] = this.n[i + 1] - matrix[i][0];
            numerator = numerator.multiply(BigIntegerMath.factorial((int)this.n[i + 1]));
            denominator = denominator.multiply(BigIntegerMath.factorial((int)matrix[i][0]).multiply(BigIntegerMath.factorial((int)matrix[i][1])));
        }
        for (i = 0; i < this.nColumns; ++i) {
            numerator = numerator.multiply(BigIntegerMath.factorial((int)this.columnTotals[i]));
        }
        BigDecimal newNum = new BigDecimal(numerator);
        BigDecimal newDenom = new BigDecimal(denominator);
        BigDecimal statistic = newNum.divide(newDenom, 15, 1);
        return statistic.doubleValue();
    }

    private int findSumColumn(int column, int nRows) {
        int sum = 0;
        for (int i = 0; i < nRows; ++i) {
            sum += this.thisMatrix[i][column];
        }
        return sum;
    }

    private int findSumRow(int row, int nColumns) {
        int sum = 0;
        for (int i = 0; i < nColumns; ++i) {
            sum += this.thisMatrix[row][i];
        }
        return sum;
    }
}

