/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.statistics;

import jsc.contingencytables.ContingencyTable2x2;
import jsc.contingencytables.FishersExactTest;
import jsc.distributions.Hypergeometric;
import jsc.tests.H1;
import org.cytoscape.hypermodules.internal.statistics.SillyInputException;

public class MyFET {
    private int populationSize;
    private int totalSuccesses;
    private int sampleSize;
    private int sampleSuccesses;
    private ContingencyTable2x2 ct;
    private H1 alternative = H1.GREATER_THAN;
    private static final int OVERREP = 1;
    private static final int UNDERREP = -1;
    private static final int NOREP = 0;
    private int representation;
    private int[][] data;

    public MyFET(int populationSize, int totalSuccesses, int sampleSize, int sampleSuccesses) {
        try {
            this.setVariables(populationSize, totalSuccesses, sampleSize, sampleSuccesses);
        }
        catch (SillyInputException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public MyFET(int populationSize, int totalSuccesses, int sampleSize, int sampleSuccesses, H1 alternative) {
        try {
            this.alternative = alternative;
            this.setVariables(populationSize, totalSuccesses, sampleSize, sampleSuccesses);
        }
        catch (SillyInputException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public void setVariables(int populationSize, int totalSuccesses, int sampleSize, int sampleSuccesses) throws SillyInputException {
        this.populationSize = populationSize;
        this.totalSuccesses = totalSuccesses;
        this.sampleSize = sampleSize;
        this.sampleSuccesses = sampleSuccesses;
        this.testInput();
        double expectedProportion = ((double)totalSuccesses + 0.0) / (double)populationSize;
        double expectedSamSuc = (double)sampleSize * expectedProportion;
        this.representation = expectedSamSuc < (double)sampleSuccesses ? 1 : (expectedSamSuc > (double)sampleSuccesses ? -1 : 0);
        this.data = new int[2][2];
        this.data[0][0] = sampleSuccesses;
        this.data[0][1] = sampleSize - sampleSuccesses;
        this.data[1][0] = totalSuccesses - sampleSuccesses;
        this.data[1][1] = populationSize - this.data[0][0] - this.data[0][1] - this.data[1][0];
        this.ct = new ContingencyTable2x2(this.data);
    }

    public int getRepresentation() {
        return this.representation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getResult() {
        try {
            double pval = 0.0;
            if (this.ct.getFrequency(0, 0) != 0 && this.ct.getFrequency(1, 1) != 0 && this.ct.getFrequency(1, 0) != 0 && this.ct.getFrequency(0, 1) != 0) {
                FishersExactTest fet = new FishersExactTest(this.ct, H1.GREATER_THAN);
                pval = fet.getSP();
            } else {
                Hypergeometric hg = new Hypergeometric(this.sampleSize, this.populationSize, this.totalSuccesses);
                for (int ss = this.sampleSuccesses; ss <= Math.min(this.totalSuccesses, this.sampleSize); ++ss) {
                    pval += hg.pdf(ss);
                }
            }
            double d = pval;
            return d;
        }
        catch (Exception e) {
            double d = 1.0;
            return d;
        }
    }

    public Double getLogOdds() {
        double lodds2;
        double lodds1 = this.ct.getFrequency(1, 1) * this.ct.getFrequency(0, 0);
        Double lodds = lodds1 / (lodds2 = (double)(this.ct.getFrequency(0, 1) * this.ct.getFrequency(1, 0)));
        if (!lodds.isNaN() && !lodds.isInfinite()) {
            return Math.log(lodds);
        }
        if (lodds == Double.POSITIVE_INFINITY) {
            return 1000.0;
        }
        if (lodds == 0.0) {
            return -1000.0;
        }
        return lodds;
    }

    private boolean testNan(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    private void testInput() throws SillyInputException {
        if (this.populationSize < this.totalSuccesses) {
            this.throwException();
        } else if (this.populationSize < this.sampleSize) {
            this.throwException();
        } else if (this.sampleSize < this.sampleSuccesses) {
            this.throwException();
        } else if (this.totalSuccesses < this.sampleSuccesses) {
            this.throwException();
        }
    }

    private void throwException() throws SillyInputException {
        throw new SillyInputException(this.populationSize, this.totalSuccesses, this.sampleSize, this.sampleSuccesses);
    }
}

