/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.hypermodules.internal.task;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.cytoscape.hypermodules.internal.CytoscapeUtils;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;

public class GenerateNetworkTask
extends AbstractTask
implements Task {
    private String[] sas;
    private CyNetwork runNetwork;
    private CyNetwork generated;
    private CytoscapeUtils utils;
    private ArrayList<String[]> sampleValues;
    private HashSet<String> allSeeds;
    private HashMap<String, Double> allSamplesMap;
    private HashSet<String> inputHash;

    public GenerateNetworkTask(String[] sas, CyNetwork originalNetwork, CytoscapeUtils utils, ArrayList<String[]> sampleValues) {
        this.sas = sas;
        this.runNetwork = originalNetwork;
        this.utils = utils;
        this.sampleValues = sampleValues;
        this.allSeeds = new HashSet();
        for (int i = 0; i < sampleValues.size(); ++i) {
            if (sampleValues.get(i)[1].equals("no_sample")) continue;
            this.allSeeds.add(sampleValues.get(i)[0]);
        }
        this.allSamplesMap = new HashMap();
        HashMap<String, String> genes2samples = new HashMap<String, String>();
        for (int i = 0; i < sampleValues.size(); ++i) {
            if (genes2samples.get(sampleValues.get(i)[0]) != null) {
                String sti = (String)genes2samples.get(sampleValues.get(i)[0]);
                sti = sti + ":" + sampleValues.get(i)[1];
                genes2samples.put(sampleValues.get(i)[0], sti);
                continue;
            }
            genes2samples.put(sampleValues.get(i)[0], sampleValues.get(i)[1]);
        }
        for (String s : genes2samples.keySet()) {
            String d = (String)genes2samples.get(s);
            String[] st = d.split(":");
            this.allSamplesMap.put(s, Double.valueOf(st.length));
        }
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.generated = this.utils.networkFactory.createNetwork();
        this.generate(this.sas[0], this.sas[1]);
        this.applyVisualStyle();
    }

    public void applyVisualStyle() {
        this.generated.getDefaultNetworkTable().getRow((Object)this.generated.getSUID()).set("name", (Object)this.utils.networkNaming.getSuggestedNetworkTitle(this.sas[1]));
        this.utils.netMgr.addNetwork(this.generated);
        CyNetworkView myView = this.utils.netViewFactory.createNetworkView(this.generated);
        this.utils.netViewMgr.addNetworkView(myView);
        VisualStyle vs = this.utils.visualStyleFactoryServiceRef.createVisualStyle("My Visual Style");
        String ctrAttrName1 = "name";
        PassthroughMapping pMapping = (PassthroughMapping)this.utils.vmfFactoryP.createVisualMappingFunction(ctrAttrName1, String.class, BasicVisualLexicon.NODE_LABEL);
        vs.addVisualMappingFunction((VisualMappingFunction)pMapping);
        for (CyNode c : this.generated.getNodeList()) {
            View v;
            if (((String)this.generated.getRow((CyIdentifiable)c).get("name", String.class)).equals(this.sas[0])) {
                v = myView.getNodeView(c);
                v.setLockedValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.DIAMOND);
            }
            if (this.allSeeds.contains(this.generated.getRow((CyIdentifiable)c).get("name", String.class))) {
                v = myView.getNodeView(c);
                v.setLockedValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)Color.red);
                double d = 50.0;
                if (this.allSamplesMap.get(this.generated.getRow((CyIdentifiable)c).get("name", String.class)) == null) continue;
                v.setLockedValue(BasicVisualLexicon.NODE_SIZE, (Object)(d + 2.0 * this.allSamplesMap.get(this.generated.getRow((CyIdentifiable)c).get("name", String.class))));
                continue;
            }
            v = myView.getNodeView(c);
            v.setLockedValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)Color.gray);
        }
        this.utils.vmmServiceRef.addVisualStyle(vs);
        vs.apply(myView);
        myView.updateView();
        CyLayoutAlgorithm layout = this.utils.cyLayoutManager.getLayout("force-directed");
        String layoutAttribute = null;
        this.insertTasksAfterCurrentTask(layout.createTaskIterator(myView, layout.createLayoutContext(), CyLayoutAlgorithm.ALL_NODE_VIEWS, layoutAttribute));
    }

    public void generate(String s, String t) {
        String[] inputStrings = t.split(":");
        this.inputHash = new HashSet();
        for (int i = 0; i < inputStrings.length; ++i) {
            this.inputHash.add(inputStrings[i]);
        }
        this.newVisualize();
    }

    public void newVisualize() {
        String curNodeName;
        List cc = this.runNetwork.getNodeList();
        HashSet<CyNode> inNodes = new HashSet<CyNode>();
        for (int k = 0; k < cc.size(); ++k) {
            CyNode nod = null;
            if (!this.inputHash.contains(this.runNetwork.getRow((CyIdentifiable)cc.get(k)).get("name", String.class))) continue;
            nod = (CyNode)cc.get(k);
            inNodes.add(nod);
        }
        for (CyNode c : inNodes) {
            curNodeName = (String)this.runNetwork.getRow((CyIdentifiable)c).get("name", String.class);
            long curNodeID = c.getSUID();
            c = this.generated.addNode();
            this.generated.getRow((CyIdentifiable)c).set("name", (Object)curNodeName);
            c = this.runNetwork.getNode(curNodeID);
        }
        for (CyNode c : inNodes) {
            curNodeName = (String)this.runNetwork.getRow((CyIdentifiable)c).get("name", String.class);
            for (CyEdge edge : this.runNetwork.getAdjacentEdgeList(c, CyEdge.Type.ANY)) {
                int k;
                CyNode foundTarget;
                CyNode cInGenerated;
                List mycc = this.generated.getNodeList();
                CyNode target = edge.getTarget();
                String targetString = (String)this.runNetwork.getRow((CyIdentifiable)target).get("name", String.class);
                if (this.inputHash.contains(targetString) && !curNodeName.equals(targetString)) {
                    cInGenerated = null;
                    foundTarget = null;
                    for (k = 0; k < mycc.size(); ++k) {
                        if (curNodeName.equals(this.generated.getRow((CyIdentifiable)mycc.get(k)).get("name", String.class))) {
                            cInGenerated = (CyNode)mycc.get(k);
                        }
                        if (!targetString.equals(this.generated.getRow((CyIdentifiable)mycc.get(k)).get("name", String.class))) continue;
                        foundTarget = (CyNode)mycc.get(k);
                    }
                    if (!this.generated.containsEdge(cInGenerated, foundTarget)) {
                        this.generated.addEdge(cInGenerated, foundTarget, true);
                    }
                }
                if (!this.inputHash.contains(targetString = (String)this.runNetwork.getRow((CyIdentifiable)(target = edge.getSource())).get("name", String.class)) || curNodeName.equals(targetString)) continue;
                cInGenerated = null;
                foundTarget = null;
                for (k = 0; k < mycc.size(); ++k) {
                    if (curNodeName.equals(this.generated.getRow((CyIdentifiable)mycc.get(k)).get("name", String.class))) {
                        cInGenerated = (CyNode)mycc.get(k);
                    }
                    if (!targetString.equals(this.generated.getRow((CyIdentifiable)mycc.get(k)).get("name", String.class))) continue;
                    foundTarget = (CyNode)mycc.get(k);
                }
                if (this.generated.containsEdge(cInGenerated, foundTarget)) continue;
                this.generated.addEdge(cInGenerated, foundTarget, true);
            }
        }
    }

    public void visualizeRecursive(String s, String parent, int level) {
        List cc = this.runNetwork.getNodeList();
        CyNode seed = null;
        for (int k = 0; k < cc.size(); ++k) {
            if (!s.equals(this.runNetwork.getRow((CyIdentifiable)cc.get(k)).get("name", String.class))) continue;
            seed = (CyNode)cc.get(k);
        }
        long seedID = seed.getSUID();
        String seedString = s;
        seed = this.generated.addNode();
        this.generated.getRow((CyIdentifiable)seed).set("name", (Object)seedString);
        long mySeedID = seed.getSUID();
        if (parent != null) {
            CyNode par = null;
            List gg = this.generated.getNodeList();
            for (int k = 0; k < gg.size(); ++k) {
                if (!parent.equals(this.generated.getRow((CyIdentifiable)gg.get(k)).get("name", String.class))) continue;
                par = (CyNode)gg.get(k);
            }
            this.generated.addEdge(par, seed, true);
        }
        seed = this.runNetwork.getNode(seedID);
        for (CyEdge edge : this.runNetwork.getAdjacentEdgeList(seed, CyEdge.Type.ANY)) {
            CyNode seedHolder = this.generated.getNode(mySeedID);
            CyNode target = edge.getTarget();
            String targetString = (String)this.runNetwork.getRow((CyIdentifiable)target).get("name", String.class);
            if (this.inputHash.contains(targetString)) {
                this.inputHash.remove(targetString);
                if (level == 0) {
                    target = this.generated.addNode();
                    this.generated.addEdge(seedHolder, target, true);
                    this.generated.getRow((CyIdentifiable)target).set("name", (Object)targetString);
                } else {
                    this.visualizeRecursive(targetString, seedString, level - 1);
                }
            }
            if (!this.inputHash.contains(targetString = (String)this.runNetwork.getRow((CyIdentifiable)(target = edge.getSource())).get("name", String.class))) continue;
            this.inputHash.remove(targetString);
            if (level == 0) {
                target = this.generated.addNode();
                this.generated.addEdge(seedHolder, target, true);
                this.generated.getRow((CyIdentifiable)target).set("name", (Object)targetString);
                continue;
            }
            this.visualizeRecursive(targetString, seedString, level - 1);
        }
    }

    public void visualize(String s, String t) {
        System.out.println("visualizing network...");
        String[] inputStrings = t.split(":");
        HashMap inputNodes = new HashMap();
        List cc = this.runNetwork.getNodeList();
        CyNode seed = null;
        for (int k = 0; k < cc.size(); ++k) {
            if (!s.equals(this.runNetwork.getRow((CyIdentifiable)cc.get(k)).get("name", String.class))) continue;
            seed = (CyNode)cc.get(k);
        }
        long seedID = seed.getSUID();
        String seedString = (String)this.runNetwork.getRow(seed).get("name", String.class);
        HashSet<String> inputHash = new HashSet<String>();
        for (int i = 0; i < inputStrings.length; ++i) {
            inputHash.add(inputStrings[i]);
        }
        HashSet<String> myNetNames = new HashSet<String>();
        seed = this.generated.addNode();
        this.generated.getRow((CyIdentifiable)seed).set("name", (Object)seedString);
        long mySeedID = seed.getSUID();
        myNetNames.add(seedString);
        seed = this.runNetwork.getNode(seedID);
        for (CyEdge edge : this.runNetwork.getAdjacentEdgeList(seed, CyEdge.Type.ANY)) {
            seed = this.generated.getNode(mySeedID);
            CyNode target = edge.getTarget();
            long targetID = target.getSUID();
            String targetString = (String)this.runNetwork.getRow((CyIdentifiable)target).get("name", String.class);
            if (inputHash.contains(targetString)) {
                String innerTargetName;
                CyNode innerTarget;
                long myTargetID;
                if (!myNetNames.contains(targetString)) {
                    target = this.generated.addNode();
                    this.generated.getRow((CyIdentifiable)target).set("name", (Object)targetString);
                    myNetNames.add(targetString);
                    this.generated.addEdge(seed, target, true);
                    myTargetID = target.getSUID();
                    target = this.runNetwork.getNode(targetID);
                    for (CyEdge innerEdge : this.runNetwork.getAdjacentEdgeList(target, CyEdge.Type.ANY)) {
                        innerTarget = innerEdge.getTarget();
                        innerTargetName = (String)this.runNetwork.getRow((CyIdentifiable)innerTarget).get("name", String.class);
                        if (!inputHash.contains(innerTargetName)) continue;
                        target = this.generated.getNode(myTargetID);
                        if (!myNetNames.contains(innerTargetName)) {
                            innerTarget = this.generated.addNode();
                            this.generated.addEdge(target, innerTarget, true);
                            this.generated.getRow((CyIdentifiable)innerTarget).set("name", (Object)innerTargetName);
                            myNetNames.add(innerTargetName);
                        } else {
                            for (CyNode e : this.generated.getNodeList()) {
                                if (!innerTargetName.equals(this.generated.getRow((CyIdentifiable)e).get("name", String.class))) continue;
                                innerTarget = e;
                            }
                            if (!this.generated.containsEdge(target, innerTarget)) {
                                this.generated.addEdge(target, innerTarget, true);
                            }
                        }
                        target = this.runNetwork.getNode(targetID);
                    }
                } else {
                    for (CyNode c : this.generated.getNodeList()) {
                        if (!targetString.equals(this.generated.getRow((CyIdentifiable)c).get("name", String.class))) continue;
                        target = c;
                    }
                    myTargetID = target.getSUID();
                    if (!this.generated.containsEdge(seed, target)) {
                        this.generated.addEdge(seed, target, true);
                    }
                    target = this.runNetwork.getNode(targetID);
                    for (CyEdge innerEdge : this.runNetwork.getAdjacentEdgeList(target, CyEdge.Type.ANY)) {
                        innerTarget = innerEdge.getTarget();
                        innerTargetName = (String)this.runNetwork.getRow((CyIdentifiable)innerTarget).get("name", String.class);
                        if (!inputHash.contains(innerTargetName)) continue;
                        target = this.generated.getNode(myTargetID);
                        if (!myNetNames.contains(innerTargetName)) {
                            innerTarget = this.generated.addNode();
                            this.generated.addEdge(target, innerTarget, true);
                            this.generated.getRow((CyIdentifiable)innerTarget).set("name", (Object)innerTargetName);
                            myNetNames.add(innerTargetName);
                        } else {
                            for (CyNode d : this.generated.getNodeList()) {
                                if (!innerTargetName.equals(this.generated.getRow((CyIdentifiable)d).get("name", String.class))) continue;
                                innerTarget = d;
                            }
                            if (!this.generated.containsEdge(target, innerTarget)) {
                                this.generated.addEdge(target, innerTarget, true);
                            }
                        }
                        target = this.runNetwork.getNode(targetID);
                    }
                }
            }
            seed = this.runNetwork.getNode(seedID);
        }
    }

    public void cancel() {
    }
}

