package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.LolaParameterSet;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Jun 28, 2007
 * Time: 11:58:29 PM
 * To change this template use File | Settings | File Templates.
 */
public class DuplicateProfilesAndLogosAction implements ActionListener {
    private ProfileSet fromProfileSet;
    private ProfileSet toProfileSet;
    LolaParameterSet paramSet;

    public DuplicateProfilesAndLogosAction(ProfileSet fromProfileSet, ProfileSet toProfileSet, LolaParameterSet params) {
        super();
        this.fromProfileSet = fromProfileSet;
        this.toProfileSet = toProfileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        //save logo image for each profile
        for (int i = 0; i < fromProfileSet.size(); i++) {
            Profile profile = ((Profile) fromProfileSet.get(i)).copy();
            profile.setImage(LogoGenerator.generateImage(profile.getProteinProfile(), paramSet, "_logo"));
            toProfileSet.addElement(profile);
        }
    }
}
