package org.baderlab.lola.view.actions;

import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.brain.ProfileSearchProjectFile;
import org.baderlab.brain.BrainAlgorithm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.File;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Aug 1, 2007
 * Time: 5:07:39 PM
 * To change this template use File | Settings | File Templates.
 */
public class MakeLogoTreeAction implements ActionListener {
    private ProfileSet profileSet;
    LolaParameterSet paramSet;

    public MakeLogoTreeAction(ProfileSet profileSet, LolaParameterSet params) {
        super();
        this.profileSet = profileSet;
        this.paramSet = params;

    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean isProjectFile = false;

        //determine if we're dealing with a project file or a single protein profile
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        try {
            if (profileProjectFile.isProjectFile(paramSet.getProfileFile().toString())) {
                isProjectFile = true;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        //logo tree only applies to a project file
        if (isProjectFile) {
            BrainAlgorithm alg = new BrainAlgorithm();

            String outputPath = paramSet.getOutputPath() + File.separator + paramSet.getTreeFilename();
            System.out.println("Generating logo tree for profile " + paramSet.getProfileFile().toString());



            BufferedImage image = alg.runAlignedProfileCluster(
                    paramSet.getProfileFile().toString(),
                    paramSet.getTreeTitle(),
                    new File(outputPath), false);

            LogoTree tree = new LogoTree();
            tree.setOutputFilePath(outputPath);
            tree.setIsSaved(false);
            tree.setImage(image);

            profileSet.setLogoTree(tree);
        }

        



    }
}
