/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.readers.MetadataParser;
import cytoscape.data.readers.VisualStyleBuilder;
import cytoscape.data.readers.XGMMLException;
import cytoscape.generated2.Att;
import cytoscape.generated2.GraphicEdge;
import cytoscape.generated2.GraphicGraph;
import cytoscape.generated2.GraphicNode;
import cytoscape.generated2.Graphics;
import cytoscape.generated2.ObjectType;
import cytoscape.generated2.RdfRDF;
import cytoscape.generated2.TypeGraphicsType;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.LineType;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XGMMLReader
extends AbstractGraphReader {
    private static final String METANODE_KEY = "__metaNodeRindices";
    protected static final String GRAPH = "graph";
    protected static final String NODE = "node";
    protected static final String EDGE = "edge";
    protected static final String GRAPHICS = "graphics";
    protected static final String LABEL = "label";
    protected static final String SOURCE = "source";
    protected static final String TARGET = "target";
    protected static final String RECTANGLE = "rectangle";
    protected static final String ELLIPSE = "ellipse";
    protected static final String LINE = "Line";
    protected static final String POINT = "point";
    protected static final String DIAMOND = "diamond";
    protected static final String HEXAGON = "hexagon";
    protected static final String OCTAGON = "octagon";
    protected static final String PARALELLOGRAM = "parallelogram";
    protected static final String TRIANGLE = "triangle";
    protected static final String BOX = "box";
    protected static final String CIRCLE = "circle";
    protected static final String VELLIPSIS = "ver_ellipsis";
    protected static final String HELLIPSIS = "hor_ellipsis";
    protected static final String RHOMBUS = "rhombus";
    protected static final String PENTAGON = "pentagon";
    private static final String XGMML_PACKAGE = "cytoscape.generated2";
    private String networkName = null;
    private List<GraphicNode> nodes;
    private List<GraphicEdge> edges;
    private RdfRDF metadata;
    private String backgroundColor;
    private Double graphViewZoom;
    private Double graphViewCenterX;
    private Double graphViewCenterY;
    private InputStream networkStream;
    private IntArrayList giny_nodes;
    private IntArrayList giny_edges;
    private ArrayList rootNodes;
    private ArrayList metaTree;
    private CyAttributes networkCyAttributes = Cytoscape.getNetworkAttributes();
    private HashMap<String, Graphics> nodeGraphicsMap;
    private HashMap<String, Graphics> edgeGraphicsMap;
    private HashMap nodeMap;
    private List<Att> networkAtt;
    private Properties prop = CytoscapeInit.getProperties();
    private String vsbSwitch = this.prop.getProperty("visualStyleBuilder");
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    private int nextID = 0;

    public XGMMLReader(String fileName) {
        this(fileName, null);
    }

    public XGMMLReader(InputStream is) {
        super("InputStream");
        this.networkStream = is;
        this.initialize();
    }

    public XGMMLReader(String fileName, TaskMonitor monitor) {
        super(fileName);
        this.taskMonitor = monitor;
        this.percentUtil = new PercentUtil(3);
        this.networkStream = FileUtil.getInputStream(fileName, monitor);
        this.initialize();
    }

    private void initialize() {
        this.nodes = new ArrayList<GraphicNode>();
        this.edges = new ArrayList<GraphicEdge>();
        this.nodeGraphicsMap = new HashMap();
        this.edgeGraphicsMap = new HashMap();
        this.metaTree = new ArrayList();
    }

    @Override
    public void read() throws IOException {
        try {
            this.readXGMML();
        }
        catch (JAXBException e) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setException((Throwable)e, e.getMessage());
            }
            throw new IOException("Cannot unmarshall given XGMML file.  Given XGMML file may contain invalid entry: " + e.getMessage());
        }
    }

    private void readXGMML() throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)XGMML_PACKAGE, (ClassLoader)this.getClass().getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        try {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(-1);
                this.taskMonitor.setStatus("Reading XGMML data...");
            }
            JAXBElement graphicGraphElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new BufferedInputStream(this.networkStream));
            this.networkName = ((GraphicGraph)graphicGraphElement.getValue()).getLabel();
            this.networkAtt = ((GraphicGraph)graphicGraphElement.getValue()).getAtt();
            if (this.taskMonitor != null) {
                this.taskMonitor.setStatus("XGMML file is valid.  Next, create network...");
            }
            this.rootNodes = new ArrayList();
            this.getNodesAndEdges((GraphicGraph)graphicGraphElement.getValue(), null);
            this.createGraph();
        }
        catch (OutOfMemoryError oe) {
            this.nodes = null;
            this.edges = null;
            this.nodeMap = null;
            System.gc();
            throw new XGMMLException("Out of memory error caught! The network being loaded is too large for the current memory allocation.  Use the -Xmx flag for the java virtual machine to increase the amount of memory available, e.g. java -Xmx1G cytoscape.jar -p plugins ....");
        }
        finally {
            Object graphicGraphElement = null;
            if (this.networkStream != null) {
                this.networkStream.close();
                this.networkStream = null;
            }
        }
    }

    protected void getNodesAndEdges(GraphicGraph network, GraphicNode parent) {
        List<Object> nodesAndEdges = network.getNodeOrEdge();
        ArrayList<Object> metaChildren = new ArrayList<Object>();
        for (Object curObj : nodesAndEdges) {
            if (curObj.getClass() == GraphicNode.class) {
                this.addNode((GraphicNode)curObj);
                metaChildren.add(curObj);
                continue;
            }
            if (curObj.getClass() != GraphicEdge.class) continue;
            this.edges.add((GraphicEdge)curObj);
        }
        if (parent != null) {
            this.metaTree.add(parent.getLabel());
            this.metaTree.add(metaChildren);
        }
    }

    protected void addNode(GraphicNode curNode) {
        String label = curNode.getLabel();
        String nodeId = curNode.getId();
        if (nodeId == null && curNode.getHref() == null) {
            if (label != null) {
                curNode.setId(label);
            } else {
                curNode.setId("CyNode-" + this.nextID);
                ++this.nextID;
            }
        } else if (curNode.getHref() != null) {
            return;
        }
        if (label == null) {
            curNode.setLabel(curNode.getId());
        }
        this.nodes.add(curNode);
        this.readNodeAttributes(curNode.getLabel(), curNode.getAtt(), curNode);
    }

    private void createGraph() {
        int nodeCount = this.nodes.size();
        int edgeCount = this.edges.size();
        Cytoscape.ensureCapacity(nodeCount, edgeCount);
        this.giny_nodes = new IntArrayList(nodeCount);
        HashMap<String, Integer> gml_id2order = new HashMap<String, Integer>(nodeCount);
        HashSet<String> nodeNameSet = new HashSet<String>(nodeCount);
        this.nodeMap = new HashMap(nodeCount);
        GraphicNode curNode = null;
        String label = null;
        for (int idx = nodeCount - 1; idx >= 0; --idx) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, idx, this.nodes.size()));
            }
            curNode = this.nodes.get(idx);
            label = curNode.getLabel();
            this.nodeMap.put(curNode.getId(), label);
            if (!nodeNameSet.add(curNode.getId())) {
                throw new XGMMLException("XGMML id " + this.nodes.get(idx) + " has a duplicated label: " + label);
            }
            this.giny_nodes.add(Cytoscape.getCyNode(label, true).getRootGraphIndex());
            gml_id2order.put(curNode.getId(), idx);
        }
        this.giny_edges = new IntArrayList(edgeCount);
        CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
        for (int idx = edgeCount - 1; idx >= 0; --idx) {
            CyEdge edge;
            String edgeName;
            GraphicEdge curEdge;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, idx, this.edges.size()));
            }
            if (gml_id2order.containsKey((curEdge = this.edges.get(idx)).getSource()) && gml_id2order.containsKey(curEdge.getTarget())) {
                edgeName = curEdge.getId();
                String edgeLabel = curEdge.getLabel();
                String sourceName = (String)this.nodeMap.get(curEdge.getSource());
                String targetName = (String)this.nodeMap.get(curEdge.getTarget());
                String interaction = this.getInteraction(curEdge);
                CyNode node_1 = Cytoscape.getRootGraph().getNode(sourceName);
                CyNode node_2 = Cytoscape.getRootGraph().getNode(targetName);
                if (edgeName == null) {
                    edgeName = CyEdge.createIdentifier(sourceName, interaction, targetName);
                }
                edge = Cytoscape.getCyEdge(node_1, node_2, "interaction", interaction, true, true);
                edgeAttributes.setAttribute(edgeName, "interaction", interaction);
                if (edgeLabel != null) {
                    edgeAttributes.setAttribute(edgeName, "XGMML Edge Label", edgeLabel);
                }
            } else {
                throw new XGMMLException("Non-existant source/target node for edge with gml (source,target): " + this.nodeMap.get(curEdge.getSource()) + "[" + curEdge.getSource() + "]," + this.nodeMap.get(curEdge.getTarget()) + "[" + curEdge.getTarget() + "]");
            }
            edge.setIdentifier(edgeName);
            this.readEdgeAttributes(edgeName, curEdge.getAtt(), null);
            this.giny_edges.add(edge.getRootGraphIndex());
        }
    }

    private String getInteraction(GraphicEdge edge) {
        String itrValue = "unknown";
        for (Att interaction : edge.getAtt()) {
            if (!interaction.getName().equals("interaction")) continue;
            itrValue = interaction.getValue();
            if (itrValue != null) break;
            itrValue = "unknown";
            break;
        }
        return itrValue;
    }

    private CyNode createMetaNode(String name, List children, CyNetwork cy_net) {
        Iterator it = children.iterator();
        CyNode parent = Cytoscape.getCyNode(name, false);
        int[] childrenNodeIndices = new int[children.size()];
        int counter = 0;
        while (it.hasNext()) {
            GraphicNode childNode = (GraphicNode)it.next();
            String targetNode = childNode.getHref();
            targetNode = targetNode == null || !targetNode.startsWith("#") ? childNode.getId() : targetNode.substring(1);
            String targetNodeName = (String)this.nodeMap.get(targetNode);
            if (targetNodeName == null) continue;
            CyNode targetChildNode = Cytoscape.getRootGraph().getNode(targetNodeName);
            childrenNodeIndices[counter] = targetChildNode.getRootGraphIndex();
            ++counter;
        }
        int[] edgeIndices = Cytoscape.getRootGraph().getConnectingEdgeIndicesArray(childrenNodeIndices);
        int rgParentNodeIndex = Cytoscape.getRootGraph().createNode(childrenNodeIndices, edgeIndices);
        CyNode metaNode = (CyNode)Cytoscape.getRootGraph().getNode(rgParentNodeIndex);
        if (metaNode == null) {
            throw new XGMMLException("CyNode from RootGraph with index = " + rgParentNodeIndex + " is null!!!");
        }
        ArrayList<Integer> rootNodes = (ArrayList<Integer>)this.networkCyAttributes.getListAttribute(cy_net.getIdentifier(), METANODE_KEY);
        if (rootNodes == null) {
            rootNodes = new ArrayList<Integer>();
        }
        String parentId = parent.getIdentifier();
        cy_net.removeNode(parent.getRootGraphIndex(), true);
        metaNode.setIdentifier(parentId);
        rootNodes.add(new Integer(metaNode.getRootGraphIndex()));
        this.networkCyAttributes.setListAttribute(cy_net.getIdentifier(), METANODE_KEY, rootNodes);
        return null;
    }

    public List getMetanodeList() {
        return this.rootNodes;
    }

    public Double getGraphViewZoomLevel() {
        return this.graphViewZoom != null ? this.graphViewZoom : null;
    }

    public Point2D getGraphViewCenter() {
        return this.graphViewCenterX != null && this.graphViewCenterY != null ? new Point2D.Double(this.graphViewCenterX, this.graphViewCenterY) : null;
    }

    @Override
    public void layout(GraphView myView) {
        if (myView == null || myView.nodeCount() == 0) {
            return;
        }
        for (int i = 0; i < this.metaTree.size(); ++i) {
            String name = (String)this.metaTree.get(i++);
            List children = (List)this.metaTree.get(i);
            this.createMetaNode(name, children, ((CyNetworkView)myView).getNetwork());
        }
        if (this.backgroundColor != null) {
            myView.setBackgroundPaint((Paint)this.getColor(this.backgroundColor));
        }
        this.layoutNode(myView);
        this.layoutEdge(myView);
        if (this.vsbSwitch != null && this.vsbSwitch.equals("on")) {
            VisualStyleBuilder vsb = new VisualStyleBuilder(this.networkName + ".style", this.nodeGraphicsMap, this.edgeGraphicsMap, null);
            vsb.buildStyle();
        }
    }

    private void layoutNode(GraphView myView) {
        String label = null;
        int tempid = 0;
        NodeView view = null;
        for (GraphicNode curNode : this.nodes) {
            label = curNode.getLabel();
            Graphics graphics = curNode.getGraphics();
            this.nodeGraphicsMap.put(label, graphics);
            view = myView.getNodeView(Cytoscape.getRootGraph().getNode(label).getRootGraphIndex());
            if (label != null && view != null) {
                view.getLabel().setText(label);
            } else if (view != null) {
                view.getLabel().setText("node(" + tempid + ")");
                ++tempid;
            }
            if (graphics == null || view == null) continue;
            this.layoutNodeGraphics(graphics, view);
        }
    }

    private void layoutNodeGraphics(Graphics graphics, NodeView nodeView) {
        double x = graphics.getX();
        double y = graphics.getY();
        double h = graphics.getH();
        double w = graphics.getW();
        nodeView.setXPosition(x);
        nodeView.setYPosition(y);
        nodeView.setHeight(h);
        nodeView.setWidth(w);
        if (graphics.getFill() != null) {
            nodeView.setUnselectedPaint((Paint)this.getColor(graphics.getFill()));
        }
        if (graphics.getOutline() != null) {
            nodeView.setBorderPaint((Paint)this.getColor(graphics.getOutline()));
        }
        if (graphics.getWidth() != null) {
            nodeView.setBorderWidth(graphics.getWidth().floatValue());
        }
        TypeGraphicsType gType = graphics.getType();
        String type = null;
        if (gType != null) {
            type = gType.value();
        }
        if (type != null) {
            if (type.equals(ELLIPSE) || type.equals(VELLIPSIS) || type.equals(HELLIPSIS) || type.equals(CIRCLE)) {
                nodeView.setShape(2);
            } else if (type.equals(RECTANGLE) || type.equals(BOX)) {
                nodeView.setShape(6);
            } else if (type.equals(DIAMOND)) {
                nodeView.setShape(1);
            } else if (type.equals(HEXAGON) || type.equals(PENTAGON)) {
                nodeView.setShape(3);
            } else if (type.equals(OCTAGON)) {
                nodeView.setShape(4);
            } else if (type.equals(PARALELLOGRAM) || type.equals(RHOMBUS)) {
                nodeView.setShape(5);
            } else if (type.equals(TRIANGLE)) {
                nodeView.setShape(0);
            }
        }
        if (graphics.getAtt().size() != 0) {
            Att localGraphics = graphics.getAtt().get(0);
            for (Object obj : localGraphics.getContent()) {
                if (obj.getClass() != Att.class) continue;
                Att nodeGraphics = (Att)obj;
                String attName = nodeGraphics.getName();
                String value = nodeGraphics.getValue();
                if (!attName.equals("nodeTransparency")) continue;
                nodeView.setTransparency(Float.parseFloat(value));
            }
        }
    }

    private void layoutEdge(GraphView myView) {
        EdgeView view = null;
        for (GraphicEdge curEdge : this.edges) {
            Graphics graphics = curEdge.getGraphics();
            String edgeID = curEdge.getId();
            this.edgeGraphicsMap.put(edgeID, graphics);
            int rootindex = 0;
            view = null;
            CyEdge testEdge = null;
            if (edgeID != null) {
                testEdge = Cytoscape.getRootGraph().getEdge(edgeID);
            }
            if (testEdge != null) {
                rootindex = testEdge.getRootGraphIndex();
                view = myView.getEdgeView(rootindex);
            } else {
                String sourceNodeName = (String)this.nodeMap.get(curEdge.getSource());
                String targetNodeName = (String)this.nodeMap.get(curEdge.getTarget());
                Iterator<Att> itrIt = curEdge.getAtt().iterator();
                Att interaction = null;
                String itrValue = "unknown";
                while (itrIt.hasNext()) {
                    interaction = itrIt.next();
                    if (!interaction.getName().equals("interaction")) continue;
                    itrValue = interaction.getValue();
                    break;
                }
                edgeID = CyEdge.createIdentifier(sourceNodeName, itrValue, targetNodeName);
                testEdge = Cytoscape.getRootGraph().getEdge(edgeID);
                if (testEdge != null) {
                    rootindex = testEdge.getRootGraphIndex();
                    view = myView.getEdgeView(rootindex);
                }
            }
            if (graphics == null || view == null || view == Cytoscape.getNullNetworkView()) continue;
            this.layoutEdgeGraphics(graphics, view);
        }
    }

    private void layoutEdgeGraphics(Graphics graphics, EdgeView edgeView) {
        if (graphics.getWidth() != null) {
            edgeView.setStrokeWidth(((Number)graphics.getWidth()).floatValue());
        }
        if (graphics.getFill() != null) {
            edgeView.setUnselectedPaint((Paint)this.getColor(graphics.getFill()));
        }
        if (graphics.getAtt().size() != 0) {
            for (Object obj : graphics.getAtt().get(0).getContent()) {
                if (obj.getClass() != Att.class) continue;
                Att edgeGraphics = (Att)obj;
                String attName = edgeGraphics.getName();
                String value = edgeGraphics.getValue();
                if (attName.equals("sourceArrow")) {
                    edgeView.setSourceEdgeEnd(Integer.parseInt(value));
                    continue;
                }
                if (attName.equals("targetArrow")) {
                    edgeView.setTargetEdgeEnd(Integer.parseInt(value));
                    continue;
                }
                if (attName.equals("sourceArrowColor")) {
                    edgeView.setSourceEdgeEndPaint((Paint)this.getColor(value));
                    continue;
                }
                if (attName.equals("targetArrowColor")) {
                    edgeView.setTargetEdgeEndPaint((Paint)this.getColor(value));
                    continue;
                }
                if (attName.equals("edgeLineType")) {
                    edgeView.setStroke(LineType.parseLineTypeText(value).getStroke());
                    continue;
                }
                if (attName.equals("curved")) {
                    if (value.equals("STRAIGHT_LINES")) {
                        edgeView.setLineType(2);
                        continue;
                    }
                    if (!value.equals("CURVED_LINES")) continue;
                    edgeView.setLineType(1);
                    continue;
                }
                if (!attName.equals("edgeBend")) continue;
                Iterator<Object> handleIt = edgeGraphics.getContent().iterator();
                ArrayList<Point2D.Double> handleList = new ArrayList<Point2D.Double>();
                while (handleIt.hasNext()) {
                    Object curObj = handleIt.next();
                    if (curObj.getClass() != Att.class) continue;
                    Iterator<Object> pointIt = ((Att)curObj).getContent().iterator();
                    double x = 0.0;
                    double y = 0.0;
                    boolean xFlag = false;
                    boolean yFlag = false;
                    while (pointIt.hasNext()) {
                        Object coordObj = pointIt.next();
                        if (coordObj.getClass() != Att.class) continue;
                        Att point = (Att)coordObj;
                        if (point.getName().equals("x")) {
                            x = Double.parseDouble(point.getValue());
                            xFlag = true;
                            continue;
                        }
                        if (!point.getName().equals("y")) continue;
                        y = Double.parseDouble(point.getValue());
                        yFlag = true;
                    }
                    if (!xFlag || !yFlag) continue;
                    handleList.add(new Point2D.Double(x, y));
                }
                if (handleList.size() == 0) continue;
                edgeView.getBend().setHandles(handleList);
            }
        }
    }

    @Override
    public int[] getNodeIndicesArray() {
        if (this.giny_nodes == null) {
            return new int[0];
        }
        this.giny_nodes.trimToSize();
        return this.giny_nodes.elements();
    }

    @Override
    public int[] getEdgeIndicesArray() {
        if (this.giny_edges == null) {
            return new int[0];
        }
        this.giny_edges.trimToSize();
        return this.giny_edges.elements();
    }

    public String getNetworkID() {
        return this.networkName;
    }

    @Override
    public String getNetworkName() {
        return this.networkName;
    }

    public RdfRDF getNetworkMetadata() {
        return this.metadata;
    }

    public Color getColor(String colorString) {
        return new Color(Integer.parseInt(colorString.substring(1), 16));
    }

    public Color getBackgroundColor() {
        return this.getColor(this.backgroundColor);
    }

    private void readAttributes(String targetName, List attrList, String type, GraphicNode parent) {
        CyAttributes attributes = null;
        attributes = type.equals(EDGE) ? Cytoscape.getEdgeAttributes() : Cytoscape.getNodeAttributes();
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            this.readAttribute(attributes, targetName, (Att)it.next(), type, parent);
        }
    }

    private void readNodeAttributes(String targetName, List<Att> attrList, GraphicNode parent) {
        for (Att curAtt : attrList) {
            this.readAttribute(Cytoscape.getNodeAttributes(), targetName, curAtt, NODE, parent);
        }
    }

    private void readEdgeAttributes(String targetName, List<Att> attrList, GraphicNode parent) {
        for (Att curAtt : attrList) {
            this.readAttribute(Cytoscape.getEdgeAttributes(), targetName, curAtt, EDGE, parent);
        }
    }

    private void readAttribute(CyAttributes attributes, String targetName, Att curAtt, String type, GraphicNode parent) {
        ObjectType dataType = curAtt.getType();
        if (dataType == null) {
            return;
        }
        if ((dataType == null || !dataType.equals((Object)ObjectType.LIST) && !dataType.equals((Object)ObjectType.MAP)) && curAtt.getValue() == null) {
            this.readEmbeddedAtt(targetName, curAtt, type, parent);
            return;
        }
        String attrName = curAtt.getName();
        if (attrName == null && (attrName = curAtt.getLabel()) == null) {
            return;
        }
        if (dataType == null || dataType.equals((Object)ObjectType.STRING)) {
            if (curAtt.getValue() != null) {
                attributes.setAttribute(targetName, attrName, curAtt.getValue().replace("\\n", "\n"));
            }
        } else if (dataType.equals((Object)ObjectType.INTEGER)) {
            attributes.setAttribute(targetName, attrName, new Integer(curAtt.getValue()));
        } else if (dataType.equals((Object)ObjectType.REAL)) {
            attributes.setAttribute(targetName, attrName, new Double(curAtt.getValue()));
        } else if (dataType.equals((Object)ObjectType.BOOLEAN)) {
            attributes.setAttribute(targetName, attrName, new Boolean(curAtt.getValue()));
        } else if (dataType.equals((Object)ObjectType.LIST)) {
            ArrayList<Object> listAttr = new ArrayList<Object>();
            for (Object listItem : curAtt.getContent()) {
                Object itemClassObject;
                if (listItem == null || listItem.getClass() != Att.class || (itemClassObject = this.createObjectFromAttValue((Att)listItem)) == null) continue;
                listAttr.add(itemClassObject);
            }
            attributes.setListAttribute(targetName, attrName, listAttr);
        } else {
            if (dataType.equals((Object)ObjectType.MAP)) {
                HashMap<String, Object> mapAttr = new HashMap<String, Object>();
                for (Object mapItem : curAtt.getContent()) {
                    Object mapClassObject;
                    if (mapItem == null || mapItem.getClass() != Att.class || (mapClassObject = this.createObjectFromAttValue((Att)mapItem)) == null) continue;
                    mapAttr.put(((Att)mapItem).getName(), mapClassObject);
                }
                attributes.setMapAttribute(targetName, attrName, mapAttr);
                return;
            }
            if (dataType.equals((Object)ObjectType.COMPLEX)) {
                int numKeys = Integer.valueOf(curAtt.getValue());
                if (!this.multihashmapdefExists(attributes, attrName)) {
                    this.defineComplexAttribute(attrName, attributes, curAtt, null, 0, numKeys);
                }
                this.createComplexAttribute(attrName, attributes, targetName, curAtt, null, 0, numKeys);
            }
        }
        this.readEmbeddedAtt(targetName, curAtt, type, parent);
    }

    private boolean multihashmapdefExists(CyAttributes attributes, String attributeName) {
        MultiHashMapDefinition mhmd = attributes.getMultiHashMapDefinition();
        CountedIterator defIt = mhmd.getDefinedAttributes();
        while (defIt.hasNext()) {
            String thisDef = (String)defIt.next();
            if (thisDef == null || !thisDef.equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private void defineComplexAttribute(String attributeName, CyAttributes attributes, Att curAtt, byte[] attributeDefinition, int attributeDefinitionCount, int numKeys) {
        if (attributeDefinition == null) {
            attributeDefinition = new byte[numKeys];
        }
        Iterator<Object> complexIt = curAtt.getContent().iterator();
        Att complexItem = (Att)complexIt.next();
        if (attributeDefinitionCount < numKeys) {
            attributeDefinition[attributeDefinitionCount++] = this.getMultHashMapTypeFromAtt(complexItem);
            if (attributeDefinitionCount < numKeys) {
                this.defineComplexAttribute(attributeName, attributes, complexItem, attributeDefinition, attributeDefinitionCount, numKeys);
            }
        }
        if (attributeDefinitionCount == numKeys) {
            Iterator<Object> nextComplexIt = complexItem.getContent().iterator();
            Att nextComplexItem = (Att)nextComplexIt.next();
            byte valueType = this.getMultHashMapTypeFromAtt(nextComplexItem);
            MultiHashMapDefinition mhmd = attributes.getMultiHashMapDefinition();
            mhmd.defineAttribute(attributeName, valueType, attributeDefinition);
        }
    }

    private void createComplexAttribute(String attributeName, CyAttributes attributes, String targetName, Att curAtt, Object[] keySpace, int keySpaceCount, int numKeySpaceKeys) {
        if (keySpace == null) {
            keySpace = new Object[numKeySpaceKeys];
        }
        for (Object complexItemObj : curAtt.getContent()) {
            if (complexItemObj == null || complexItemObj.getClass() != Att.class) continue;
            Att complexItem = (Att)complexItemObj;
            keySpace[keySpaceCount] = this.createObjectFromAttName(complexItem);
            if (keySpaceCount + 1 < numKeySpaceKeys - 1) {
                this.createComplexAttribute(attributeName, attributes, targetName, complexItem, keySpace, keySpaceCount + 1, numKeySpaceKeys);
                continue;
            }
            MultiHashMap mhm = attributes.getMultiHashMap();
            for (Object nextComplexItemObj : complexItem.getContent()) {
                if (nextComplexItemObj == null || nextComplexItemObj.getClass() != Att.class) continue;
                Att nextComplexItem = (Att)nextComplexItemObj;
                keySpace[keySpaceCount + 1] = this.createObjectFromAttName(nextComplexItem);
                Iterator<Object> complexValueIterator = nextComplexItem.getContent().iterator();
                Object complexValue = complexValueIterator.next();
                Object valueToStore = this.createObjectFromAttValue((Att)complexValue);
                mhm.setAttributeValue(targetName, attributeName, valueToStore, keySpace);
            }
        }
    }

    private Object createObjectFromAttName(Att item) {
        if (item.getType().equals((Object)ObjectType.STRING)) {
            return item.getName();
        }
        if (item.getType().equals((Object)ObjectType.INTEGER)) {
            return new Integer(item.getName());
        }
        if (item.getType().equals((Object)ObjectType.REAL)) {
            return new Double(item.getName());
        }
        if (item.getType().equals((Object)ObjectType.BOOLEAN)) {
            return new Boolean(item.getName());
        }
        return null;
    }

    private Object createObjectFromAttValue(Att item) {
        if (item.getType().equals((Object)ObjectType.STRING)) {
            return item.getValue();
        }
        if (item.getType().equals((Object)ObjectType.INTEGER)) {
            return new Integer(item.getValue());
        }
        if (item.getType().equals((Object)ObjectType.REAL)) {
            return new Double(item.getValue());
        }
        if (item.getType().equals((Object)ObjectType.BOOLEAN)) {
            return new Boolean(item.getValue());
        }
        return null;
    }

    private byte getMultHashMapTypeFromAtt(Att item) {
        if (item.getType().equals((Object)ObjectType.STRING)) {
            return 4;
        }
        if (item.getType().equals((Object)ObjectType.INTEGER)) {
            return 3;
        }
        if (item.getType().equals((Object)ObjectType.REAL)) {
            return 2;
        }
        if (item.getType().equals((Object)ObjectType.BOOLEAN)) {
            return 1;
        }
        return -1;
    }

    public void setNetworkAttributes(CyNetwork cyNetwork) {
        for (Att curAtt : this.networkAtt) {
            if (curAtt.getName().equals("networkMetadata")) {
                this.metadata = (RdfRDF)curAtt.getContent().get(0);
                MetadataParser mdp = new MetadataParser(cyNetwork);
                mdp.setMetadata(this.metadata);
                continue;
            }
            if (curAtt.getName().equals("backgroundColor")) {
                this.backgroundColor = curAtt.getValue();
                continue;
            }
            if (curAtt.getName().equals("GRAPH_VIEW_ZOOM")) {
                this.graphViewZoom = new Double(curAtt.getValue());
                continue;
            }
            if (curAtt.getName().equals("GRAPH_VIEW_CENTER_X")) {
                this.graphViewCenterX = new Double(curAtt.getValue());
                continue;
            }
            if (curAtt.getName().equals("GRAPH_VIEW_CENTER_Y")) {
                this.graphViewCenterY = new Double(curAtt.getValue());
                continue;
            }
            this.readAttribute(this.networkCyAttributes, cyNetwork.getIdentifier(), curAtt, "network", null);
        }
    }

    private void readEmbeddedAtt(String targetName, Att curAtt, String type, GraphicNode parent) {
        if (curAtt.getContent() == null) {
            return;
        }
        ArrayList<Object> attrs = new ArrayList<Object>();
        for (Object curObj : curAtt.getContent()) {
            if (curObj.getClass() == Att.class) {
                attrs.add(curObj);
                continue;
            }
            if (curObj.getClass() != GraphicGraph.class) continue;
            this.getNodesAndEdges((GraphicGraph)curObj, parent);
        }
        if (attrs.size() > 0) {
            this.readAttributes(targetName, attrs, type, parent);
        }
    }

    @Override
    public void doPostProcessing(CyNetwork network) {
        this.setNetworkAttributes(network);
    }
}

