/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.ui.VizMapAttrTab;
import cytoscape.visual.ui.VizMapTab;
import cytoscape.visual.ui.VizMapUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VizMapSizeTab
extends VizMapTab {
    private JPanel hwPanel;
    private JPanel lockPanel;
    private JPanel mainPanel;
    private VizMapAttrTab height;
    private VizMapAttrTab width;
    private VizMapAttrTab size;
    private VisualMappingManager VMM;
    private NodeAppearanceCalculator nodeCalc;
    private VizMapUI mainUIDialog;
    private boolean locked;
    JCheckBox lockBox;

    public VizMapSizeTab(VizMapUI mainUI, JTabbedPane tabContainer, int tabIndex, VisualMappingManager VMM, byte type) throws IllegalArgumentException {
        this(mainUI, tabContainer, tabIndex, VMM, type, VMM.getVisualStyle().getNodeAppearanceCalculator().getNodeSizeLocked());
    }

    public VizMapSizeTab(VizMapUI mainUI, JTabbedPane tabContainer, int tabIndex, VisualMappingManager VMM, byte type, boolean locked) throws IllegalArgumentException {
        super(new BorderLayout(), false);
        if (type != 4) {
            throw new IllegalArgumentException("You can only create a VizMapSizeTab for the Node Size attribute");
        }
        this.setName("Node Size");
        this.VMM = VMM;
        this.nodeCalc = VMM.getVisualStyle().getNodeAppearanceCalculator();
        this.mainUIDialog = mainUI;
        this.locked = locked;
        JPanel lockBoxPanel = new JPanel(false);
        this.lockBox = new JCheckBox("Lock height/width calculators");
        this.lockBox.setSelected(locked);
        this.lockBox.addItemListener(new LockCalcListener());
        lockBoxPanel.add(this.lockBox);
        this.hwPanel = new JPanel(false);
        this.hwPanel.setLayout(new BoxLayout(this.hwPanel, 1));
        this.lockPanel = new JPanel(new GridLayout(), false);
        this.height = new VizMapAttrTab(mainUI, tabContainer, tabIndex, VMM, 126);
        this.width = new VizMapAttrTab(mainUI, tabContainer, tabIndex, VMM, 127);
        this.size = new VizMapAttrTab(mainUI, tabContainer, tabIndex, VMM, 4);
        this.width.setBorder(BorderFactory.createTitledBorder(this.width.getName()));
        this.height.setBorder(BorderFactory.createTitledBorder(this.height.getName()));
        this.hwPanel.add(this.height);
        this.hwPanel.add(this.width);
        this.lockPanel.add(this.size);
        this.mainPanel = new JPanel(new GridLayout(), false);
        if (this.locked) {
            this.mainPanel.add(this.lockPanel);
        } else {
            this.mainPanel.add(this.hwPanel);
        }
        this.nodeCalc.setNodeSizeLocked(this.locked);
        this.add((Component)lockBoxPanel, "North");
        this.add((Component)this.mainPanel, "Center");
    }

    public void refreshUI() {
        this.height.refreshUI();
        this.width.refreshUI();
        this.size.refreshUI();
    }

    public void visualStyleChanged() {
        this.nodeCalc = this.VMM.getVisualStyle().getNodeAppearanceCalculator();
        this.height.visualStyleChanged();
        this.width.visualStyleChanged();
        this.size.visualStyleChanged();
        this.locked = this.nodeCalc.getNodeSizeLocked();
        if (this.lockBox.isSelected() != this.locked) {
            this.lockBox.setSelected(this.locked);
        }
    }

    VizMapTab checkCalcSelected(Calculator c) {
        if (this.locked) {
            return this.size.checkCalcSelected(c);
        }
        VizMapTab ret = this.height.checkCalcSelected(c);
        if (ret == null) {
            return this.width.checkCalcSelected(c);
        }
        return ret;
    }

    private class LockCalcListener
    implements ItemListener {
        private Calculator widthCalc;
        private Calculator heightCalc;
        private Calculator lockCalc;

        private LockCalcListener() {
            this.widthCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)127);
            this.heightCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)126);
            this.lockCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)4);
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                System.out.println("node size selected");
                VizMapSizeTab.this.mainPanel.removeAll();
                VizMapSizeTab.this.mainPanel.add(VizMapSizeTab.this.lockPanel);
                VizMapSizeTab.this.locked = true;
                VizMapSizeTab.this.nodeCalc.setNodeSizeLocked(true);
                this.widthCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)127);
                VizMapSizeTab.this.width.setComboBox(null);
                this.heightCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)126);
                VizMapSizeTab.this.height.setComboBox(null);
                VizMapSizeTab.this.size.setComboBox(this.lockCalc);
            } else {
                System.out.println("node size UNselected");
                VizMapSizeTab.this.mainPanel.removeAll();
                VizMapSizeTab.this.mainPanel.add(VizMapSizeTab.this.hwPanel);
                VizMapSizeTab.this.locked = false;
                VizMapSizeTab.this.nodeCalc.setNodeSizeLocked(false);
                this.lockCalc = VizMapSizeTab.this.nodeCalc.getCalculator((byte)4);
                VizMapSizeTab.this.size.setComboBox(null);
                VizMapSizeTab.this.height.setComboBox(this.heightCalc);
                VizMapSizeTab.this.width.setComboBox(this.widthCalc);
            }
            VizMapSizeTab.this.validate();
            VizMapSizeTab.this.repaint();
            VizMapSizeTab.this.mainUIDialog.pack();
            VizMapSizeTab.this.mainUIDialog.repaint();
        }
    }
}

