/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.MonitorableTask;
import BiNGO.NodeDistances;
import BiNGO.SwingWorker;
import giny.model.Node;
import giny.view.GraphView;
import giny.view.NodeView;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SpringEmbeddedLayouter
implements MonitorableTask {
    public static final int DEFAULT_NUM_LAYOUT_PASSES = 2;
    public static final double DEFAULT_AVERAGE_ITERATIONS_PER_NODE = 20.0;
    public static final double[] DEFAULT_NODE_DISTANCE_SPRING_SCALARS = new double[]{1.0, 1.0};
    public static final double DEFAULT_NODE_DISTANCE_STRENGTH_CONSTANT = 15.0;
    public static final double DEFAULT_NODE_DISTANCE_REST_LENGTH_CONSTANT = 200.0;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_STRENGTH = 0.05;
    public static final double DEFAULT_DISCONNECTED_NODE_DISTANCE_SPRING_REST_LENGTH = 2500.0;
    public static final double[] DEFAULT_ANTICOLLISION_SPRING_SCALARS = new double[]{0.0, 1.0};
    public static final double DEFAULT_ANTICOLLISION_SPRING_STRENGTH = 100.0;
    protected int numLayoutPasses = 2;
    protected double averageIterationsPerNode = 20.0;
    protected double[] nodeDistanceSpringScalars = DEFAULT_NODE_DISTANCE_SPRING_SCALARS;
    protected double nodeDistanceStrengthConstant = 15.0;
    protected double nodeDistanceRestLengthConstant = 200.0;
    protected double disconnectedNodeDistanceSpringStrength = 0.05;
    protected double disconnectedNodeDistanceSpringRestLength = 2500.0;
    protected double[][] nodeDistanceSpringStrengths;
    protected double[][] nodeDistanceSpringRestLengths;
    protected double[] anticollisionSpringScalars = DEFAULT_ANTICOLLISION_SPRING_SCALARS;
    protected double anticollisionSpringStrength = 100.0;
    protected GraphView graphView;
    protected int nodeCount;
    protected int edgeCount;
    protected int layoutPass;
    protected HashMap nodeIndexToMatrixIndexMap;
    protected TreeMap matrixIndexToNodeIndexMap;
    protected int currentProgress;
    protected int lengthOfTask;
    protected String statusMessage;
    protected boolean done;
    protected boolean canceled;

    public SpringEmbeddedLayouter(GraphView graph_view) {
        this.setGraphView(graph_view);
        this.initializeSpringEmbeddedLayouter();
        this.currentProgress = 0;
        this.lengthOfTask = this.nodeCount * (int)this.averageIterationsPerNode;
        this.done = false;
        this.canceled = false;
    }

    public void setGraphView(GraphView new_graph_view) {
        this.graphView = new_graph_view;
    }

    public GraphView getGraphView() {
        return this.graphView;
    }

    protected void initializeSpringEmbeddedLayouter() {
        this.nodeCount = this.graphView.getNodeViewCount();
        this.edgeCount = this.graphView.getEdgeViewCount();
    }

    public void calculate() {
        this.currentProgress = 0;
        this.lengthOfTask = this.nodeCount * (int)this.averageIterationsPerNode;
        this.done = false;
        this.canceled = false;
        this.nodeIndexToMatrixIndexMap = new HashMap();
        this.matrixIndexToNodeIndexMap = new TreeMap();
        Iterator nodes = this.graphView.getNodeViewsIterator();
        int count = 0;
        while (nodes.hasNext()) {
            NodeView nodeView = (NodeView)nodes.next();
            this.nodeIndexToMatrixIndexMap.put(new Integer(nodeView.getRootGraphIndex()), new Integer(count));
            this.matrixIndexToNodeIndexMap.put(new Integer(count), new Integer(nodeView.getRootGraphIndex()));
            ++count;
        }
        double euclidean_distance_threshold = 0.5 * (double)(this.nodeCount + this.edgeCount);
        double potential_energy_percent_change_threshold = 0.001;
        int num_iterations = (int)((double)this.nodeCount * this.averageIterationsPerNode / (double)this.numLayoutPasses);
        List partials_list = this.createPartialsList();
        PotentialEnergy potential_energy = new PotentialEnergy();
        PartialDerivatives furthest_node_partials = null;
        double setup_progress = 0.0;
        this.layoutPass = 0;
        while (this.layoutPass < this.numLayoutPasses) {
            this.setupForLayoutPass();
            potential_energy.reset();
            partials_list.clear();
            Iterator node_views_iterator = this.graphView.getNodeViewsIterator();
            while (node_views_iterator.hasNext()) {
                NodeView node_view = (NodeView)node_views_iterator.next();
                PartialDerivatives partials = new PartialDerivatives(node_view);
                this.calculatePartials(partials, null, potential_energy, false);
                partials_list.add(partials);
                if (furthest_node_partials != null && !(partials.euclideanDistance > furthest_node_partials.euclideanDistance)) continue;
                furthest_node_partials = partials;
            }
            for (int iterations_i = 0; iterations_i < num_iterations && furthest_node_partials.euclideanDistance >= euclidean_distance_threshold; ++iterations_i) {
                furthest_node_partials = this.moveNode(furthest_node_partials, partials_list, potential_energy);
                ++this.currentProgress;
                double percentDone = this.currentProgress * 100 / this.lengthOfTask;
                this.statusMessage = "Completed " + percentDone + "%.";
            }
            ++this.layoutPass;
        }
        this.done = true;
        this.currentProgress = this.lengthOfTask;
    }

    protected void setupForLayoutPass() {
        this.setupNodeDistanceSprings();
    }

    protected void setupNodeDistanceSprings() {
        if (this.layoutPass != 0) {
            return;
        }
        this.nodeDistanceSpringRestLengths = new double[this.nodeCount][this.nodeCount];
        this.nodeDistanceSpringStrengths = new double[this.nodeCount][this.nodeCount];
        if (this.nodeDistanceSpringScalars[this.layoutPass] == 0.0) {
            return;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Collection matrixIndices = this.matrixIndexToNodeIndexMap.values();
        int i = 0;
        Iterator iterator = matrixIndices.iterator();
        while (iterator.hasNext()) {
            Integer nodeIndex = (Integer)iterator.next();
            nodeList.add(i, this.graphView.getGraphPerspective().getNode(nodeIndex.intValue()));
            ++i;
        }
        NodeDistances ind = new NodeDistances(nodeList, this.graphView.getGraphPerspective(), this.nodeIndexToMatrixIndexMap);
        int[][] node_distances = ind.calculate();
        if (node_distances == null) {
            return;
        }
        double node_distance_strength_constant = this.nodeDistanceStrengthConstant;
        double node_distance_rest_length_constant = this.nodeDistanceRestLengthConstant;
        for (int node_i = 0; node_i < this.nodeCount; ++node_i) {
            for (int node_j = node_i + 1; node_j < this.nodeCount; ++node_j) {
                this.nodeDistanceSpringRestLengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringRestLength : node_distance_rest_length_constant * (double)node_distances[node_i][node_j];
                this.nodeDistanceSpringRestLengths[node_j][node_i] = this.nodeDistanceSpringRestLengths[node_i][node_j];
                this.nodeDistanceSpringStrengths[node_i][node_j] = node_distances[node_i][node_j] == Integer.MAX_VALUE ? this.disconnectedNodeDistanceSpringStrength : node_distance_strength_constant / (double)(node_distances[node_i][node_j] * node_distances[node_i][node_j]);
                this.nodeDistanceSpringStrengths[node_j][node_i] = this.nodeDistanceSpringStrengths[node_i][node_j];
            }
        }
    }

    protected PartialDerivatives calculatePartials(PartialDerivatives partials, List partials_list, PotentialEnergy potential_energy, boolean reversed) {
        partials.reset();
        NodeView node_view = partials.getNodeView();
        int node_view_index = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(node_view.getRootGraphIndex()));
        double node_view_radius = node_view.getWidth();
        double node_view_x = node_view.getXPosition();
        double node_view_y = node_view.getYPosition();
        PartialDerivatives other_node_partials = null;
        PartialDerivatives furthest_partials = null;
        Iterator iterator = partials_list == null ? this.graphView.getNodeViewsIterator() : partials_list.iterator();
        while (iterator.hasNext()) {
            NodeView other_node_view;
            if (partials_list == null) {
                other_node_view = (NodeView)iterator.next();
            } else {
                other_node_partials = (PartialDerivatives)iterator.next();
                other_node_view = other_node_partials.getNodeView();
            }
            if (node_view.getRootGraphIndex() == other_node_view.getRootGraphIndex()) continue;
            int other_node_view_index = (Integer)this.nodeIndexToMatrixIndexMap.get(new Integer(other_node_view.getRootGraphIndex()));
            double other_node_view_radius = other_node_view.getWidth();
            double delta_x = node_view_x - other_node_view.getXPosition();
            double delta_y = node_view_y - other_node_view.getYPosition();
            double euclidean_distance = Math.sqrt(delta_x * delta_x + delta_y * delta_y);
            double euclidean_distance_cubed = Math.pow(euclidean_distance, 3.0);
            double distance_from_touching = euclidean_distance - (node_view_radius + other_node_view_radius);
            double incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_x - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_x / euclidean_distance));
            if (!reversed) {
                partials.x += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_x - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_x / euclidean_distance));
                other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_x - (node_view_radius + other_node_view_radius) * delta_x / euclidean_distance));
                if (!reversed) {
                    partials.x += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_x - (node_view_radius + other_node_view_radius) * -delta_x / euclidean_distance));
                    other_node_partials.x = reversed ? (other_node_partials.x -= incremental_change) : (other_node_partials.x += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (delta_y - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * delta_y / euclidean_distance));
            if (!reversed) {
                partials.y += incremental_change;
            }
            if (other_node_partials != null) {
                incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[other_node_view_index][node_view_index] * (-delta_y - this.nodeDistanceSpringRestLengths[other_node_view_index][node_view_index] * -delta_y / euclidean_distance));
                other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (delta_y - (node_view_radius + other_node_view_radius) * delta_y / euclidean_distance));
                if (!reversed) {
                    partials.y += incremental_change;
                }
                if (other_node_partials != null) {
                    incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (-delta_y - (node_view_radius + other_node_view_radius) * -delta_y / euclidean_distance));
                    other_node_partials.y = reversed ? (other_node_partials.y -= incremental_change) : (other_node_partials.y += incremental_change);
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_y * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xx -= incremental_change;
                }
            } else {
                partials.xx += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xx += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_y * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xx -= incremental_change;
                    }
                } else {
                    partials.xx += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xx += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (1.0 - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_x) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.yy -= incremental_change;
                }
            } else {
                partials.yy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.yy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (1.0 - (node_view_radius + other_node_view_radius) * (delta_x * delta_x) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.yy -= incremental_change;
                    }
                } else {
                    partials.yy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.yy += incremental_change;
                    }
                }
            }
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index] * (delta_x * delta_y) / euclidean_distance_cubed));
            if (reversed) {
                if (other_node_partials != null) {
                    other_node_partials.xy -= incremental_change;
                }
            } else {
                partials.xy += incremental_change;
                if (other_node_partials != null) {
                    other_node_partials.xy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * ((node_view_radius + other_node_view_radius) * (delta_x * delta_y) / euclidean_distance_cubed));
                if (reversed) {
                    if (other_node_partials != null) {
                        other_node_partials.xy -= incremental_change;
                    }
                } else {
                    partials.xy += incremental_change;
                    if (other_node_partials != null) {
                        other_node_partials.xy += incremental_change;
                    }
                }
            }
            double distance_from_rest = euclidean_distance - this.nodeDistanceSpringRestLengths[node_view_index][other_node_view_index];
            incremental_change = this.nodeDistanceSpringScalars[this.layoutPass] * (this.nodeDistanceSpringStrengths[node_view_index][other_node_view_index] * (distance_from_rest * distance_from_rest) / 2.0);
            if (reversed) {
                if (other_node_partials != null) {
                    potential_energy.totalEnergy -= incremental_change;
                }
            } else {
                potential_energy.totalEnergy += incremental_change;
                if (other_node_partials != null) {
                    potential_energy.totalEnergy += incremental_change;
                }
            }
            if (distance_from_touching < 0.0) {
                incremental_change = this.anticollisionSpringScalars[this.layoutPass] * (this.anticollisionSpringStrength * (distance_from_touching * distance_from_touching) / 2.0);
                if (reversed) {
                    if (other_node_partials != null) {
                        potential_energy.totalEnergy -= incremental_change;
                    }
                } else {
                    potential_energy.totalEnergy += incremental_change;
                    if (other_node_partials != null) {
                        potential_energy.totalEnergy += incremental_change;
                    }
                }
            }
            if (other_node_partials == null) continue;
            other_node_partials.euclideanDistance = Math.sqrt(other_node_partials.x * other_node_partials.x + other_node_partials.y * other_node_partials.y);
            if (furthest_partials != null && !(other_node_partials.euclideanDistance > furthest_partials.euclideanDistance)) continue;
            furthest_partials = other_node_partials;
        }
        if (!reversed) {
            partials.euclideanDistance = Math.sqrt(partials.x * partials.x + partials.y * partials.y);
        }
        if (furthest_partials == null || partials.euclideanDistance > furthest_partials.euclideanDistance) {
            furthest_partials = partials;
        }
        return furthest_partials;
    }

    protected PartialDerivatives moveNode(PartialDerivatives partials, List partials_list, PotentialEnergy potential_energy) {
        NodeView node_view = partials.getNodeView();
        PartialDerivatives starting_partials = new PartialDerivatives(partials);
        this.calculatePartials(partials, partials_list, potential_energy, true);
        this.simpleMoveNode(starting_partials);
        return this.calculatePartials(partials, partials_list, potential_energy, false);
    }

    protected void simpleMoveNode(PartialDerivatives partials) {
        NodeView node_view = partials.getNodeView();
        double denomenator = partials.xx * partials.yy - partials.xy * partials.xy;
        double delta_x = (-partials.x * partials.yy - -partials.y * partials.xy) / denomenator;
        double delta_y = (-partials.y * partials.xx - -partials.x * partials.xy) / denomenator;
        Point2D p = node_view.getOffset();
        node_view.setOffset(p.getX() + delta_x, p.getY() + delta_y);
    }

    protected List createPartialsList() {
        return new ArrayList();
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public String getTaskDescription() {
        return "Performing Layout...";
    }

    public String getCurrentStatusMessage() {
        return this.statusMessage;
    }

    public boolean isDone() {
        return this.done;
    }

    public void stop() {
        this.canceled = true;
        this.statusMessage = null;
    }

    public boolean wasCanceled() {
        return this.canceled;
    }

    public void start(boolean return_when_done) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return new DoTask();
            }
        };
        worker.start();
        if (return_when_done) {
            worker.get();
        }
    }

    class DoTask {
        DoTask() {
            SpringEmbeddedLayouter.this.calculate();
        }
    }

    class PotentialEnergy {
        public double totalEnergy = 0.0;

        PotentialEnergy() {
        }

        public void reset() {
            this.totalEnergy = 0.0;
        }
    }

    class PartialDerivatives {
        protected NodeView nodeView;
        public double x;
        public double y;
        public double xx;
        public double yy;
        public double xy;
        public double euclideanDistance;

        public PartialDerivatives(NodeView node_view) {
            this.nodeView = node_view;
        }

        public PartialDerivatives(PartialDerivatives copy_from) {
            this.nodeView = copy_from.getNodeView();
            this.copyFrom(copy_from);
        }

        public void reset() {
            this.x = 0.0;
            this.y = 0.0;
            this.xx = 0.0;
            this.yy = 0.0;
            this.xy = 0.0;
            this.euclideanDistance = 0.0;
        }

        public NodeView getNodeView() {
            return this.nodeView;
        }

        public void copyFrom(PartialDerivatives other_partial_derivatives) {
            this.x = other_partial_derivatives.x;
            this.y = other_partial_derivatives.y;
            this.xx = other_partial_derivatives.xx;
            this.yy = other_partial_derivatives.yy;
            this.xy = other_partial_derivatives.xy;
            this.euclideanDistance = other_partial_derivatives.euclideanDistance;
        }

        public String toString() {
            return "PartialDerivatives( \"" + this.getNodeView() + "\", x=" + this.x + ", y=" + this.y + ", xx=" + this.xx + ", yy=" + this.yy + ", xy=" + this.xy + ", euclideanDistance=" + this.euclideanDistance + " )";
        }
    }
}

