/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.chromatogram;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.biojava.bio.chromatogram.Chromatogram;
import org.biojava.bio.chromatogram.UnsupportedChromatogramFormatException;
import org.biojava.bio.program.abi.ABIFChromatogram;
import org.biojava.bio.program.scf.SCF;
import org.biojava.utils.io.CachingInputStream;

public class ChromatogramFactory {
    public static final int SCF_MAGIC = 779314022;
    public static final int ABI_MAGIC = 1094863174;

    public static Chromatogram create(File f) throws IOException, UnsupportedChromatogramFormatException {
        FileInputStream fin = new FileInputStream(f);
        int magic = ChromatogramFactory.magicFromStream(fin);
        fin.close();
        switch (magic) {
            case 779314022: {
                return SCF.create(f);
            }
            case 1094863174: {
                return ABIFChromatogram.create(f);
            }
        }
        throw new UnsupportedChromatogramFormatException("File " + f + " with magic " + magic + " has an unsupported format");
    }

    public static Chromatogram create(InputStream in) throws IOException, UnsupportedChromatogramFormatException {
        CachingInputStream cin = in instanceof CachingInputStream ? (CachingInputStream)in : new CachingInputStream(in);
        cin.seek(0L);
        int magic = ChromatogramFactory.magicFromStream(cin);
        cin.seek(0L);
        switch (magic) {
            case 779314022: {
                return SCF.create(in, 4L);
            }
            case 1094863174: {
                return ABIFChromatogram.create(cin);
            }
        }
        throw new UnsupportedChromatogramFormatException("The provided input stream with magic " + magic + " has an unsupported format");
    }

    private static int makeMagic(byte[] magic) {
        return magic[0] << 24 | magic[1] << 16 | magic[2] << 8 | magic[3];
    }

    private static int magicFromStream(InputStream src) throws IOException {
        byte[] magicBytes = new byte[4];
        src.read(magicBytes);
        return ChromatogramFactory.makeMagic(magicBytes);
    }
}

