/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.BetweenLocation;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;

final class BetweenLocationTools {
    BetweenLocationTools() {
    }

    protected static Location union(Location locationA, Location locationB) {
        if (BetweenLocationTools.isBetween(locationA) && BetweenLocationTools.isBetween(locationB)) {
            Location tempLocationA = BetweenLocationTools.unwrap(locationA);
            Location tempLocationB = BetweenLocationTools.unwrap(locationB);
            Location mergeLocation = LocationTools.union(tempLocationA, tempLocationB);
            mergeLocation = new BetweenLocation(mergeLocation);
            return mergeLocation;
        }
        ArrayList<Location> locList = new ArrayList<Location>();
        locList.add(locationA);
        locList.add(locationB);
        return new CompoundLocation(locList);
    }

    protected static Location intersection(Location locationA, Location locationB) {
        Location tempLocationB;
        Location tempLocationA = BetweenLocationTools.unwrap(locationA);
        Location tempIntersection = LocationTools.intersection(tempLocationA, tempLocationB = BetweenLocationTools.unwrap(locationB));
        if (tempIntersection.getMin() == tempIntersection.getMax()) {
            tempIntersection = Location.empty;
        }
        if (!LocationTools.areEqual(tempIntersection, Location.empty)) {
            tempIntersection = new BetweenLocation(tempIntersection);
        }
        return tempIntersection;
    }

    protected static boolean overlaps(Location locationA, Location locationB) {
        boolean toReturn = true;
        Location tempLocation = BetweenLocationTools.intersection(locationA, locationB);
        if (LocationTools.areEqual(tempLocation, Location.empty)) {
            toReturn = false;
        }
        return toReturn;
    }

    protected static boolean contains(Location locationA, Location locationB) {
        Location tempLocationA = BetweenLocationTools.unwrap(locationA);
        Location tempLocationB = BetweenLocationTools.unwrap(locationB);
        return LocationTools.contains(tempLocationA, tempLocationB);
    }

    protected static boolean areEqual(Location locationA, Location locationB) {
        boolean toReturn = false;
        if (BetweenLocationTools.isBetween(locationA) && BetweenLocationTools.isBetween(locationB)) {
            Location tempLocationA = BetweenLocationTools.unwrap(locationA);
            Location tempLocationB = BetweenLocationTools.unwrap(locationB);
            toReturn = LocationTools.areEqual(tempLocationA, tempLocationB);
        }
        return toReturn;
    }

    protected static Location unwrap(Location theLoc) {
        Location toReturn = theLoc;
        try {
            if (BetweenLocationTools.isBetween(theLoc)) {
                toReturn = ((BetweenLocation)theLoc).getWrapped();
            }
        }
        catch (ClassCastException cce) {
            throw new BioError("Unwrapping not possible: decorated by other than between decorator");
        }
        return toReturn;
    }

    protected static boolean isBetween(Location theLocation) {
        boolean toReturn = false;
        try {
            if (theLocation.getDecorator(Class.forName("org.biojava.bio.symbol.BetweenLocation")) != null) {
                toReturn = true;
            }
        }
        catch (Exception e) {
            throw new BioError("class org.biojava.bio.symbol.BetweenLocation could not be loaded");
        }
        return toReturn;
    }
}

