/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.popup;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.EventListenerList;

public class GlobalMouseListener {
    private EventListenerList listeners = new EventListenerList();

    public GlobalMouseListener(Component c) {
        final MouseListener ml = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                GlobalMouseListener.this.redispatch(e);
            }

            public void mouseEntered(MouseEvent e) {
                GlobalMouseListener.this.redispatch(e);
            }

            public void mouseExited(MouseEvent e) {
                GlobalMouseListener.this.redispatch(e);
            }

            public void mousePressed(MouseEvent e) {
                GlobalMouseListener.this.redispatch(e);
            }

            public void mouseReleased(MouseEvent e) {
                GlobalMouseListener.this.redispatch(e);
            }
        };
        ContainerListener cl = new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
                Component source = e.getChild();
                GlobalMouseListener.this.changeGlobalMouseListener(true, source, ml, this);
            }

            public void componentRemoved(ContainerEvent e) {
                Component source = e.getChild();
                GlobalMouseListener.this.changeGlobalMouseListener(false, source, ml, this);
            }
        };
        this.changeGlobalMouseListener(true, c, ml, cl);
    }

    private void changeGlobalMouseListener(boolean add, Component c, MouseListener ml, ContainerListener cl) {
        if (add) {
            c.addMouseListener(ml);
        } else {
            c.removeMouseListener(ml);
        }
        if (c instanceof Container) {
            Container cc = (Container)c;
            if (add) {
                cc.addContainerListener(cl);
            } else {
                cc.removeContainerListener(cl);
            }
            int l = cc.getComponentCount();
            for (int i = 0; i < l; ++i) {
                Component child = cc.getComponent(i);
                this.changeGlobalMouseListener(add, child, ml, cl);
            }
        }
    }

    public void addMouseListener(MouseListener l) {
        this.listeners.add(MouseListener.class, l);
    }

    public void removeMouseListener(MouseListener l) {
        this.listeners.remove(MouseListener.class, l);
    }

    private void redispatch(MouseEvent e) {
        int count = this.listeners.getListenerCount(MouseListener.class);
        if (count > 0) {
            MouseListener[] list = (MouseListener[])this.listeners.getListeners(MouseListener.class);
            switch (e.getID()) {
                case 500: {
                    for (int i = 0; i < count; ++i) {
                        list[i].mouseClicked(e);
                    }
                    break;
                }
                case 504: {
                    for (int i = 0; i < count; ++i) {
                        list[i].mouseEntered(e);
                    }
                    break;
                }
                case 505: {
                    for (int i = 0; i < count; ++i) {
                        list[i].mouseExited(e);
                    }
                    break;
                }
                case 501: {
                    for (int i = 0; i < count; ++i) {
                        list[i].mousePressed(e);
                    }
                    break;
                }
                case 502: {
                    for (int i = 0; i < count; ++i) {
                        list[i].mouseReleased(e);
                    }
                    break;
                }
            }
        }
    }
}

