/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.program.homologene.AbstractOrthologueSet;
import org.biojava.bio.program.homologene.Orthologue;
import org.biojava.bio.program.homologene.OrthologueSet;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleOrthologueSet
extends AbstractOrthologueSet {
    private Set orthologueSet = new HashSet();
    private Map orthologueByHomologeneID = new HashMap();

    public SimpleOrthologueSet() {
        this.generateChangeSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrthologue(Orthologue ortho) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologueSet.add(ortho);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthologueSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthologueSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologueSet.add(ortho);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrthologue(Orthologue ortho) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.orthologueSet.remove(ortho);
        } else {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(OrthologueSet.MODIFY);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, OrthologueSet.MODIFY);
                cs.firePreChangeEvent(ce);
                this.orthologueSet.remove(ortho);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public Orthologue getOrthologue(String homologeneID) {
        return (Orthologue)this.orthologueByHomologeneID.get(homologeneID);
    }

    public OrthologueSet.Iterator iterator() {
        return new Iterator(this.orthologueSet.iterator());
    }

    public class Iterator
    implements OrthologueSet.Iterator {
        private java.util.Iterator orthoIterator;

        private Iterator(java.util.Iterator orthoIterator) {
            this.orthoIterator = orthoIterator;
        }

        public boolean hasNext() {
            return this.orthoIterator.hasNext();
        }

        public Orthologue nextOrthologue() {
            return (Orthologue)this.orthoIterator.next();
        }
    }
}

