/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class CyAttributesWriter {
    public static void writeAttributes(CyAttributes cyAttrs, String attributeName, Writer fileOut) throws IOException {
        BufferedWriter writer = fileOut instanceof BufferedWriter ? (BufferedWriter)fileOut : new BufferedWriter(fileOut);
        byte cyType = cyAttrs.getType(attributeName);
        if (cyType != 1 && cyType != 2 && cyType != 3 && cyType != 4 && cyType != -2) {
            return;
        }
        byte mulType = cyAttrs.getMultiHashMapDefinition().getAttributeValueType(attributeName);
        writer.write(attributeName);
        writer.write(" (class=");
        String className = mulType == 1 ? "java.lang.Boolean" : (mulType == 3 ? "java.lang.Integer" : (mulType == 2 ? "java.lang.Double" : "java.lang.String"));
        writer.write(className);
        writer.write(")");
        writer.newLine();
        CountedIterator keys = cyAttrs.getMultiHashMap().getObjectKeys(attributeName);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            writer.write(key);
            writer.write("=");
            if (cyType == 1) {
                writer.write(cyAttrs.getBooleanAttribute(key, attributeName).toString());
            } else if (cyType == 3) {
                writer.write(cyAttrs.getIntegerAttribute(key, attributeName).toString());
            } else if (cyType == 2) {
                writer.write(cyAttrs.getDoubleAttribute(key, attributeName).toString());
            } else if (cyType == 4) {
                writer.write(cyAttrs.getStringAttribute(key, attributeName));
            } else {
                writer.write("(");
                Iterator listElms = cyAttrs.getListAttribute(key, attributeName).iterator();
                while (listElms.hasNext()) {
                    writer.write(listElms.next().toString());
                    if (!listElms.hasNext()) continue;
                    writer.write("::");
                }
                writer.write(")");
            }
            writer.newLine();
        }
        writer.flush();
    }
}

