/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import ding.view.DGraphView;
import ding.view.DingCanvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class InternalFrameComponent
extends JComponent
implements Printable {
    private JLayeredPane layeredPane;
    private DingCanvas backgroundCanvas;
    private DingCanvas networkCanvas;
    private DingCanvas foregroundCanvas;

    public InternalFrameComponent(JLayeredPane layeredPane, DGraphView dGraphView) {
        this.layeredPane = layeredPane;
        this.backgroundCanvas = dGraphView.getCanvas(DGraphView.Canvas.BACKGROUND_CANVAS);
        this.networkCanvas = dGraphView.getCanvas(DGraphView.Canvas.NETWORK_CANVAS);
        this.foregroundCanvas = dGraphView.getCanvas(DGraphView.Canvas.FOREGROUND_CANVAS);
        this.initLayeredPane();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.backgroundCanvas.setBounds(x, y, width, height);
        this.networkCanvas.setBounds(x, y, width, height);
        this.foregroundCanvas.setBounds(x, y, width, height);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            ((Graphics2D)graphics).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics.clipRect(0, 0, this.backgroundCanvas.getWidth(), this.backgroundCanvas.getHeight());
            this.backgroundCanvas.print(graphics);
            this.networkCanvas.print(graphics);
            this.foregroundCanvas.print(graphics);
            return 0;
        }
        return 1;
    }

    private void initLayeredPane() {
        this.layeredPane.removeAll();
        this.layeredPane.add((Component)this.backgroundCanvas, new Integer(ZOrder.BACKGROUND_PANE.layer()));
        this.layeredPane.add((Component)this.networkCanvas, new Integer(ZOrder.NETWORK_PANE.layer()));
        this.layeredPane.add((Component)this.foregroundCanvas, new Integer(ZOrder.FOREGROUND_PANE.layer()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ZOrder {
        BACKGROUND_PANE,
        NETWORK_PANE,
        FOREGROUND_PANE;


        int layer() {
            if (this == BACKGROUND_PANE) {
                return -30000;
            }
            if (this == NETWORK_PANE) {
                return 0;
            }
            if (this == FOREGROUND_PANE) {
                return 301;
            }
            return 0;
        }
    }
}

