/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.test;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.baderlab.brain.BindingPeptideList;
import org.baderlab.brain.Hit;
import org.baderlab.brain.ProteinDatabaseSearch;
import org.baderlab.brain.ProteinDatabaseSearchParams;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinTerminus;
import org.baderlab.brain.SequenceSearchResultSet;
import org.biojava.bio.BioException;

public class ProteinDatabaseSearchTest
extends TestCase {
    ProteinDatabaseSearch search = null;
    ProteinProfile profile = null;
    ProteinDatabaseSearchParams params = null;
    BindingPeptideList peptideList = null;

    public void setUp() throws Exception {
        this.search = new ProteinDatabaseSearch("testData" + File.separator + "smallDB.fasta", "FASTA");
    }

    public void testProfileSingleHit() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "SH3_pep8.txt");
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(4, ProteinTerminus.C), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(false);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)115L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)115, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileMultipleHits() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "pep4List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIterator(), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(true);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)249L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)238, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileSingleHitFromCTerminus() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "pep4List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(3, ProteinTerminus.C), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)9L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)9, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
        System.out.println(results.toString());
    }

    public void testProfileSingleHitFromNTerminus() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "Nterm-pep3List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIterator(), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)120L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)120, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.3877221301888008, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileMultiHitFromCTerminus() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "pep4List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(3, ProteinTerminus.C), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C, 100);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)1391L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)927, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.4453636983803158, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileMultiHitFromNTerminus() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "Nterm-pep3List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIterator(), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N, 100);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)297L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)287, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.3877221301888008, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileSingleHitFromCTerminusLength() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "pep4List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIteratorByLength(3, ProteinTerminus.C), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C, 100);
        this.params.setMultipleHits(false);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)927L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)927, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.4453636983803158, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileSingleHitFromNTerminusLength() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "Nterm-pep3List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIterator(), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N, 100);
        this.params.setMultipleHits(false);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)287L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)287, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.3877221301888008, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testProfileSingleHitNormalized() throws BioException, IOException {
        this.peptideList = new BindingPeptideList();
        this.peptideList.read("testData" + File.separator + "pep4List.txt");
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMaxPeptideLength());
        ProteinDatabaseSearchTest.assertEquals((int)4, (int)this.peptideList.getMinPeptideLength());
        this.profile = new ProteinProfile(this.peptideList.getSequenceIterator(), 1.0, new String("testProfile"));
        ProteinDatabaseSearchTest.assertEquals((int)8, (int)this.profile.getNumSequences());
        this.params = new ProteinDatabaseSearchParams(false);
        this.params.setNormalized(true);
        SequenceSearchResultSet results = this.search.profileSearchDB(this.profile, 1.0, this.params);
        ProteinDatabaseSearchTest.assertEquals((long)389L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)389, (int)results.getNumberSequencesHit());
        List list = results.getBestHits();
        Hit hit = (Hit)list.get(0);
        ProteinDatabaseSearchTest.assertEquals((double)0.0, (double)hit.getScore(), (double)1.0E-14);
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexSingleHit() throws BioException {
        this.params = new ProteinDatabaseSearchParams(false);
        SequenceSearchResultSet results = this.search.regexSearchDB("VEEE", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)75L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)75, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexMultipleHits() throws BioException {
        this.params = new ProteinDatabaseSearchParams(true);
        SequenceSearchResultSet results = this.search.regexSearchDB("VEEE", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)76L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)75, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexSingleHitFromCTerminus() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C);
        SequenceSearchResultSet results = this.search.regexSearchDB("YEST", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)1L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)1, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexSingleHitFromNTerminus() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N);
        SequenceSearchResultSet results = this.search.regexSearchDB("MVLT", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)3L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)3, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexMultiHitFromCTerminus() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C, 100);
        SequenceSearchResultSet results = this.search.regexSearchDB("EST", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)196L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)193, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexMultiHitFromNTerminus() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N, 100);
        SequenceSearchResultSet results = this.search.regexSearchDB("MVLT", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)7L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)6, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexSingleHitFromCTerminusLength() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.C, 100);
        this.params.setMultipleHits(false);
        SequenceSearchResultSet results = this.search.regexSearchDB("YEST", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)6L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)6, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }

    public void testRegexSingleHitFromNTerminusLength() throws BioException {
        this.params = new ProteinDatabaseSearchParams(ProteinTerminus.N, 100);
        this.params.setMultipleHits(false);
        SequenceSearchResultSet results = this.search.regexSearchDB("MVLT", this.params);
        ProteinDatabaseSearchTest.assertEquals((long)6L, (long)results.getNumberOfHits());
        ProteinDatabaseSearchTest.assertEquals((int)6, (int)results.getNumberSequencesHit());
        ProteinDatabaseSearchTest.assertEquals((long)6702L, (long)results.getNumberOfSequencesSearched());
    }
}

