/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Bookmarks2XML
extends AbstractTool {
    public Bookmarks2XML() {
        this.arguments.add(new FileArgument(this, "pdffile", "the PDF from which you want to extract bookmarks", false, new PdfFilter()));
        this.arguments.add(new FileArgument((AbstractTool)this, "xmlfile", "the resulting bookmarks file in XML", true));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Bookmarks2XML", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Bookmarks2XML OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("xmlfile") == null) {
                throw new InstantiationException("You need to choose an xml file");
            }
            if (this.getValue("pdffile") == null) {
                throw new InstantiationException("You need to choose a source PDF file");
            }
            PdfReader pdfReader = new PdfReader(((File)this.getValue("pdffile")).getAbsolutePath());
            pdfReader.consolidateNamedDestinations();
            List list = SimpleBookmark.getBookmark(pdfReader);
            FileOutputStream fileOutputStream = new FileOutputStream((File)this.getValue("xmlfile"));
            SimpleBookmark.exportToXML(list, fileOutputStream, "UTF-8", false);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Bookmarks2XML bookmarks2XML = new Bookmarks2XML();
        if (stringArray.length < 2) {
            System.err.println(bookmarks2XML.getUsage());
        }
        bookmarks2XML.setArguments(stringArray);
        bookmarks2XML.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        Bookmarks2XML.addVersion("$Id: Bookmarks2XML.java,v 1.1 2006/02/02 15:56:53 blowagie Exp $");
    }
}

