/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.ToggleIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SettingsSavePanel
extends JPanel
implements ItemListener,
ActionListener {
    private JCheckBox checkBox;
    private Icon unchecked = new ToggleIcon(false);
    private Icon checked = new ToggleIcon(true);
    private JTextField fileTextField;
    private JButton saveFileButton;
    private File saveFile;
    private final String LOADCORRECT = "LOADCORRECT";
    private Component settingsPanel;
    private String bingoDir;

    public SettingsSavePanel(String sort, Component settingsPanel, String bingoDir) {
        this.settingsPanel = settingsPanel;
        this.bingoDir = bingoDir;
        this.setOpaque(false);
        this.makeJComponents(sort);
        this.setLayout(new GridLayout());
        this.add(this.checkBox);
        this.add(this.saveFileButton);
        this.add(this.fileTextField);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void makeJComponents(String sort) {
        this.checkBox = new JCheckBox("Check box for saving " + sort);
        this.checkBox.setIcon(this.unchecked);
        this.checkBox.setSelectedIcon(this.checked);
        this.checkBox.addItemListener(this);
        this.saveFileButton = new JButton("Save BiNGO " + sort + " file in : ");
        this.saveFileButton.setEnabled(false);
        this.saveFileButton.addActionListener(this);
        this.fileTextField = new JTextField();
        this.fileTextField.setEnabled(false);
        this.fileTextField.setEditable(false);
        this.fileTextField.setBackground(Color.white);
        this.fileTextField.setForeground(Color.black);
    }

    public String getFileDir() {
        return this.fileTextField.getText();
    }

    public void reset() {
        this.checkBox.setSelected(false);
        this.saveFileButton.setEnabled(false);
        this.fileTextField.setText(null);
    }

    public boolean checked() {
        return this.checkBox.isSelected();
    }

    public String isFileNameLegal(String clusterName) {
        String resultString = "LOADCORRECT";
        if (this.checkBox.isSelected()) {
            try {
                BufferedWriter output = new BufferedWriter(new FileWriter(new File(this.saveFile.toString(), clusterName)));
            }
            catch (Exception e) {
                resultString = "FILE NAMING ERROR:  " + e;
            }
        }
        return resultString;
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.checkBox.isSelected()) {
            this.saveFileButton.setEnabled(true);
            this.fileTextField.setEnabled(true);
        } else {
            this.saveFileButton.setEnabled(false);
            this.fileTextField.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setDialogTitle("Select output directory");
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showSaveDialog(this.settingsPanel);
        if (returnVal == 0) {
            this.saveFile = chooser.getSelectedFile();
            this.fileTextField.setText(this.saveFile.toString());
        }
    }
}

