/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.abi;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.io.CachingInputStream;
import org.biojava.utils.io.Seekable;

public class ABIFParser {
    private DataAccess din;
    private boolean parsed = false;
    private Map records;
    private final int RECORD_COUNT_OFFSET = 18;
    private final int RECORD_OFFSET_OFFSET = 26;

    public ABIFParser(File f) throws IOException {
        this(new RandomAccessFile(f));
    }

    public ABIFParser(InputStream in) throws IOException {
        this(new DataStream(in));
    }

    public ABIFParser(DataAccess toParse) throws IOException {
        this.din = toParse;
        this.readDataRecords();
    }

    public final DataAccess getDataAccess() {
        return this.din;
    }

    private final void readDataRecords() throws IOException {
        this.parsed = false;
        this.din.seek(18L);
        long recordCount = 0xFFFFFFFF & this.din.readInt();
        this.din.seek(26L);
        long recordOffset = 0xFFFFFFFF & this.din.readInt();
        this.din.seek(recordOffset);
        this.records = new HashMap();
        int i = 0;
        while ((long)i < recordCount) {
            TaggedDataRecord tdr = new TaggedDataRecord(this.din);
            StringBuffer label = new StringBuffer(6).append(tdr.tagName).append(tdr.tagNumber);
            this.records.put(label.substring(0), tdr);
            ++i;
        }
        this.parsed = true;
    }

    public static Symbol decodeDNAToken(char token) throws IllegalSymbolException {
        switch (token) {
            case 'A': 
            case 'a': {
                return DNATools.a();
            }
            case 'C': 
            case 'c': {
                return DNATools.c();
            }
            case 'G': 
            case 'g': {
                return DNATools.g();
            }
            case 'T': 
            case 't': {
                return DNATools.t();
            }
            case 'N': 
            case 'n': {
                return DNATools.n();
            }
            case '-': {
                return DNATools.getDNA().getGapSymbol();
            }
        }
        throw new IllegalSymbolException("Can't decode token " + token + " into DNA");
    }

    public TaggedDataRecord getDataRecord(String tagName, int tagNumber) throws IllegalArgumentException, IllegalStateException {
        if (!this.parsed) {
            throw new IllegalStateException("parsing is not complete");
        }
        if (tagNumber < 1) {
            throw new IllegalArgumentException("tagNumber must be positive");
        }
        if (tagName.length() != 4) {
            throw new IllegalArgumentException("tagName must be 4 characters long");
        }
        return (TaggedDataRecord)this.records.get(tagName + tagNumber);
    }

    private static class DataStream
    implements DataAccess {
        CachingInputStream cin;
        DataInputStream din;

        public DataStream(InputStream src) throws IOException {
            this.cin = src instanceof CachingInputStream ? (CachingInputStream)src : new CachingInputStream(src);
            this.cin.seek(0L);
            this.din = new DataInputStream(this.cin);
        }

        public DataStream(CachingInputStream cin) throws IOException {
            this((InputStream)cin);
        }

        public boolean readBoolean() throws IOException {
            return this.din.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.din.readByte();
        }

        public char readChar() throws IOException {
            return this.din.readChar();
        }

        public short readShort() throws IOException {
            return this.din.readShort();
        }

        public int readInt() throws IOException {
            return this.din.readInt();
        }

        public long readLong() throws IOException {
            return this.din.readLong();
        }

        public float readFloat() throws IOException {
            return this.din.readFloat();
        }

        public double readDouble() throws IOException {
            return this.din.readDouble();
        }

        public String readUTF() throws IOException {
            return this.din.readUTF();
        }

        public int readUnsignedByte() throws IOException {
            return this.din.readUnsignedByte();
        }

        public int readUnsignedShort() throws IOException {
            return this.din.readUnsignedShort();
        }

        public void readFully(byte[] values) throws IOException {
            this.din.readFully(values);
        }

        public void readFully(byte[] values, int start, int len) throws IOException {
            this.din.readFully(values, start, len);
        }

        public String readLine() throws IOException {
            throw new UnsupportedOperationException("DataInputStream#readLine is deprecated.  Use readUTF instead");
        }

        public int skipBytes(int count) throws IOException {
            return this.din.skipBytes(count);
        }

        public void seek(long pos) throws IOException {
            this.cin.seek(pos);
        }
    }

    private static class RandomAccessFile
    extends java.io.RandomAccessFile
    implements DataAccess {
        public RandomAccessFile(File f) throws FileNotFoundException {
            super(f, "r");
        }
    }

    public static interface DataAccess
    extends Seekable,
    DataInput {
    }

    public static class TaggedDataRecord {
        public static final int DATA_TYPE_ASCII_ARRAY = 2;
        public static final int DATA_TYPE_INTEGER = 4;
        public static final int DATA_TYPE_FLOAT = 7;
        public static final int DATA_TYPE_DATE = 10;
        public static final int DATA_TYPE_TIME = 11;
        public static final int DATA_TYPE_PSTRING = 18;
        public final char[] tagName = new char[4];
        public final long tagNumber;
        public final int dataType;
        public final int elementLength;
        public final long numberOfElements;
        public final long recordLength;
        public final long dataRecord;
        public final long crypticVariable;

        public TaggedDataRecord(DataAccess din) throws IOException {
            this.tagName[0] = (char)din.readByte();
            this.tagName[1] = (char)din.readByte();
            this.tagName[2] = (char)din.readByte();
            this.tagName[3] = (char)din.readByte();
            this.tagNumber = 0xFFFFFFFF & din.readInt();
            this.dataType = 0xFFFF & din.readShort();
            this.elementLength = 0xFFFF & din.readShort();
            this.numberOfElements = 0xFFFFFFFF & din.readInt();
            this.recordLength = 0xFFFFFFFF & din.readInt();
            this.dataRecord = 0xFFFFFFFF & din.readInt();
            this.crypticVariable = 0xFFFFFFFF & din.readInt();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString()).append("[\n");
            sb.append("  tagName         = ").append(this.tagName).append('\n');
            sb.append("  tagNumber       = ").append(this.tagNumber).append('\n');
            sb.append("  dataType        = ");
            switch (this.dataType) {
                case 2: {
                    sb.append("ASCII");
                    break;
                }
                case 4: {
                    sb.append("INTEGER");
                    break;
                }
                case 7: {
                    sb.append("FLOAT");
                    break;
                }
                case 10: {
                    sb.append("DATE");
                    break;
                }
                case 11: {
                    sb.append("TIME");
                    break;
                }
                case 18: {
                    sb.append("PSTRING");
                    break;
                }
                default: {
                    sb.append(this.dataType);
                }
            }
            sb.append('\n');
            sb.append("  elementLength   = ").append(this.elementLength).append('\n');
            sb.append("  numberOfElements= ").append(this.numberOfElements).append('\n');
            sb.append("  recordLength    = ").append(this.recordLength).append('\n');
            sb.append("  dataRecord      = ");
            if (this.recordLength <= 4L) {
                switch (this.dataType) {
                    case 2: {
                        if (this.elementLength > 3) {
                            sb.append((char)(this.dataRecord >>> 24 & 0xFFL));
                        }
                        if (this.elementLength > 2) {
                            sb.append((char)(this.dataRecord >>> 16 & 0xFFL));
                        }
                        if (this.elementLength > 1) {
                            sb.append((char)(this.dataRecord >>> 8 & 0xFFL));
                        }
                        sb.append((char)(this.dataRecord & 0xFFL));
                        break;
                    }
                    case 10: {
                        sb.append(this.dataRecord >>> 16 & 0xFFFFL).append('/');
                        sb.append(this.dataRecord >>> 8 & 0xFFL).append('/');
                        sb.append(this.dataRecord & 0xFFL);
                        break;
                    }
                    case 11: {
                        sb.append(this.dataRecord >>> 24 & 0xFFL).append(':');
                        sb.append(this.dataRecord >>> 16 & 0xFFL).append(':');
                        sb.append(this.dataRecord >>> 8 & 0xFFL);
                        break;
                    }
                    case 4: {
                        sb.append(this.dataRecord >>> (int)((4L - this.recordLength) * 8L));
                        break;
                    }
                    default: {
                        this.hexStringify((int)this.dataRecord, sb);
                        break;
                    }
                }
            } else {
                this.hexStringify((int)this.dataRecord, sb);
            }
            sb.append('\n');
            sb.append("  crypticVariable = ").append(this.crypticVariable).append('\n');
            sb.append(']');
            return sb.toString();
        }

        private void hexStringify(int l, StringBuffer sb) {
            sb.append("0x");
            String hex = Integer.toHexString(l).toUpperCase();
            for (int i = 8; i > hex.length(); --i) {
                sb.append('0');
            }
            sb.append(hex);
        }
    }
}

