/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.MapOntologyTask;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.CytoscapeAction;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class MapOntologyAction
extends CytoscapeAction
implements PropertyChangeListener {
    public MapOntologyAction() {
        super("Map Ontology...");
        this.initMenu();
    }

    public MapOntologyAction(boolean isMenu, ImageIcon icon) {
        super("Map Ontology...", icon);
        this.initMenu();
    }

    private void initMenu() {
        super.setEnabled(false);
        this.setPreferredMenu("File.Import.Ontology");
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (Cytoscape.getCyNodesList().size() == 0 || Cytoscape.getBioDataServer() == null) {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "There is no network data in memory.\nPlease import/create a network before using GO Mapper.", "No Networks in Memory", 0);
            return;
        }
        MapOntologyTask task = new MapOntologyTask();
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(true);
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(true);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("NETWORK_LOADED") || e.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED) || e.getPropertyName().equals(Cytoscape.DATASERVER_CHANGED)) {
            if (Cytoscape.getBioDataServer() == null) {
                super.setEnabled(false);
            } else if (Cytoscape.getBioDataServer().getAnnotationCount() == 0 || Cytoscape.getNetworkSet().size() == 0) {
                super.setEnabled(false);
            } else {
                super.setEnabled(true);
            }
        }
    }
}

