/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.InteractionWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

class SaveAsSifTask
implements Task {
    private String fileName;
    private TaskMonitor taskMonitor;

    SaveAsSifTask(String fileName) {
        this.fileName = fileName;
    }

    public void run() {
        this.taskMonitor.setStatus("Saving Interactions...");
        try {
            if (Cytoscape.getCurrentNetwork().getNodeCount() == 0) {
                throw new IllegalArgumentException("Network is empty.");
            }
            FileWriter f = new FileWriter(this.fileName);
            CyNetwork netToSave = Cytoscape.getCurrentNetwork();
            InteractionWriter.writeInteractions(netToSave, f, this.taskMonitor);
            f.close();
            Object[] ret_val = new Object[]{netToSave, new File(this.fileName).toURI(), new Integer(Cytoscape.FILE_SIF)};
            Cytoscape.firePropertyChange("NETWORK_SAVED", null, ret_val);
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Network successfully saved to:  " + this.fileName);
        }
        catch (IllegalArgumentException e) {
            this.taskMonitor.setException((Throwable)e, "Network is Empty.  Cannot be saved.");
        }
        catch (IOException e) {
            this.taskMonitor.setException((Throwable)e, "Unable to save network.");
        }
    }

    public void halt() {
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Saving Network");
    }
}

