/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.AllTests;
import cytoscape.data.Interaction;
import cytoscape.data.readers.InteractionsReader;
import cytoscape.data.servers.BioDataServer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class InteractionsReaderTest
extends TestCase {
    private boolean runAllTests = AllTests.runAllTests();
    private BioDataServer nullServer = null;
    private String species = "unknown";

    public InteractionsReaderTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testReadFromTypicalFile() throws Exception {
        AllTests.standardOut("testFromTypicalFile");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 25 ? 1 : 0) != 0);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactions[0].getSource().equals("YNL312W"));
        InteractionsReaderTest.assertTrue((boolean)interactions[0].getType().equals("pd"));
        InteractionsReaderTest.assertTrue((interactions[0].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactions[0].getTargets()[0].equals("YPL111W"));
        InteractionsReaderTest.assertTrue((interactions[11].numberOfTargets() == 3 ? 1 : 0) != 0);
    }

    public void testReadFileWithNoInteractions() throws Exception {
        AllTests.standardOut("testReadFileWithNoInteractions");
        InteractionsReader reader = this.getReader("testData/degenerate.sif");
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 9 ? 1 : 0) != 0);
        Interaction[] interactions = reader.getAllInteractions();
        for (int i = 0; i < interactions.length; ++i) {
            InteractionsReaderTest.assertTrue((boolean)interactions[i].getSource().startsWith("Y"));
            InteractionsReaderTest.assertTrue((interactions[i].getType() == null ? 1 : 0) != 0);
            InteractionsReaderTest.assertTrue((interactions[i].numberOfTargets() == 0 ? 1 : 0) != 0);
        }
    }

    public void testGetGraph() throws Exception {
        AllTests.standardOut("testGetGraph");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 25 ? 1 : 0) != 0);
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        InteractionsReaderTest.assertTrue((String)("node count: expect 31, got " + nodes.length), (nodes.length == 31 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((String)("edge count: expect 27, got " + edges.length), (edges.length == 27 ? 1 : 0) != 0);
    }

    public void testGetGraphAndEdgeAttributes() throws Exception {
        AllTests.standardOut("testGetGraphAndEdgeAttributes");
        InteractionsReader reader = this.getReader("testData/sample.sif");
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 25 ? 1 : 0) != 0);
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        InteractionsReaderTest.assertTrue((String)("node count: expect 31, got " + nodes.length), (nodes.length == 31 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((String)("edge count: expect 27, got " + edges.length), (edges.length == 27 ? 1 : 0) != 0);
    }

    public void testReadMultiWordProteinsFile() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFile");
        String filename = "testData/multiWordProteins.sif";
        InteractionsReader reader = this.getReader(filename);
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 29 ? 1 : 0) != 0);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactions[16].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactions[28].numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    public void testReadMultiWordProteinsFileWithErrantSpaces() throws Exception {
        AllTests.standardOut("testReadMultiWordProteinsFileWithErrantSpaces");
        String filename = "testData/multiWordProteinsFileTrailingSpaces.sif";
        InteractionsReader reader = this.getReader(filename);
        reader.read();
        InteractionsReaderTest.assertTrue((reader.getCount() == 29 ? 1 : 0) != 0);
        Interaction[] interactions = reader.getAllInteractions();
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getSource().equals("26S ubiquitin dependent proteasome"));
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactions[16].numberOfTargets() == 1 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactions[16].getTargets()[0].equals("I-kappa-B-alpha"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getSource().equals("TRAF6"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getType().equals("interactsWith"));
        InteractionsReaderTest.assertTrue((interactions[28].numberOfTargets() == 3 ? 1 : 0) != 0);
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[0].equals("RIP2"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[1].equals("ABCDE oopah"));
        InteractionsReaderTest.assertTrue((boolean)interactions[28].getTargets()[2].equals("HJKOL coltrane"));
    }

    private InteractionsReader getReader(String file) {
        if (this.runAllTests) {
            file = new String("testData/" + file);
        }
        InteractionsReader reader = new InteractionsReader(file);
        return reader;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(InteractionsReaderTest.class));
    }
}

