/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.Category;
import cytoscape.bookmarks.DataSource;
import cytoscape.data.ImportHandler;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.xml.bind.JAXBException;
import org.jdesktop.layout.GroupLayout;

public class ImportNetworkDialog
extends JDialog
implements ActionListener {
    private boolean status;
    private File[] networkFiles;
    private Bookmarks theBookmarks = null;
    private String bookmarkCategory = "network";
    private String URLstr;
    private BookmarkComboBoxEditor bookmarkEditor = new BookmarkComboBoxEditor();
    private String pleaseMessage = "Please provide URL or select from list";
    private JButton cancelButton;
    private JButton importButton;
    private JPanel radioButtonPanel;
    private JButton selectButton;
    private ButtonGroup buttonGroup1;
    private JComboBox networkFileComboBox;
    private JLabel titleLabel;
    private JRadioButton remoteRadioButton;
    private JRadioButton localRadioButton;
    private JTextField networkFileTextField;
    private JSeparator titleSeparator;

    public ImportNetworkDialog(Frame parent, boolean modal) throws JAXBException, IOException {
        super(parent, modal);
        Category theCategory;
        this.setTitle("Import Network");
        this.initComponents();
        this.addListeners();
        this.switchImportView("Local");
        this.status = false;
        this.networkFiles = null;
        this.theBookmarks = Cytoscape.getBookmarks();
        if (this.theBookmarks == null) {
            this.theBookmarks = new Bookmarks();
            Cytoscape.setBookmarks(this.theBookmarks);
        }
        if ((theCategory = BookmarksUtil.getCategory(this.bookmarkCategory, this.theBookmarks.getCategory())) == null) {
            theCategory = new Category();
            theCategory.setName(this.bookmarkCategory);
            List<Category> theCategoryList = this.theBookmarks.getCategory();
            theCategoryList.add(theCategory);
        }
    }

    public File getFile() {
        if (this.networkFiles != null && this.networkFiles.length > 0) {
            return this.networkFiles[0];
        }
        return null;
    }

    public File[] getFiles() {
        return this.networkFiles;
    }

    public boolean getStatus() {
        return this.status;
    }

    public boolean isRemote() {
        return this.remoteRadioButton.isSelected();
    }

    public String getURLStr() {
        return this.URLstr;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.titleLabel = new JLabel();
        this.localRadioButton = new JRadioButton();
        this.remoteRadioButton = new JRadioButton();
        this.networkFileTextField = new JTextField();
        this.networkFileComboBox = new JComboBox();
        this.selectButton = new JButton();
        this.importButton = new JButton();
        this.cancelButton = new JButton();
        this.titleSeparator = new JSeparator();
        this.radioButtonPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setFont(new Font("Sans-Serif", 1, 14));
        this.titleLabel.setText("Import Network File");
        this.radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Data Source Type"));
        this.buttonGroup1.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        this.localRadioButton.setText("Local");
        this.localRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.remoteRadioButton);
        this.remoteRadioButton.setText("Remote");
        this.remoteRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.remoteRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.networkFileTextField.setText("Please select a network file...");
        this.networkFileTextField.setName("networkFileTextField");
        this.selectButton.setText("Select");
        this.importButton.setText("Import");
        this.importButton.setName("btnImport");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("btnCancel");
        this.networkFileComboBox.setRenderer(new MyCellRenderer());
        this.networkFileComboBox.setEditor(this.bookmarkEditor);
        this.networkFileComboBox.setEditable(true);
        this.networkFileComboBox.setName("networkFileComboBox");
        GroupLayout radioButtonPanelLayout = new GroupLayout((Container)this.radioButtonPanel);
        this.radioButtonPanel.setLayout((LayoutManager)radioButtonPanelLayout);
        radioButtonPanelLayout.setHorizontalGroup((GroupLayout.Group)radioButtonPanelLayout.createParallelGroup(1).add((GroupLayout.Group)radioButtonPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.localRadioButton).addPreferredGap(0).add((Component)this.remoteRadioButton).addContainerGap(250, Short.MAX_VALUE)));
        radioButtonPanelLayout.setVerticalGroup((GroupLayout.Group)radioButtonPanelLayout.createParallelGroup(1).add((GroupLayout.Group)radioButtonPanelLayout.createSequentialGroup().add((GroupLayout.Group)radioButtonPanelLayout.createParallelGroup(3).add((Component)this.localRadioButton).add((Component)this.remoteRadioButton))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.networkFileComboBox, 0, 350, Short.MAX_VALUE).add((Component)this.titleLabel, -2, 350, -2).add((Component)this.titleSeparator, -1, 350, Short.MAX_VALUE).add((Component)this.radioButtonPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.networkFileTextField, -1, 350, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.selectButton)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.importButton).addPreferredGap(0).add((Component)this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).add(8, 8, 8).add((Component)this.titleSeparator, -2, -1, -2).add(7, 7, 7).add((Component)this.radioButtonPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.selectButton).add((Component)this.networkFileTextField)).add((Component)this.networkFileComboBox, -2, -1, -2).addPreferredGap(0, 3, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.importButton)).addContainerGap()));
        this.pack();
        this.pack();
    }

    private void addListeners() {
        LocalRemoteListener l = new LocalRemoteListener();
        this.localRadioButton.addActionListener(l);
        this.remoteRadioButton.addActionListener(l);
        this.selectButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.bookmarkEditor.addActionListener(this);
    }

    private void switchImportView(String pLocation) {
        if (pLocation.equalsIgnoreCase("Local")) {
            this.networkFileComboBox.setVisible(false);
            this.networkFileTextField.setVisible(true);
            this.selectButton.setVisible(true);
        } else {
            this.networkFileComboBox.setVisible(true);
            this.networkFileTextField.setVisible(false);
            this.selectButton.setVisible(false);
            this.loadBookmarkCMBox();
        }
    }

    private void loadBookmarkCMBox() {
        this.networkFileComboBox.removeAllItems();
        DefaultComboBoxModel<DataSource> theModel = new DefaultComboBoxModel<DataSource>();
        DataSource firstDataSource = new DataSource();
        firstDataSource.setName("");
        firstDataSource.setHref(" " + this.pleaseMessage);
        theModel.addElement(firstDataSource);
        List<DataSource> theDataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory());
        if (theDataSourceList != null) {
            for (int i = 0; i < theDataSourceList.size(); ++i) {
                theModel.addElement(theDataSourceList.get(i));
            }
        }
        this.networkFileComboBox.setModel(theModel);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.status = false;
        this.dispose();
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.status = true;
        this.dispose();
    }

    private void selectNetworkFileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter[] tempCFF = Cytoscape.getImportHandler().getAllFilters(ImportHandler.GRAPH_NATURE).toArray(new CyFileFilter[0]);
        this.networkFiles = FileUtil.getFiles("Import Network Files", FileUtil.LOAD, tempCFF);
        if (this.networkFiles != null) {
            StringBuffer fileNameSB = new StringBuffer();
            StringBuffer tooltip = new StringBuffer();
            tooltip.append("<html><body><strong><font color=RED>The following files will be loaded:</font></strong><br>");
            for (int i = 0; i < this.networkFiles.length; ++i) {
                fileNameSB.append(this.networkFiles[i].getAbsolutePath() + ", ");
                tooltip.append("<p>" + this.networkFiles[i].getAbsolutePath() + "</p>");
            }
            tooltip.append("</body></html>");
            this.networkFileTextField.setText(fileNameSB.toString());
            this.networkFileTextField.setToolTipText(tooltip.toString());
            this.importButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            JButton _btn = (JButton)_actionObject;
            if (_btn == this.selectButton) {
                this.selectNetworkFileButtonActionPerformed(e);
            } else if (_btn == this.importButton) {
                if (this.localRadioButton.isSelected()) {
                    this.importButtonActionPerformed(e);
                } else {
                    this.createURLimportTask(e);
                }
            } else if (_btn == this.cancelButton) {
                this.cancelButtonActionPerformed(e);
            }
        }
        if (_actionObject instanceof JTextField) {
            this.createURLimportTask(e);
        }
    }

    private void createURLimportTask(ActionEvent e) {
        String theURLstr = this.bookmarkEditor.getURLstr().trim();
        URL theURL = null;
        try {
            theURL = new URL(theURLstr);
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this, "URL error!", "Warning", 1);
            return;
        }
        URLdownloadTask task = new URLdownloadTask(theURL, e);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }

    private void doURLimport(URL url, ActionEvent e, TaskMonitor taskMonitor) {
        ImportHandler theHandler = Cytoscape.getImportHandler();
        File tmpFile = null;
        try {
            tmpFile = theHandler.downloadFromURL(url, taskMonitor);
        }
        catch (MalformedURLException e1) {
            JOptionPane.showMessageDialog(this, "URL error!", "Warning", 1);
        }
        catch (FileNotFoundException e2) {
            JOptionPane.showMessageDialog(this, "File was not found! Please make sure the URL is correct!", "Warning", 1);
        }
        catch (IOException e3) {
            JOptionPane.showMessageDialog(this, "IO error! May caused by server-name, proxy, write-permission.", "Warning", 1);
        }
        catch (Exception e4) {
            JOptionPane.showMessageDialog(this, "Failed to download from URL!", "Warning", 1);
        }
        if (tmpFile == null) {
            return;
        }
        this.networkFiles = new File[1];
        this.networkFiles[0] = tmpFile;
        this.importButtonActionPerformed(e);
    }

    static /* synthetic */ String access$300(ImportNetworkDialog x0) {
        return x0.pleaseMessage;
    }

    class BookmarkComboBoxEditor
    implements ComboBoxEditor {
        DataSource theDataSource = new DataSource();
        JTextField tfInput = new JTextField(ImportNetworkDialog.access$300(ImportNetworkDialog.this));

        BookmarkComboBoxEditor() {
        }

        public String getURLstr() {
            return this.tfInput.getText();
        }

        public void addActionListener(ActionListener l) {
            this.tfInput.addActionListener(l);
        }

        public void addKeyListener(KeyListener l) {
            this.tfInput.addKeyListener(l);
        }

        public Component getEditorComponent() {
            return this.tfInput;
        }

        public Object getItem() {
            return this.theDataSource;
        }

        public void removeActionListener(ActionListener l) {
        }

        public void selectAll() {
        }

        public void setItem(Object anObject) {
            if (anObject == null) {
                return;
            }
            if (anObject instanceof DataSource) {
                this.theDataSource = (DataSource)anObject;
                this.tfInput.setText(this.theDataSource.getHref());
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataSource dataSource = (DataSource)value;
            this.setText(dataSource.getName());
            if (isSelected && 0 < index) {
                list.setToolTipText(dataSource.getHref());
            }
            return this;
        }
    }

    class LocalRemoteListener
    implements ActionListener {
        LocalRemoteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object _actionObject = e.getSource();
            if (_actionObject instanceof JRadioButton) {
                JRadioButton _rbt = (JRadioButton)_actionObject;
                if (_rbt == ImportNetworkDialog.this.localRadioButton) {
                    ImportNetworkDialog.this.switchImportView("Local");
                } else {
                    ImportNetworkDialog.this.switchImportView("Remote");
                }
                ImportNetworkDialog.this.pack();
            }
        }
    }

    private class URLdownloadTask
    implements Task {
        private TaskMonitor taskMonitor;
        URL url;
        ActionEvent e;

        public URLdownloadTask(URL url, ActionEvent e) {
            this.url = url;
            this.e = e;
        }

        public void run() {
            this.taskMonitor.setStatus("Downloading ...");
            this.taskMonitor.setPercentCompleted(-1);
            ImportNetworkDialog.this.doURLimport(this.url, this.e, this.taskMonitor);
            this.taskMonitor.setPercentCompleted(100);
            this.taskMonitor.setStatus("Downloading successfully from " + this.url.toString());
        }

        public void halt() {
        }

        public void setTaskMonitor(TaskMonitor monitor) throws IllegalThreadStateException {
            this.taskMonitor = monitor;
        }

        public String getTitle() {
            return "URL downloading";
        }
    }
}

