/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.Iterator;
import org.baderlab.brain.DatabaseReference;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;

public class GenPeptUtil {
    public static DatabaseReference getAccession(Sequence genPeptSequence) {
        Annotation seqAnn = genPeptSequence.getAnnotation();
        String dbname = null;
        String dbid = null;
        if (seqAnn.containsProperty((Object)"ACCESSION")) {
            String accession = (String)seqAnn.getProperty((Object)"ACCESSION");
            String[] accessionArray = accession.split("\\s+");
            String firstAccession = null;
            firstAccession = accessionArray[0];
            if (accessionArray.length > 0) {
                dbid = firstAccession;
            }
        }
        if (seqAnn.containsProperty((Object)"DBSOURCE")) {
            String dbSource = (String)seqAnn.getProperty((Object)"DBSOURCE");
            int endSource = dbSource.indexOf(":");
            if (endSource < 0) {
                return null;
            }
            String dbArray = null;
            dbname = dbArray = dbSource.substring(0, endSource);
        }
        DatabaseReference xref = null;
        if (dbname != null && dbid != null) {
            xref = new DatabaseReference(dbname, dbid);
        }
        return xref;
    }

    public static DatabaseReference getEntrezGeneID(Sequence genPeptSequence) {
        String dbname = new String("Entrez Gene");
        String dbid = null;
        Iterator fi = genPeptSequence.features();
        while (fi.hasNext()) {
            ArrayList dbRefs;
            Feature f = (Feature)fi.next();
            if (f.getAnnotation() == null || !f.getType().equals("CDS") || (dbRefs = GenPeptUtil.extractGenericAnnotation("db_xref", f)) == null) continue;
            for (int i = 0; i < dbRefs.size(); ++i) {
                String s = (String)dbRefs.get(i);
                if (s == null || !s.startsWith("GeneID") || s.indexOf(":") <= 0) continue;
                dbid = s.substring(s.indexOf(":") + 1, s.length());
            }
        }
        DatabaseReference xref = null;
        if (dbname != null && dbid != null) {
            xref = new DatabaseReference(dbname, dbid);
        }
        return xref;
    }

    private static ArrayList extractGenericAnnotation(String name, Feature f) {
        String xref = null;
        ArrayList xrefList = null;
        if (f.getAnnotation().containsProperty((Object)name)) {
            Object xrefObj = f.getAnnotation().getProperty((Object)name);
            if (xrefObj.getClass().equals(String.class)) {
                xref = (String)xrefObj;
                xrefList = new ArrayList(1);
                xrefList.add(xref);
            } else if (xrefObj.getClass().equals(ArrayList.class)) {
                xrefList = (ArrayList)xrefObj;
            }
        }
        return xrefList;
    }

    public static String getGeneName(Sequence sequence) {
        String name = null;
        Iterator fi = sequence.features();
        while (fi.hasNext()) {
            Feature f = (Feature)fi.next();
            if (f.getAnnotation() == null || !f.getType().equals("CDS")) continue;
            name = GenPeptUtil.extractAnnotationStringByName("gene", f);
        }
        return name;
    }

    private static String extractAnnotationStringByName(String name, Feature f) {
        ArrayList retVal = GenPeptUtil.extractGenericAnnotation(name, f);
        if (retVal == null) {
            return null;
        }
        return (String)retVal.get(0);
    }
}

