/*
 * Decompiled with CFR 0.152.
 */
package BiNGO;

import BiNGO.TypeOfIdentifierPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ChooseAnnotationPanel
extends JPanel
implements ActionListener {
    private final String NONE = "---";
    private final String YEAST = "Saccharomyces cerevisiae";
    private final String ARABIDOPSIS = "Arabidopsis thaliana";
    private final String ORYZA_NIVARA = "Oryza nivara";
    private final String POMBE = "Schizosaccharomyces pombe";
    private final String TRYPANOSOMA = "Trypanosoma brucei";
    private final String C_ELEGANS = "Caenorhabditis elegans";
    private final String DROSOPHILA = "Drosophila melanogaster";
    private final String ZEBRA = "Brachydanio rerio";
    private final String HUMAN = "Homo Sapiens";
    private final String MOUSE = "Mus musculus";
    private final String RAT = "Rattus norvegicus";
    private final String PLASMODIUM = "Plasmodium falsiparum";
    private final String ORYZA_SATIVA = "Oryza sativa";
    private final String ANTHRAX = "Bacillus anthracis";
    private final String SHEWANELLA = "Shewanella oneidensis";
    private final String PSEUDOMONAS_SYRINGAE = "Pseudomonas syringae";
    private final String COXIELLA_BURNETII = "Coxiella burnetii";
    private final String GEOBACTER_SULFURREDUCENS = "Geobacter sulfurreducens";
    private final String METHYLOCOCCUS_CAPSULATUS = "Methylococcus capsulatus";
    private final String LISTERIA_MONOCYTOGENES = "Listeria monocytogenes";
    private final String CUSTOM = "Custom...";
    private final String[] choiceArray = new String[]{"---", "Arabidopsis thaliana", "Bacillus anthracis", "Brachydanio rerio", "Caenorhabditis elegans", "Coxiella burnetii", "Drosophila melanogaster", "Geobacter sulfurreducens", "Homo Sapiens", "Listeria monocytogenes", "Methylococcus capsulatus", "Mus musculus", "Oryza nivara", "Oryza sativa", "Plasmodium falsiparum", "Pseudomonas syringae", "Rattus norvegicus", "Saccharomyces cerevisiae", "Schizosaccharomyces pombe", "Shewanella oneidensis", "Trypanosoma brucei", "Custom..."};
    private JComboBox choiceBox;
    private TypeOfIdentifierPanel typeOfIdentifierPanel;
    private File openFile = null;
    private Component settingsPanel;
    private boolean def = true;
    private String bingoDir;

    public ChooseAnnotationPanel(Component settingsPanel, String bingoDir) {
        this.bingoDir = bingoDir;
        this.settingsPanel = settingsPanel;
        this.setOpaque(false);
        this.makeJComponents();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        gridbag.setConstraints(this.choiceBox, c);
        this.add(this.choiceBox);
        c.gridheight = 2;
        c.weighty = 2.0;
        gridbag.setConstraints(this.typeOfIdentifierPanel, c);
        this.add(this.typeOfIdentifierPanel);
        this.typeOfIdentifierPanel.enableButtons();
        this.choiceBox.setSelectedItem("Saccharomyces cerevisiae");
        File tmp = new File(bingoDir, "BiNGO");
        this.openFile = new File(tmp, "S_cerevisiae_default");
        this.def = true;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void makeJComponents() {
        this.choiceBox = new JComboBox<String>(this.choiceArray);
        this.choiceBox.setEditable(false);
        this.choiceBox.addActionListener(this);
        this.typeOfIdentifierPanel = new TypeOfIdentifierPanel();
    }

    public TypeOfIdentifierPanel getTypeOfIdentifierPanel() {
        return this.typeOfIdentifierPanel;
    }

    public File getFile() {
        return this.openFile;
    }

    public String getSelection() {
        return this.choiceBox.getSelectedItem().toString();
    }

    public boolean getDefault() {
        return this.def;
    }

    public void actionPerformed(ActionEvent event) {
        this.typeOfIdentifierPanel.enableButtons();
        File tmp = new File(this.bingoDir, "BiNGO");
        if (this.choiceBox.getSelectedItem().equals("---")) {
            this.openFile = null;
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Custom...")) {
            JFileChooser chooser = new JFileChooser(this.bingoDir);
            int returnVal = chooser.showOpenDialog(this.settingsPanel);
            if (returnVal == 0) {
                this.openFile = chooser.getSelectedFile();
                this.choiceBox.setEditable(true);
                this.choiceBox.setSelectedItem(this.openFile.toString());
                this.choiceBox.setEditable(false);
                this.typeOfIdentifierPanel.disableButtons();
                this.def = false;
            }
            if (returnVal == 1) {
                this.choiceBox.setSelectedItem("---");
                this.def = true;
            }
        } else if (this.choiceBox.getSelectedItem().equals("Bacillus anthracis")) {
            this.openFile = new File(tmp, "B_anthracis_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Brachydanio rerio")) {
            this.openFile = new File(tmp, "B_rerio_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Arabidopsis thaliana")) {
            this.openFile = new File(tmp, "A_thaliana_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Caenorhabditis elegans")) {
            this.openFile = new File(tmp, "C_elegans_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Coxiella burnetii")) {
            this.openFile = new File(tmp, "C_burnetii_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Drosophila melanogaster")) {
            this.openFile = new File(tmp, "D_melanogaster_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Geobacter sulfurreducens")) {
            this.openFile = new File(tmp, "G_sulfurreducens_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Homo Sapiens")) {
            this.openFile = new File(tmp, "H_sapiens_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Listeria monocytogenes")) {
            this.openFile = new File(tmp, "L_monocytogenes_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Methylococcus capsulatus")) {
            this.openFile = new File(tmp, "M_capsulatus_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Mus musculus")) {
            this.openFile = new File(tmp, "M_musculus_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Oryza nivara")) {
            this.openFile = new File(tmp, "O_nivara_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Oryza sativa")) {
            this.openFile = new File(tmp, "O_sativa_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Plasmodium falsiparum")) {
            this.openFile = new File(tmp, "P_falsiparum_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Pseudomonas syringae")) {
            this.openFile = new File(tmp, "P_syringae_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Rattus norvegicus")) {
            this.openFile = new File(tmp, "R_norvegicus_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Saccharomyces cerevisiae")) {
            this.openFile = new File(tmp, "S_cerevisiae_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Schizosaccharomyces pombe")) {
            this.openFile = new File(tmp, "S_pombe_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Shewanella oneidensis")) {
            this.openFile = new File(tmp, "S_oneidensis_default");
            this.def = true;
        } else if (this.choiceBox.getSelectedItem().equals("Trypanosoma brucei")) {
            this.openFile = new File(tmp, "T_brucei_default");
            this.def = true;
        } else {
            this.choiceBox.setSelectedItem("---");
            this.def = true;
        }
    }
}

