/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntDoubleHashMap;
import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.OpenIntObjectHashMap;
import com.sosnoski.util.hashmap.IntStringHashMap;
import com.sosnoski.util.hashmap.StringIntHashMap;
import giny.model.Node;
import java.util.HashSet;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class NetworkData {
    public static String NODE_ATTRIBUTE_ADDED = "NODE_ATTRIBUTE_ADDED";
    public static String NODE_ATTRIBUTE_REMOVED = "NODE_ATTRIBUTE_REMOVED";
    public static String EDGE_ATTRIBUTE_ADDED = "EDGE_ATTRIBUTE_ADDED";
    public static String EDGE_ATTRIBUTE_REMOVED = "EDGE_ATTRIBUTE_REMOVED";
    public static int DOUBLE_TYPE = 0;
    public static int STRING_TYPE = 1;
    public static int OBJECT_TYPE = 2;
    public static int NO_SUCH_ATTRIBUTE = -1;
    public static int VALUE_NOT_A_DOUBLE = -2;
    public static int INSANE_ATTRIBUTE_TYPE = -4;
    public static int WRONG_ATTRIBUTE_TYPE = -8;
    public static int INSANE_ATTRIBUTE_ID = -16;
    public static int ATTRIBUTE_ALREADY_ASSIGNED = -32;
    protected static Object pcsO = new Object();
    private static SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(pcsO);
    private static OpenIntObjectHashMap nodeAttributeIDToAttributeValuesMap;
    private static StringIntHashMap nodeAttNameToAttIDMap;
    private static OpenIntObjectHashMap nodeAttIDToAttNameMap;
    private static OpenIntIntHashMap nodeAttIDToAttTypeMap;
    private static OpenIntDoubleHashMap nodeAttIDToMinMap;
    private static OpenIntDoubleHashMap nodeAttIDToMaxMap;
    private static OpenIntDoubleHashMap nodeAttIDToMeanMap;
    private static OpenIntDoubleHashMap nodeAttIDToMedianMap;
    private static OpenIntDoubleHashMap nodeAttIDLastUpdate;
    private static StringIntHashMap nodeAliasToIDMap;
    private static int nodeAttributeCount;

    public static int addNodeAttribute(String attribute_name) {
        return NetworkData.addNodeAttribute(attribute_name, OBJECT_TYPE);
    }

    public static int addNodeAttribute(String attribute_name, int attribute_type) {
        StringIntHashMap a2id = NetworkData.getNodeAttNameToAttIDMap();
        if (a2id.containsKey(attribute_name)) {
            return ATTRIBUTE_ALREADY_ASSIGNED;
        }
        if (attribute_type != OBJECT_TYPE && attribute_type != DOUBLE_TYPE && attribute_type != STRING_TYPE) {
            return INSANE_ATTRIBUTE_TYPE;
        }
        int id = nodeAttributeCount++;
        a2id.add(attribute_name, id);
        OpenIntObjectHashMap id2a = NetworkData.getNodeAttIDToAttNameMap();
        id2a.put(id, (Object)attribute_name);
        OpenIntIntHashMap id2t = NetworkData.getNodeAttIDToAttTypeMap();
        id2t.put(id, attribute_type);
        OpenIntObjectHashMap a2v = NetworkData.getNodeAttributeIDToAttributeValuesMap();
        if (attribute_type == DOUBLE_TYPE) {
            OpenIntDoubleHashMap double_map = new OpenIntDoubleHashMap();
            a2v.put(id, (Object)double_map);
        } else if (attribute_type == STRING_TYPE) {
            IntStringHashMap string_map = new IntStringHashMap();
            a2v.put(id, (Object)string_map);
        } else {
            OpenIntObjectHashMap object_map = new OpenIntObjectHashMap();
            a2v.put(id, (Object)object_map);
        }
        return id;
    }

    public static int getNodeAttributeType(String attribute) {
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            return NO_SUCH_ATTRIBUTE;
        }
        return NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
    }

    public static int getNodeAttributeID(String attribute) {
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            return NO_SUCH_ATTRIBUTE;
        }
        return att_id;
    }

    public static int setNodeAttributeValue(Node node, String attribute, Object value) {
        int node_index = node.getRootGraphIndex();
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, OBJECT_TYPE);
        }
        return NetworkData.setNodeAttributeObjectValue(node_index, att_id, value);
    }

    public static int setNodeAttributeValue(Node node, String attribute, Object value, int attribute_type) {
        int node_index = node.getRootGraphIndex();
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, attribute_type);
        }
        if (attribute_type == OBJECT_TYPE) {
            return NetworkData.setNodeAttributeObjectValue(node_index, att_id, value);
        }
        if (attribute_type == DOUBLE_TYPE) {
            Double dub = null;
            if (value instanceof Double) {
                dub = (Double)value;
            } else if (value instanceof String) {
                try {
                    dub = new Double((String)value);
                }
                catch (NumberFormatException nfe) {
                    return VALUE_NOT_A_DOUBLE;
                }
            }
            if (dub == null) {
                return VALUE_NOT_A_DOUBLE;
            }
            return NetworkData.setNodeAttributeDoubleValue(node_index, att_id, (double)dub);
        }
        if (attribute_type == STRING_TYPE) {
            return NetworkData.setNodeAttributeStringValue(node_index, att_id, value.toString());
        }
        return INSANE_ATTRIBUTE_TYPE;
    }

    public static int setNodeAttributeObjectValue(int node_index, String attribute, Object value) {
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, OBJECT_TYPE);
        }
        return NetworkData.setNodeAttributeObjectValue(node_index, att_id, value);
    }

    public static int setNodeAttributeObjectValue(Node node, String attribute, Object value) {
        int node_index = node.getRootGraphIndex();
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, OBJECT_TYPE);
        }
        return NetworkData.setNodeAttributeObjectValue(node_index, att_id, value);
    }

    public static int setNodeAttributeObjectValue(int node_index, int att_id, Object value) {
        if (att_id > nodeAttributeCount) {
            return INSANE_ATTRIBUTE_ID;
        }
        if (NetworkData.getNodeAttIDToAttTypeMap().get(att_id) != OBJECT_TYPE) {
            return WRONG_ATTRIBUTE_TYPE;
        }
        OpenIntObjectHashMap object_map = (OpenIntObjectHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id);
        object_map.put(node_index, value);
        return 1;
    }

    public static int setNodeAttributeDoubleValue(int node_index, String attribute, double value) {
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, DOUBLE_TYPE);
        }
        return NetworkData.setNodeAttributeDoubleValue(node_index, att_id, value);
    }

    public static int setNodeAttributeDoubleValue(Node node, String attribute, double value) {
        int node_index = node.getRootGraphIndex();
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, DOUBLE_TYPE);
        }
        return NetworkData.setNodeAttributeDoubleValue(node_index, att_id, value);
    }

    public static int setNodeAttributeDoubleValue(int node_index, int att_id, double value) {
        if (att_id > nodeAttributeCount) {
            return INSANE_ATTRIBUTE_ID;
        }
        if (NetworkData.getNodeAttIDToAttTypeMap().get(att_id) != DOUBLE_TYPE) {
            return WRONG_ATTRIBUTE_TYPE;
        }
        OpenIntDoubleHashMap double_map = (OpenIntDoubleHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id);
        double_map.put(node_index, value);
        return 1;
    }

    public static int setNodeAttributeStringValue(int node_index, String attribute, String value) {
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, STRING_TYPE);
        }
        return NetworkData.setNodeAttributeStringValue(node_index, att_id, value);
    }

    public static int setNodeAttributeStringValue(Node node, String attribute, String value) {
        int node_index = node.getRootGraphIndex();
        int att_id = NetworkData.getNodeAttNameToAttIDMap().get(attribute);
        if (att_id == Integer.MIN_VALUE) {
            att_id = NetworkData.addNodeAttribute(attribute, STRING_TYPE);
        }
        return NetworkData.setNodeAttributeStringValue(node_index, att_id, value);
    }

    public static int setNodeAttributeStringValue(int node_index, int att_id, String value) {
        if (att_id > nodeAttributeCount) {
            return INSANE_ATTRIBUTE_ID;
        }
        if (NetworkData.getNodeAttIDToAttTypeMap().get(att_id) != STRING_TYPE) {
            return WRONG_ATTRIBUTE_TYPE;
        }
        IntStringHashMap string_map = (IntStringHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id);
        string_map.add(node_index, value);
        return 1;
    }

    public static Object getNodeAttributeValue(Node node, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return null;
        }
        int node_index = node.getRootGraphIndex();
        return NetworkData.getNodeAttributeValue(node_index, att_id);
    }

    public static Object getNodeAttributeValue(int node_index, int att_id) {
        if (att_id > nodeAttributeCount) {
            return null;
        }
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == OBJECT_TYPE) {
            return ((OpenIntObjectHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        if (att_type == DOUBLE_TYPE) {
            double result = NetworkData.getNodeAttributeDoubleValue(node_index, (String)NetworkData.getNodeAttIDToAttNameMap().get(att_id));
            if (result == Double.NaN) {
                return new Double(Double.NaN);
            }
            return new Double(result);
        }
        if (att_type == STRING_TYPE) {
            return ((IntStringHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        return null;
    }

    public static Object getNodeAttributeObjectValue(Node node, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return null;
        }
        int node_index = node.getRootGraphIndex();
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == OBJECT_TYPE) {
            return ((OpenIntObjectHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        return null;
    }

    public static String getNodeAttributeStringValue(Node node, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return null;
        }
        int node_index = node.getRootGraphIndex();
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == STRING_TYPE) {
            return ((IntStringHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        return null;
    }

    public static double getNodeAttributeDoubleValue(Node node, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return Double.NaN;
        }
        int node_index = node.getRootGraphIndex();
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == DOUBLE_TYPE) {
            OpenIntObjectHashMap a2v = NetworkData.getNodeAttributeIDToAttributeValuesMap();
            OpenIntDoubleHashMap n2v = (OpenIntDoubleHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id);
            if (n2v == null) {
                System.out.println("n2v is null");
                return Double.NaN;
            }
            if (n2v.containsKey(node_index)) {
                return n2v.get(node_index);
            }
        }
        return Double.NaN;
    }

    public static Object getNodeAttributeObjectValue(int node_index, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return null;
        }
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == OBJECT_TYPE) {
            return ((OpenIntObjectHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        return null;
    }

    public static String getNodeAttributeStringValue(int node_index, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return null;
        }
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == STRING_TYPE) {
            return ((IntStringHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id)).get(node_index);
        }
        return null;
    }

    public static double getNodeAttributeDoubleValue(int node_index, String attribute) {
        int att_id = NetworkData.getNodeAttributeID(attribute);
        if (att_id < 0) {
            return Double.NaN;
        }
        int att_type = NetworkData.getNodeAttIDToAttTypeMap().get(att_id);
        if (att_type == DOUBLE_TYPE) {
            OpenIntObjectHashMap a2v = NetworkData.getNodeAttributeIDToAttributeValuesMap();
            OpenIntDoubleHashMap n2v = (OpenIntDoubleHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_id);
            if (n2v == null) {
                System.out.println("n2v is null");
                return Double.NaN;
            }
            if (n2v.containsKey(node_index)) {
                return n2v.get(node_index);
            }
        }
        return Double.NaN;
    }

    public static String[] getNodeAttributes(int[] node_indices) {
        IntArrayList att_keys = new IntArrayList();
        NetworkData.getNodeAttributeIDToAttributeValuesMap().keys(att_keys);
        HashSet<Object> attributes = new HashSet<Object>();
        for (int k = 0; k < att_keys.size(); ++k) {
            for (int i = 0; i < node_indices.length; ++i) {
                OpenIntDoubleHashMap n2v;
                if (att_keys.get(k) == DOUBLE_TYPE) {
                    n2v = (OpenIntDoubleHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_keys.get(k));
                    if (!n2v.containsKey(node_indices[i])) continue;
                    attributes.add(NetworkData.getNodeAttIDToAttNameMap().get(att_keys.get(k)));
                    i = node_indices.length;
                    continue;
                }
                n2v = (OpenIntObjectHashMap)NetworkData.getNodeAttributeIDToAttributeValuesMap().get(att_keys.get(k));
                if (!n2v.containsKey(node_indices[i])) continue;
                attributes.add(NetworkData.getNodeAttIDToAttNameMap().get(att_keys.get(k)));
                i = node_indices.length;
            }
        }
        return attributes.toArray(new String[0]);
    }

    private static OpenIntObjectHashMap getNodeAttributeIDToAttributeValuesMap() {
        if (nodeAttributeIDToAttributeValuesMap == null) {
            nodeAttributeIDToAttributeValuesMap = new OpenIntObjectHashMap();
        }
        return nodeAttributeIDToAttributeValuesMap;
    }

    private static StringIntHashMap getNodeAttNameToAttIDMap() {
        if (nodeAttNameToAttIDMap == null) {
            nodeAttNameToAttIDMap = new StringIntHashMap();
        }
        return nodeAttNameToAttIDMap;
    }

    private static OpenIntObjectHashMap getNodeAttIDToAttNameMap() {
        if (nodeAttIDToAttNameMap == null) {
            nodeAttIDToAttNameMap = new OpenIntObjectHashMap();
        }
        return nodeAttIDToAttNameMap;
    }

    private static OpenIntIntHashMap getNodeAttIDToAttTypeMap() {
        if (nodeAttIDToAttTypeMap == null) {
            nodeAttIDToAttTypeMap = new OpenIntIntHashMap();
        }
        return nodeAttIDToAttTypeMap;
    }

    private static StringIntHashMap getNodeAliasToIDMap() {
        if (nodeAliasToIDMap == null) {
            nodeAliasToIDMap = new StringIntHashMap();
        }
        return nodeAliasToIDMap;
    }

    static {
        nodeAttributeCount = 1;
    }
}

