/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.InterpolatorFactory;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.parsers.ValueParser;
import java.util.ArrayList;
import java.util.Properties;

public class ContinuousMappingReader {
    private String controllingAttributeName;
    private Interpolator interpolator;
    private ArrayList points;
    private ValueParser parser;

    public ContinuousMappingReader(Properties props, String baseKey, ValueParser parser) {
        this.parser = parser;
        this.points = new ArrayList();
        this.parseProperties(props, baseKey);
    }

    public String getControllingAttributeName() {
        return this.controllingAttributeName;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public ArrayList getPoints() {
        return this.points;
    }

    private void parseProperties(Properties props, String baseKey) {
        String bvNumKey;
        String bvNumString;
        String intKey;
        String intValue;
        String contKey = baseKey + ".controller";
        String contValue = props.getProperty(contKey);
        if (contValue != null) {
            this.controllingAttributeName = contValue;
        }
        if ((intValue = props.getProperty(intKey = baseKey + ".interpolator")) != null) {
            this.interpolator = InterpolatorFactory.newInterpolator(intValue);
        }
        if ((bvNumString = props.getProperty(bvNumKey = baseKey + ".boundaryvalues")) != null) {
            try {
                int numBV = Integer.parseInt(bvNumString);
                this.getBoundaryValues(numBV, baseKey, props);
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    Expected number value for key: " + bvNumString);
            }
        }
    }

    private void getBoundaryValues(int numBV, String baseKey, Properties props) {
        for (int i = 0; i < numBV; ++i) {
            String bvBase = baseKey + ".bv" + Integer.toString(i);
            String dvKey = bvBase + ".domainvalue";
            String dvString = props.getProperty(dvKey);
            if (dvString == null) continue;
            try {
                Double dVal = Double.valueOf(dvString);
                this.getLesserEqualGreater(bvBase, props, dVal);
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing attributeMap properties:");
                System.err.println("    expected number value for key: " + dvKey);
            }
        }
    }

    private void getLesserEqualGreater(String bvBase, Properties props, Double dVal) {
        Object gValue;
        Object eValue;
        Object lValue;
        BoundaryRangeValues bv = new BoundaryRangeValues();
        String lKey = bvBase + ".lesser";
        String lString = props.getProperty(lKey);
        bv.lesserValue = lValue = this.parser.parseStringValue(lString);
        String eKey = bvBase + ".equal";
        String eString = props.getProperty(eKey);
        bv.equalValue = eValue = this.parser.parseStringValue(eString);
        String gKey = bvBase + ".greater";
        String gString = props.getProperty(gKey);
        bv.greaterValue = gValue = this.parser.parseStringValue(gString);
        ContinuousMappingPoint cmp = new ContinuousMappingPoint(dVal, bv);
        this.points.add(cmp);
    }
}

