/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.data.CyAttributesImpl;
import cytoscape.data.readers.CyAttributesReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class CyAttributesReaderTest
extends TestCase {
    public void testRead1() throws IOException {
        String attributeName = "TestNodeAttribute1";
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/galFiltered.nodeAttrs1");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        byte type = cyAttributes.getType(attributeName);
        CyAttributesReaderTest.assertEquals((byte)3, (byte)type);
        Integer value = cyAttributes.getIntegerAttribute("YKR026C", attributeName);
        CyAttributesReaderTest.assertEquals((int)1, (int)value);
        value = cyAttributes.getIntegerAttribute("YMR043W", attributeName);
        CyAttributesReaderTest.assertEquals((int)2, (int)value);
        value = cyAttributes.getIntegerAttribute("YBR043C", attributeName);
        CyAttributesReaderTest.assertEquals((int)3, (int)value);
        value = cyAttributes.getIntegerAttribute("Nerius", attributeName);
        CyAttributesReaderTest.assertTrue((value == null ? 1 : 0) != 0);
    }

    public void testRead2() throws IOException {
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/galFiltered.edgeAttrs2");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        byte type = cyAttributes.getType("TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals((byte)3, (byte)type);
        Integer value = cyAttributes.getIntegerAttribute("YKR026C (pp) YGL122C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals((int)2, (int)value);
        value = cyAttributes.getIntegerAttribute("YDR382W (pp) YFL029C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals((int)3, (int)value);
        value = cyAttributes.getIntegerAttribute("YBL026W (pp) YOR127C", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertEquals((int)3, (int)value);
        value = cyAttributes.getIntegerAttribute("Nerius", "TestEdgeAttribute2");
        CyAttributesReaderTest.assertTrue((value == null ? 1 : 0) != 0);
    }

    public void testRead3() throws IOException {
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/explicitDouble.attribute");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        byte type = cyAttributes.getType("Score");
        CyAttributesReaderTest.assertEquals((byte)2, (byte)type);
        Double value = cyAttributes.getDoubleAttribute("a", "Score");
        CyAttributesReaderTest.assertEquals((double)1.0, (double)value, (double)0.01);
        value = cyAttributes.getDoubleAttribute("c", "Score");
        CyAttributesReaderTest.assertEquals((double)3.7, (double)value, (double)0.01);
    }

    public void testReadSimpleLists() throws IOException {
        String attributeName = "GO_molecular_function_level_4";
        CyAttributesImpl cyAttributes = new CyAttributesImpl();
        File file = new File("testData/implicitStringArray.attribute");
        FileReader reader = new FileReader(file);
        CyAttributesReader.loadAttributes(cyAttributes, reader);
        byte type = cyAttributes.getType(attributeName);
        CyAttributesReaderTest.assertEquals((byte)-2, (byte)type);
        List list = cyAttributes.getListAttribute("AP1G1", attributeName);
        CyAttributesReaderTest.assertEquals((int)3, (int)list.size());
        String value = (String)list.get(0);
        CyAttributesReaderTest.assertEquals((String)"intracellular", (String)value);
        value = (String)list.get(1);
        CyAttributesReaderTest.assertEquals((String)"clathrin adaptor", (String)value);
        value = (String)list.get(2);
        CyAttributesReaderTest.assertEquals((String)"intracellular transporter", (String)value);
        list = cyAttributes.getListAttribute("CDH3", attributeName);
        CyAttributesReaderTest.assertEquals((int)1, (int)list.size());
        value = (String)list.get(0);
        CyAttributesReaderTest.assertEquals((String)"cell adhesion molecule", (String)value);
    }

    public static void main(String[] args) {
        TestRunner.run(CyAttributesReaderTest.class);
    }
}

