/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.LabelPosition;
import cytoscape.visual.ui.LabelPlacerGraphic;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LabelPlacerControl
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private LabelPosition lp;
    private JComboBox justifyCombo;
    private JTextField xoffsetBox;
    private JTextField yoffsetBox;
    private JComboBox nodeAnchors;
    private JComboBox labelAnchors;
    private LabelPlacerGraphic labelPlacer;
    private boolean ignoreEvents;

    LabelPlacerControl(LabelPosition pos) {
        this.lp = pos == null ? new LabelPosition(127, 127, 64, 0.0, 0.0) : pos;
        this.ignoreEvents = false;
        this.setLayout(new BoxLayout(this, 1));
        JPanel anchorNames = new JPanel();
        anchorNames.setLayout(new GridLayout(2, 2));
        String[] points = LabelPosition.getAnchorNames();
        JLabel nodeAnchorLabel = new JLabel("Node Anchor Points ");
        this.nodeAnchors = new JComboBox<String>(points);
        this.nodeAnchors.addActionListener(this);
        anchorNames.add(nodeAnchorLabel);
        anchorNames.add(this.nodeAnchors);
        JLabel labelAnchorLabel = new JLabel("Label Anchor Points");
        this.labelAnchors = new JComboBox<String>(points);
        this.labelAnchors.addActionListener(this);
        anchorNames.add(labelAnchorLabel);
        anchorNames.add(this.labelAnchors);
        this.add(anchorNames);
        JPanel justifyPanel = new JPanel();
        justifyPanel.setLayout(new GridLayout(1, 2));
        JLabel justifyLabel = new JLabel("Label Justification");
        String[] justifyTypes = LabelPosition.getJustifyNames();
        this.justifyCombo = new JComboBox<String>(justifyTypes);
        this.justifyCombo.addActionListener(this);
        justifyPanel.add(justifyLabel);
        justifyPanel.add(this.justifyCombo);
        this.add(justifyPanel);
        JPanel offsetPanel = new JPanel();
        offsetPanel.setLayout(new GridLayout(2, 2));
        JLabel xoffsetLabel = new JLabel("X Offset Value (can be negative)");
        this.xoffsetBox = new JTextField("0", 8);
        this.xoffsetBox.addActionListener(this);
        offsetPanel.add(xoffsetLabel);
        offsetPanel.add(this.xoffsetBox);
        JLabel yoffsetLabel = new JLabel("Y Offset Value (can be negative)");
        this.yoffsetBox = new JTextField("0", 8);
        this.yoffsetBox.addActionListener(this);
        offsetPanel.add(yoffsetLabel);
        offsetPanel.add(this.yoffsetBox);
        this.add(offsetPanel);
        this.applyPosition();
    }

    private void applyPosition() {
        this.ignoreEvents = true;
        int nodeAnchor = this.lp.getTargetAnchor();
        int labelAnchor = this.lp.getLabelAnchor();
        if (nodeAnchor == 127) {
            this.nodeAnchors.setSelectedIndex(-1);
        } else {
            this.nodeAnchors.setSelectedItem(LabelPosition.convert(nodeAnchor));
        }
        if (labelAnchor == 127) {
            this.labelAnchors.setSelectedIndex(-1);
        } else {
            this.labelAnchors.setSelectedItem(LabelPosition.convert(labelAnchor));
        }
        this.justifyCombo.setSelectedItem(LabelPosition.convert(this.lp.getJustify()));
        this.xoffsetBox.setText(new Integer((int)this.lp.getOffsetX()).toString());
        this.yoffsetBox.setText(new Integer((int)this.lp.getOffsetY()).toString());
        this.ignoreEvents = false;
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        Object source = e.getSource();
        boolean changed = false;
        if (source == this.nodeAnchors) {
            this.lp.setTargetAnchor(LabelPosition.convert((String)this.nodeAnchors.getSelectedItem()));
            changed = true;
        }
        if (source == this.labelAnchors) {
            this.lp.setLabelAnchor(LabelPosition.convert((String)this.labelAnchors.getSelectedItem()));
            changed = true;
        }
        if (source == this.justifyCombo) {
            this.lp.setJustify(LabelPosition.convert((String)this.justifyCombo.getSelectedItem()));
            changed = true;
        }
        if (this.getOffset(this.xoffsetBox) != this.lp.getOffsetX() || this.getOffset(this.yoffsetBox) != this.lp.getOffsetY()) {
            this.lp.setOffsetX(this.getOffset(this.xoffsetBox));
            this.lp.setOffsetY(this.getOffset(this.yoffsetBox));
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.firePropertyChange("LABEL_POSITION_CHANGED", null, this.lp);
    }

    private double getOffset(JTextField jtf) {
        try {
            double d = Double.parseDouble(jtf.getText());
            return d;
        }
        catch (Exception ex) {
            System.err.println("not a number!");
            jtf.setText("0");
            return 0.0;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("LABEL_POSITION_CHANGED")) {
            this.lp = (LabelPosition)e.getNewValue();
            this.applyPosition();
        }
    }
}

