/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import com.jgoodies.plaf.FontSizeHints;
import com.jgoodies.plaf.LookUtils;
import com.jgoodies.plaf.Options;
import com.jgoodies.plaf.plastic.Plastic3DLookAndFeel;
import com.jgoodies.plaf.plastic.PlasticTheme;
import com.jgoodies.plaf.plastic.theme.ExperienceBlue;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeVersion;
import cytoscape.init.CyInitParams;
import cytoscape.util.FileUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CyMain
implements CyInitParams {
    protected String[] args;
    protected Properties props = null;
    protected String[] graphFiles = null;
    protected String[] plugins = null;
    protected Properties vizmapProps = null;
    protected String sessionFile = null;
    protected String[] nodeAttrFiles = null;
    protected String[] edgeAttrFiles = null;
    protected String[] expressionFiles = null;
    protected int mode;
    protected org.apache.commons.cli.Options options;

    public static void main(String[] args) throws Exception {
        CyMain app = new CyMain(args);
    }

    public CyMain(String[] args) throws Exception {
        this.args = args;
        this.mode = 0;
        this.options = new org.apache.commons.cli.Options();
        this.parseCommandLine(args);
        CytoscapeInit initializer = new CytoscapeInit();
        if (!initializer.init(this)) {
            this.printHelp();
            Cytoscape.exit(1);
        }
    }

    protected void parseCommandLine(String[] args) {
        this.options.addOption("h", "help", false, "Print this message.");
        this.options.addOption("v", "version", false, "Print the version number.");
        OptionBuilder.withLongOpt((String)"session");
        OptionBuilder.withDescription((String)"Load a cytoscape session (.cys) file.");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"network");
        OptionBuilder.withDescription((String)"Load a network file (any format).");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"N"));
        OptionBuilder.withLongOpt((String)"edge-attrs");
        OptionBuilder.withDescription((String)"Load an edge attributes file (edge attribute format).");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"node-attrs");
        OptionBuilder.withDescription((String)"Load a node attributes file (node attribute format).");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"matrix");
        OptionBuilder.withDescription((String)"Load a node attribute matrix file (table).");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"plugin");
        OptionBuilder.withDescription((String)"Load a plugin jar file, directory of jar files, plugin class name, or plugin jar URL.");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"props");
        OptionBuilder.withDescription((String)"Load cytoscape properties file (Java properties format) or individual property: -P name=value.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"vizmap");
        OptionBuilder.withDescription((String)"Load vizmap properties file (Java properties format).");
        OptionBuilder.withValueSeparator((char)' ');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"V"));
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println("Parsing command line failed: " + e.getMessage());
            this.printHelp();
            System.exit(1);
        }
        if (line.hasOption("h")) {
            this.printHelp();
            System.exit(0);
        }
        if (line.hasOption("v")) {
            CytoscapeVersion version = new CytoscapeVersion();
            System.out.println(version.getVersion());
            System.exit(0);
        }
        if (line.hasOption("H")) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.setupLookAndFeel();
        }
        this.props = line.hasOption("P") ? this.createProperties(line.getOptionValues("P")) : this.createProperties(new String[0]);
        if (line.hasOption("N")) {
            this.graphFiles = line.getOptionValues("N");
        }
        if (line.hasOption("p")) {
            this.plugins = line.getOptionValues("p");
        }
        this.vizmapProps = line.hasOption("V") ? this.createProperties(line.getOptionValues("V")) : this.createProperties(new String[0]);
        if (line.hasOption("s")) {
            this.sessionFile = line.getOptionValue("s");
        }
        if (line.hasOption("n")) {
            this.nodeAttrFiles = line.getOptionValues("n");
        }
        if (line.hasOption("e")) {
            this.edgeAttrFiles = line.getOptionValues("e");
        }
        if (line.hasOption("m")) {
            this.expressionFiles = line.getOptionValues("m");
        }
    }

    protected void setupLookAndFeel() {
        UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setGlobalFontSizeHints((FontSizeHints)FontSizeHints.MIXED);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        try {
            if (LookUtils.isWindowsXP()) {
                UIManager.setLookAndFeel(Options.getSystemLookAndFeelClassName());
            } else if (!System.getProperty("os.name").startsWith("Mac")) {
                Plastic3DLookAndFeel laf = new Plastic3DLookAndFeel();
                Plastic3DLookAndFeel.setTabStyle((String)"metal");
                Plastic3DLookAndFeel.setHighContrastFocusColorsEnabled((boolean)true);
                Plastic3DLookAndFeel.setMyCurrentTheme((PlasticTheme)new ExperienceBlue());
                UIManager.setLookAndFeel((LookAndFeel)laf);
            }
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -Xmx512M -jar cytoscape.jar [OPTIONS]", this.options);
    }

    public Properties getProps() {
        return this.props;
    }

    public Properties getVizProps() {
        return this.vizmapProps;
    }

    private Properties createProperties(String[] potentialProps) {
        Properties props = new Properties();
        Properties argProps = new Properties();
        Matcher propPattern = Pattern.compile("^((\\w+\\.*)+)\\=(.+)$").matcher("");
        for (int i = 0; i < potentialProps.length; ++i) {
            propPattern.reset(potentialProps[i]);
            if (propPattern.matches()) {
                argProps.setProperty(propPattern.group(1), propPattern.group(3));
                continue;
            }
            try {
                InputStream in = FileUtil.getInputStream(potentialProps[i]);
                if (in != null) {
                    props.load(in);
                    continue;
                }
                System.out.println("Couldn't load property: " + potentialProps[i]);
                continue;
            }
            catch (IOException e) {
                System.out.println("Couldn't load property: " + potentialProps[i]);
                e.printStackTrace();
            }
        }
        props.putAll((Map<?, ?>)argProps);
        return props;
    }

    public List getGraphFiles() {
        return this.createList(this.graphFiles);
    }

    public List getEdgeAttributeFiles() {
        return this.createList(this.edgeAttrFiles);
    }

    public List getNodeAttributeFiles() {
        return this.createList(this.nodeAttrFiles);
    }

    public List getExpressionFiles() {
        return this.createList(this.expressionFiles);
    }

    public List getPlugins() {
        return this.createList(this.plugins);
    }

    public String getSessionFile() {
        return this.sessionFile;
    }

    public int getMode() {
        return this.mode;
    }

    public String[] getArgs() {
        return this.args;
    }

    private List createList(String[] vals) {
        if (vals == null) {
            return new ArrayList();
        }
        ArrayList<String> a = new ArrayList<String>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            a.add(i, vals[i]);
        }
        return a;
    }
}

