/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers;

import cytoscape.Cytoscape;
import cytoscape.data.ontology.DBCrossReferences;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.ontology.OntologyFactory;
import cytoscape.data.synonyms.AliasType;
import cytoscape.data.synonyms.Aliases;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyServer
implements PropertyChangeListener {
    private HashMap<String, Ontology> ontologies;
    private Aliases nodeAliases;
    private Aliases edgeAliases;
    private Aliases networkAliases;
    private OntologyFactory factory;
    private Map<String, URL> ontologySources;
    private DBCrossReferences xref;

    public OntologyServer() throws IOException, JAXBException {
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
        this.factory = new OntologyFactory();
        this.ontologies = new HashMap();
        this.ontologySources = new HashMap<String, URL>();
        this.xref = new DBCrossReferences();
        this.xref.load();
        this.nodeAliases = new Aliases(AliasType.NODE);
        this.edgeAliases = new Aliases(AliasType.EDGE);
        this.networkAliases = new Aliases(AliasType.NETWORK);
    }

    public DBCrossReferences getCrossReferences() {
        return this.xref;
    }

    public HashMap<String, Ontology> getOntologies() {
        return this.ontologies;
    }

    public void addOntology(Ontology onto) {
        this.ontologies.put(onto.getName(), onto);
    }

    public void addOntology(URL dataSource, OntologyType type, String ontologyName, String description) throws IOException, URISyntaxException {
        Ontology onto;
        switch (type) {
            case BASIC: {
                onto = this.factory.createBasicOntology(dataSource, ontologyName, description);
                break;
            }
            case GO: {
                onto = this.factory.createGeneOntology(dataSource, ontologyName, description);
                break;
            }
            default: {
                onto = null;
            }
        }
        this.ontologies.put(onto.getName(), onto);
        this.ontologySources.put(onto.getName(), dataSource);
    }

    public int ontologyCount() {
        return this.ontologies.size();
    }

    public void setOntology(Ontology onto) {
        this.ontologies.put(onto.getName(), onto);
    }

    public Set<String> getOntologyNames() {
        return this.ontologies.keySet();
    }

    public Map<String, URL> getOntologySources() {
        return this.ontologySources;
    }

    public void setOntologySources(Map<String, URL> newMap) {
        this.ontologySources = newMap;
    }

    public Aliases getNodeAliases() {
        return this.nodeAliases;
    }

    public Aliases getEdgeAliases() {
        return this.edgeAliases;
    }

    public Aliases getNetworkAliases() {
        return this.networkAliases;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            this.ontologies.remove(Cytoscape.getNetwork((String)e.getNewValue()).getTitle());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OntologyType {
        BASIC,
        GO;

    }
}

