/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.util.GraphSetUtils;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class GraphSetUtilsTest
extends TestCase {
    protected List networklist;
    protected int a;
    protected int b;
    protected int c;
    protected int d;
    protected int e;
    protected int ab;
    protected int bc;
    protected int ac;
    protected int bd;
    protected int be;
    protected int cd;
    protected CyNetwork net1;
    protected CyNetwork net2;

    public void setUp() throws Exception {
        this.networklist = new ArrayList();
        CytoscapeRootGraph root = Cytoscape.getRootGraph();
        this.a = root.createNode();
        this.b = root.createNode();
        this.c = root.createNode();
        this.d = root.createNode();
        this.e = root.createNode();
        int[] nodes1 = new int[]{this.a, this.b, this.c, this.d};
        int[] nodes2 = new int[]{this.b, this.c, this.d, this.e};
        this.ab = root.createEdge(this.a, this.b, true);
        this.bc = root.createEdge(this.b, this.c, true);
        this.ac = root.createEdge(this.a, this.c, true);
        this.bd = root.createEdge(this.b, this.d, true);
        this.be = root.createEdge(this.b, this.e, true);
        this.cd = root.createEdge(this.c, this.d, true);
        int[] edges1 = new int[]{this.ab, this.bc, this.ac, this.bd};
        int[] edges2 = new int[]{this.bd, this.bc, this.be};
        this.net1 = Cytoscape.createNetwork(nodes1, edges1, "graph1");
        this.net2 = Cytoscape.createNetwork(nodes2, edges2, "graph2");
        this.networklist.add(0, this.net1);
        this.networklist.add(1, this.net2);
    }

    public void testNetwork() {
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsNode(this.net1.getNode(this.a)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsNode(this.net1.getNode(this.b)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsNode(this.net1.getNode(this.c)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsNode(this.net1.getNode(this.d)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsNode(this.net2.getNode(this.b)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsNode(this.net2.getNode(this.c)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsNode(this.net2.getNode(this.d)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsNode(this.net2.getNode(this.e)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsEdge(this.net1.getEdge(this.ab)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsEdge(this.net1.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsEdge(this.net1.getEdge(this.ac)));
        GraphSetUtilsTest.assertTrue((boolean)this.net1.containsEdge(this.net1.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsEdge(this.net2.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsEdge(this.net2.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue((boolean)this.net2.containsEdge(this.net2.getEdge(this.be)));
    }

    public void tearDown() throws Exception {
    }

    public void testIntersection() {
        CyNetwork n = GraphSetUtils.createIntersectionGraph(this.networklist, true, "intersect");
        GraphSetUtilsTest.assertTrue((boolean)n.containsEdge(n.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue((boolean)n.containsEdge(n.getEdge(this.bd)));
        GraphSetUtilsTest.assertNull((Object)n.getEdge(this.ab));
        GraphSetUtilsTest.assertNull((Object)n.getEdge(this.be));
        GraphSetUtilsTest.assertTrue((boolean)n.containsNode(n.getNode(this.b)));
        GraphSetUtilsTest.assertTrue((boolean)n.containsNode(n.getNode(this.c)));
        GraphSetUtilsTest.assertTrue((boolean)n.containsNode(n.getNode(this.d)));
        GraphSetUtilsTest.assertNull((Object)n.getNode(this.a));
        GraphSetUtilsTest.assertNull((Object)n.getNode(this.e));
    }

    public void testDifference() {
        CyNetwork x = GraphSetUtils.createDifferenceGraph(this.networklist, true, "difference");
        GraphSetUtilsTest.assertTrue((boolean)x.containsNode(x.getNode(this.a)));
        GraphSetUtilsTest.assertTrue((boolean)x.containsNode(x.getNode(this.b)));
        GraphSetUtilsTest.assertTrue((boolean)x.containsNode(x.getNode(this.c)));
        GraphSetUtilsTest.assertNull((Object)x.getNode(this.d));
        GraphSetUtilsTest.assertNull((Object)x.getNode(this.e));
        GraphSetUtilsTest.assertTrue((boolean)x.containsEdge(x.getEdge(this.ab)));
        GraphSetUtilsTest.assertNull((Object)x.getEdge(this.bc));
        GraphSetUtilsTest.assertTrue((boolean)x.containsEdge(x.getEdge(this.ac)));
        GraphSetUtilsTest.assertNull((Object)x.getEdge(this.be));
        GraphSetUtilsTest.assertNull((Object)x.getEdge(this.bd));
    }

    public void testUnion() {
        CyNetwork y = GraphSetUtils.createUnionGraph(this.networklist, true, "union");
        GraphSetUtilsTest.assertTrue((boolean)y.containsEdge(y.getEdge(this.ab)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsEdge(y.getEdge(this.bc)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsEdge(y.getEdge(this.ac)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsEdge(y.getEdge(this.bd)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsNode(y.getNode(this.a)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsNode(y.getNode(this.b)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsNode(y.getNode(this.c)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsNode(y.getNode(this.d)));
        GraphSetUtilsTest.assertTrue((boolean)y.containsNode(y.getNode(this.e)));
    }
}

