/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CytoscapeInit;
import java.io.IOException;
import java.util.Properties;

public abstract class OpenBrowser {
    static String UNIX_PROTOCOL = "file:";
    static String UNIX_PATH = "gnome-moz-remote";
    static String UNIX_FLAG = "-remote openURL";
    static String MAC_PATH = "open";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

    public static void openURL(String url) {
        Properties prop = CytoscapeInit.getProperties();
        String defBrowser = prop.getProperty("defaultWebBrowser");
        String osName = System.getProperty("os.name");
        try {
            String cmd;
            if (osName.startsWith("Windows")) {
                cmd = "rundll32 url.dll,FileProtocolHandler " + url;
            } else if (osName.startsWith("Mac")) {
                cmd = MAC_PATH + " " + url;
            } else if (defBrowser != null) {
                cmd = defBrowser + " " + url;
                System.out.println("Opening URL by command \"" + defBrowser + "\"");
            } else {
                cmd = UNIX_PATH + " " + url;
                System.out.println("Opening URL by command \"" + UNIX_PATH + "\"");
            }
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    System.out.println("cmd failed, start new browser");
                    cmd = UNIX_PATH + " " + url;
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException ex) {}
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

