/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeVersion;
import cytoscape.util.CytoscapeToolBar;
import cytoscape.util.UndoManager;
import cytoscape.view.CyHelpBroker;
import cytoscape.view.CyMenus;
import cytoscape.view.CyNetworkView;
import cytoscape.view.GraphViewController;
import cytoscape.view.NetworkPanel;
import cytoscape.view.NetworkViewManager;
import cytoscape.view.cytopanels.BiModalJSplitPane;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelImp;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.ui.VizMapBypassNetworkListener;
import cytoscape.visual.ui.VizMapUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.undo.UndoableEdit;

public class CytoscapeDesktop
extends JFrame
implements PropertyChangeListener {
    protected long lastPluginRegistryUpdate;
    protected int returnVal;
    public static final String NETWORK_VIEW_FOCUSED = "NETWORK_VIEW_FOCUSED";
    public static final String NETWORK_VIEW_FOCUS = "NETWORK_VIEW_FOCUS";
    public static final String NETWORK_VIEW_CREATED = "NETWORK_VIEW_CREATED";
    public static final String NETWORK_VIEW_DESTROYED = "NETWORK_VIEW_DESTROYED";
    public static final String VISUAL_STYLE = "VISUAL_STYLE";
    public static final String VIZMAP_ENABLED = "VIZMAP_ENABLED";
    public static UndoManager undo;
    public static final int TABBED_VIEW = 0;
    public static final int INTERNAL_VIEW = 1;
    public static final int EXTERNAL_VIEW = 2;
    protected int VIEW_TYPE;
    protected VisualStyle defaultVisualStyle;
    protected NetworkPanel networkPanel;
    protected CyMenus cyMenus;
    protected NetworkViewManager networkViewManager;
    protected CyHelpBroker cyHelpBroker;
    protected SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    protected GraphViewController graphViewController;
    protected VisualMappingManager vizMapper;
    protected VizMapUI vizMapUI;
    protected String currentNetworkID;
    protected String currentNetworkViewID;
    protected CytoPanelImp cytoPanelWest;
    protected CytoPanelImp cytoPanelEast;
    protected CytoPanelImp cytoPanelSouth;
    protected CytoPanelImp cytoPanelSouthWest = new CytoPanelImp(6, 1, CytoPanelState.HIDE);
    protected JLabel statusBar;
    protected HashMap vsAssociationMap;
    protected JPanel main_panel;
    protected JComboBox currentStyleBox = null;
    protected int styleBoxIndex = -1;

    public CytoscapeDesktop() {
        this(0);
    }

    public CytoscapeDesktop(int view_type) {
        super("Cytoscape Desktop (New Session)");
        this.VIEW_TYPE = view_type;
        this.initialize();
    }

    protected void initialize() {
        this.VIEW_TYPE = 1;
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/c16.png")));
        this.cyHelpBroker = new CyHelpBroker();
        this.main_panel = new JPanel();
        this.main_panel.setLayout(new BorderLayout());
        this.networkPanel = new NetworkPanel(this);
        this.cyMenus = new CyMenus();
        this.networkViewManager = new NetworkViewManager(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkViewManager);
        this.networkViewManager.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        this.getSwingPropertyChangeSupport().addPropertyChangeListener(this.networkPanel);
        this.networkPanel.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(new VizMapBypassNetworkListener());
        undo = new UndoManager(this.cyMenus);
        this.cyMenus.initializeMenus();
        this.cyMenus.initializeHelp(this.cyHelpBroker.getHelpBroker());
        BiModalJSplitPane masterPane = this.setupCytoPanels(this.networkPanel, this.networkViewManager);
        if (this.VIEW_TYPE == 0 || this.VIEW_TYPE == 1) {
            this.main_panel.add((Component)masterPane, "Center");
            this.main_panel.add((Component)this.cyMenus.getToolBar(), "North");
            this.initStatusBar(this.main_panel);
            this.setJMenuBar(this.cyMenus.getMenuBar());
        } else if (this.VIEW_TYPE == 2) {
            this.main_panel.add(masterPane);
            this.cyMenus.getToolBar().setOrientation(1);
            this.main_panel.add((Component)this.cyMenus.getToolBar(), "East");
            this.setJMenuBar(this.cyMenus.getMenuBar());
        }
        this.setupVizMapper();
        CytoscapeDesktop thisWindow = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                Cytoscape.exit(CytoscapeDesktop.this.returnVal);
            }

            public void windowClosed() {
            }
        });
        this.setContentPane(this.main_panel);
        this.pack();
        if (this.VIEW_TYPE != 2) {
            this.setSize(800, 700);
        }
        this.setVisible(true);
        this.toFront();
    }

    private void initStatusBar(JPanel panel) {
        this.statusBar = new JLabel();
        this.statusBar.setBorder(new EmptyBorder(0, 7, 5, 7));
        this.statusBar.setForeground(new Color(75, 75, 75));
        panel.add((Component)this.statusBar, "South");
        this.setStatusBarMsg("Welcome to Cytoscape " + CytoscapeVersion.version + "              Right-click + drag  to  ZOOM             Middle-click + drag  to  PAN");
    }

    public void setStatusBarMsg(String msg) {
        this.statusBar.setText(msg);
    }

    public void clearStatusBar() {
        this.statusBar.setText("   ");
    }

    public NetworkPanel getNetworkPanel() {
        return this.networkPanel;
    }

    public HelpBroker getHelpBroker() {
        return this.cyHelpBroker.getHelpBroker();
    }

    public HelpSet getHelpSet() {
        return this.cyHelpBroker.getHelpSet();
    }

    public void addEdit(UndoableEdit edit) {
        undo.addEdit(edit);
    }

    public int getViewType() {
        return this.VIEW_TYPE;
    }

    public CyMenus getCyMenus() {
        return this.cyMenus;
    }

    public void setNewNetwork(CyNetwork newNetwork) {
    }

    public VisualMappingManager getVizMapManager() {
        return this.vizMapper;
    }

    public VizMapUI getVizMapUI() {
        return this.vizMapUI;
    }

    public void setupVizMapper() {
        this.vizMapper = Cytoscape.getVisualMappingManager();
        this.vizMapUI = new VizMapUI(this.vizMapper, this);
        this.vizMapUI.setName("vizMapUI");
        this.vizMapper.addChangeListener(this.vizMapUI.getStyleSelector());
        JComboBox styleBox = this.vizMapUI.getStyleSelector().getToolbarComboBox();
        Dimension newSize = new Dimension(150, (int)styleBox.getPreferredSize().getHeight());
        styleBox.setMaximumSize(newSize);
        styleBox.setPreferredSize(newSize);
        if (this.VIEW_TYPE == 2) {
            if (this.currentStyleBox != null) {
                this.main_panel.remove(this.currentStyleBox);
            }
            this.main_panel.add((Component)styleBox, "South");
            this.currentStyleBox = styleBox;
        } else {
            CytoscapeToolBar toolBar = this.cyMenus.getToolBar();
            if (this.styleBoxIndex == -1) {
                toolBar.add(styleBox);
                this.styleBoxIndex = toolBar.getComponentCount() - 1;
                toolBar.addSeparator();
            } else {
                toolBar.remove(this.styleBoxIndex);
                toolBar.add((Component)styleBox, this.styleBoxIndex);
            }
        }
    }

    public VisualStyle setVisualStyle(VisualStyle style) {
        VisualStyle old_style = (VisualStyle)this.vizMapUI.getStyleSelector().getToolbarComboBox().getSelectedItem();
        this.vizMapper.setVisualStyle(style);
        this.vizMapUI.getStyleSelector().getToolbarComboBox().setSelectedItem(style);
        return old_style;
    }

    protected void updateFocus(String network_id) {
        VisualStyle old_style = (VisualStyle)this.vizMapUI.getStyleSelector().getToolbarComboBox().getSelectedItem();
        CyNetworkView old_view = Cytoscape.getCurrentNetworkView();
        if (old_view != null) {
            old_view.putClientData(VISUAL_STYLE, old_style);
            old_view.putClientData(VIZMAP_ENABLED, new Boolean(old_view.getVisualMapperEnabled()));
        }
        Cytoscape.setCurrentNetwork(network_id);
        if (Cytoscape.setCurrentNetworkView(network_id)) {
            CyNetworkView new_view = Cytoscape.getCurrentNetworkView();
            VisualStyle new_style = (VisualStyle)new_view.getClientData(VISUAL_STYLE);
            Boolean vizmap_enabled = (Boolean)new_view.getClientData(VIZMAP_ENABLED);
            if (new_style == null) {
                new_style = this.defaultVisualStyle;
            }
            if (vizmap_enabled == null) {
                vizmap_enabled = new Boolean(true);
            }
            this.vizMapper.setNetworkView(new_view);
            if (new_style != null) {
                this.vizMapper.setVisualStyle(new_style);
                this.vizMapUI.getStyleSelector().getToolbarComboBox().setSelectedItem(new_style);
            }
            this.cyMenus.setNodesRequiredItemsEnabled();
            this.cyMenus.setVisualMapperItemsEnabled(vizmap_enabled);
            if (vizmap_enabled.booleanValue()) {
                new_view.redrawGraph(false, false);
            }
        }
    }

    public void setFocus(String network_id) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUSED, null, network_id));
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, NETWORK_VIEW_FOCUS, null, network_id));
    }

    public GraphViewController getGraphViewController() {
        if (this.graphViewController == null) {
            this.graphViewController = new GraphViewController();
        }
        return this.graphViewController;
    }

    public SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return this.pcs;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == NETWORK_VIEW_CREATED) {
            this.getGraphViewController().addGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
            this.networkPanel.focusNetworkNode(((CyNetworkView)e.getNewValue()).getIdentifier());
            this.networkPanel.fireFocus(((CyNetworkView)e.getNewValue()).getIdentifier());
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUSED) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == NETWORK_VIEW_FOCUS) {
            this.updateFocus(e.getNewValue().toString());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_CREATED) {
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.NETWORK_DESTROYED) {
            String message;
            int result;
            this.pcs.firePropertyChange(e);
            if (Cytoscape.getNetworkSet().size() == 0 && Cytoscape.getSessionstate() != 1 && (result = JOptionPane.showConfirmDialog(this, message = "Do you want to create a new session?.\n(All attributes will be lost!)", "Create New Session?", 0, 2, null)) == 0) {
                Cytoscape.createNewSession();
            }
        } else if (e.getPropertyName() == NETWORK_VIEW_DESTROYED) {
            this.getGraphViewController().removeGraphView((CyNetworkView)e.getNewValue());
            this.pcs.firePropertyChange(e);
        } else if (e.getPropertyName() == Cytoscape.CYTOSCAPE_INITIALIZED) {
            this.cyMenus.networkOverviewAction.actionPerformed(new ActionEvent(this.cyMenus.networkOverviewItem, 1001, "Show Network Overview"));
        }
    }

    public CytoPanel getCytoPanel(int compassDirection) {
        switch (compassDirection) {
            case 5: {
                return this.cytoPanelSouth;
            }
            case 3: {
                return this.cytoPanelEast;
            }
            case 7: {
                return this.cytoPanelWest;
            }
            case 6: {
                return this.cytoPanelSouthWest;
            }
        }
        throw new IllegalArgumentException("Illegal Argument:  " + compassDirection + ".  Must be one of:  SwingConstants.{SOUTH,EAST,WEST,SOUTH_WEST}.");
    }

    protected BiModalJSplitPane setupCytoPanels(NetworkPanel networkPanel, NetworkViewManager networkViewManager) {
        BiModalJSplitPane topRightPane = this.createTopRightPane(networkViewManager);
        BiModalJSplitPane rightPane = this.createRightPane(topRightPane);
        BiModalJSplitPane masterPane = this.createMasterPane(networkPanel, rightPane);
        return masterPane;
    }

    protected BiModalJSplitPane createTopRightPane(NetworkViewManager networkViewManager) {
        this.cytoPanelEast = new CytoPanelImp(3, 1, CytoPanelState.HIDE);
        JComponent networkViewComp = null;
        if (this.VIEW_TYPE == 0) {
            networkViewComp = networkViewManager.getTabbedPane();
        } else if (this.VIEW_TYPE == 1) {
            networkViewComp = networkViewManager.getDesktopPane();
        } else if (this.VIEW_TYPE == 2) {
            // empty if block
        }
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 2, networkViewComp, this.cytoPanelEast);
        this.cytoPanelEast.setCytoPanelContainer(splitPane);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createRightPane(BiModalJSplitPane topRightPane) {
        this.cytoPanelSouth = new CytoPanelImp(5, 3, CytoPanelState.HIDE);
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 0, 2, topRightPane, this.cytoPanelSouth);
        this.cytoPanelSouth.setCytoPanelContainer(splitPane);
        splitPane.setResizeWeight(1.0);
        return splitPane;
    }

    protected BiModalJSplitPane createMasterPane(NetworkPanel networkPanel, BiModalJSplitPane rightPane) {
        this.cytoPanelWest = new CytoPanelImp(7, 1, CytoPanelState.DOCK);
        String tab1Name = new String("Network");
        this.cytoPanelWest.add(tab1Name, new ImageIcon(this.getClass().getResource("images/class_hi.gif")), networkPanel, "Cytoscape Network List");
        BiModalJSplitPane splitPane = new BiModalJSplitPane(this, 1, 1, this.cytoPanelWest, rightPane);
        this.cytoPanelWest.setCytoPanelContainer(splitPane);
        return splitPane;
    }

    public NetworkViewManager getNetworkViewManager() {
        return this.networkViewManager;
    }

    public static int parseViewType(String vt) {
        int type = -1;
        if (vt == null || vt.equals("tabbed")) {
            type = 0;
        } else if (vt.equals("internal")) {
            type = 1;
        } else if (vt.equals("external")) {
            type = 2;
        } else {
            System.out.println("Couldn't parse view type: " + vt + " -- using TABBED");
            type = 0;
        }
        return type;
    }
}

