/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.view.BasicGraphViewHandler;
import cytoscape.view.GraphViewHandler;
import giny.model.GraphPerspective;
import giny.model.GraphPerspectiveChangeEvent;
import giny.model.GraphPerspectiveChangeListener;
import giny.view.GraphView;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class GraphViewController
implements GraphPerspectiveChangeListener {
    protected Map graphViewToHandler = new HashMap();
    protected Map gpToGv = new HashMap();
    public static final GraphViewHandler DEFAULT_GRAPH_VIEW_HANDLER = new BasicGraphViewHandler();

    public GraphViewController() {
    }

    public GraphViewController(GraphView[] graph_views) {
        this.setGraphViews(graph_views);
    }

    public GraphViewController(GraphView[] graph_views, Map gv_to_handler) {
        this.setGraphViews(graph_views, gv_to_handler);
    }

    public void setGraphViews(GraphView[] graph_views) {
        this.removeAllGraphViews();
        for (int i = 0; i < graph_views.length; ++i) {
            GraphPerspective graphPerspective = graph_views[i].getGraphPerspective();
            graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            this.gpToGv.put(graphPerspective, graph_views[i]);
            this.graphViewToHandler.put(graph_views[i], DEFAULT_GRAPH_VIEW_HANDLER);
        }
    }

    public void setGraphViews(GraphView[] graph_views, Map gv_to_handler) {
        this.removeAllGraphViews();
        for (int i = 0; i < graph_views.length; ++i) {
            GraphPerspective graphPerspective = graph_views[i].getGraphPerspective();
            graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            this.gpToGv.put(graphPerspective, graph_views[i]);
            GraphViewHandler handler = (GraphViewHandler)gv_to_handler.get(graph_views[i]);
            if (handler == null) {
                this.graphViewToHandler.put(graph_views[i], DEFAULT_GRAPH_VIEW_HANDLER);
                continue;
            }
            this.graphViewToHandler.put(graph_views[i], handler);
        }
    }

    public GraphView[] getGraphViews() {
        Set keySet = this.graphViewToHandler.keySet();
        return keySet.toArray(new GraphView[keySet.size()]);
    }

    public Map getGraphViewHandlersMap() {
        return this.graphViewToHandler;
    }

    public GraphViewHandler getGraphViewHandler(GraphView graph_view) {
        return (GraphViewHandler)this.graphViewToHandler.get(graph_view);
    }

    public GraphViewHandler removeGraphView(GraphView graph_view) {
        if (this.graphViewToHandler.containsKey(graph_view)) {
            GraphPerspective graphPerspective = graph_view.getGraphPerspective();
            graphPerspective.removeGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
            this.gpToGv.remove(graphPerspective);
            GraphViewHandler gvHandler = (GraphViewHandler)this.graphViewToHandler.remove(graph_view);
            return gvHandler;
        }
        return null;
    }

    public boolean addGraphView(GraphView graph_view) {
        if (this.graphViewToHandler.containsKey(graph_view)) {
            return false;
        }
        GraphPerspective graphPerspective = graph_view.getGraphPerspective();
        graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
        this.gpToGv.put(graphPerspective, graph_view);
        this.graphViewToHandler.put(graph_view, DEFAULT_GRAPH_VIEW_HANDLER);
        return true;
    }

    public boolean addGraphView(GraphView graph_view, GraphViewHandler gv_handler) {
        if (this.graphViewToHandler.containsKey(graph_view)) {
            return false;
        }
        GraphPerspective graphPerspective = graph_view.getGraphPerspective();
        graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
        this.gpToGv.put(graphPerspective, graph_view);
        this.graphViewToHandler.put(graph_view, gv_handler);
        return true;
    }

    public boolean setGraphViewHandler(GraphView graph_view, GraphViewHandler gv_handler) {
        if (this.graphViewToHandler.containsKey(graph_view)) {
            this.graphViewToHandler.put(graph_view, gv_handler);
            return true;
        }
        return false;
    }

    public GraphView[] removeAllGraphViews() {
        GraphView[] gViews = this.getGraphViews();
        for (int i = 0; i < gViews.length; ++i) {
            GraphPerspective graphPerspective = gViews[i].getGraphPerspective();
            graphPerspective.removeGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
        }
        this.gpToGv.clear();
        this.graphViewToHandler.clear();
        return gViews;
    }

    public boolean containsGraphView(GraphView graph_view) {
        return this.graphViewToHandler.containsKey(graph_view);
    }

    public void stopListening() {
        GraphView[] graphViews = this.getGraphViews();
        for (int i = 0; i < graphViews.length; ++i) {
            GraphPerspective graphPerspective = graphViews[i].getGraphPerspective();
            graphPerspective.removeGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
        }
    }

    public void stopListening(GraphView graph_view) {
        GraphPerspective graphPerspective = graph_view.getGraphPerspective();
        graphPerspective.removeGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
    }

    public void resumeListening() {
        GraphView[] graphViews = this.getGraphViews();
        for (int i = 0; i < graphViews.length; ++i) {
            GraphPerspective graphPerspective = graphViews[i].getGraphPerspective();
            GraphViewHandler handler = (GraphViewHandler)this.graphViewToHandler.get(graphViews[i]);
            handler.updateGraphView(graphViews[i]);
            graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
        }
    }

    public void resumeListening(GraphView graph_view) {
        GraphViewHandler handler = (GraphViewHandler)this.graphViewToHandler.get(graph_view);
        handler.updateGraphView(graph_view);
        GraphPerspective graphPerspective = graph_view.getGraphPerspective();
        graphPerspective.addGraphPerspectiveChangeListener((GraphPerspectiveChangeListener)this);
    }

    public void graphPerspectiveChanged(GraphPerspectiveChangeEvent event) {
        Object source = event.getSource();
        if (!(source instanceof GraphPerspective)) {
            return;
        }
        GraphPerspective changedGraphPers = (GraphPerspective)source;
        GraphView graphView = (GraphView)this.gpToGv.get(changedGraphPers);
        if (graphView == null) {
            System.err.println("Oops! the GraphPerspective " + changedGraphPers + " does not have a corresponding GraphView in the GraphViewController!!!");
            return;
        }
        GraphViewHandler gvHandler = (GraphViewHandler)this.graphViewToHandler.get(graphView);
        if (gvHandler == null) {
            System.err.println("Oops! the GraphView " + graphView + " has no GraphViewHandler in the GraphViewController!!!");
            return;
        }
        gvHandler.handleGraphPerspectiveEvent(event, graphView);
    }
}

