/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain;

import java.util.ArrayList;
import java.util.HashMap;
import org.baderlab.brain.AlignmentMatrix;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.ProteinProfile;

public class ProfileAlignment
extends AvgLinkHierarchicalClustering {
    private ArrayList profileList = null;
    private ArrayList alignedProfileList = null;
    private ArrayList alignmentPairs = null;
    private ArrayList alignmentPairsCopy = null;
    private AlignmentMatrix alignmentMatrix = null;
    private HashMap alignmentTarget = null;
    private ArrayList alignmentOffset = null;
    boolean debug = false;
    private ArrayList alignmentResult = null;
    private HashMap alignmentResultIndex = null;
    private HashMap profileAlignmentPositionMap = null;

    public ProfileAlignment(ArrayList profileList, AlignmentMatrix alignmentMatrix) {
        super(alignmentMatrix);
        this.profileList = profileList;
        this.alignmentMatrix = alignmentMatrix;
        this.alignedProfileList = new ArrayList();
        this.alignmentPairs = new ArrayList();
        this.alignmentPairsCopy = new ArrayList();
        this.alignmentTarget = new HashMap();
        this.alignmentOffset = new ArrayList();
        this.alignmentResult = new ArrayList();
        this.alignmentResultIndex = new HashMap();
        this.profileAlignmentPositionMap = new HashMap();
    }

    @Override
    public void run() {
        this.buildClosestPairList();
        this.normalizePositionMapToZero();
        Pair pair = (Pair)this.alignmentPairs.get(0);
        this.alignmentPairsCopy.remove(0);
        this.align(pair.i, pair.j);
    }

    private void addPairToPositionMap(Pair pair) {
        ProteinProfile profile1 = (ProteinProfile)this.profileList.get(pair.i);
        ProteinProfile profile2 = (ProteinProfile)this.profileList.get(pair.j);
        if (this.debug) {
            System.out.println("-------------------------------------------------------------------------------------------------------------------------");
            System.out.println("Placing Pair: " + profile1.getName() + ", " + profile2.getName());
        }
        if (this.profileAlignmentPositionMap.containsKey(profile1.getName()) && this.profileAlignmentPositionMap.containsKey(profile2.getName())) {
            if (this.debug) {
                System.out.println("Both profiles have already been positioned. Continuing.");
            }
            return;
        }
        if (!this.profileAlignmentPositionMap.containsKey(profile1.getName()) && !this.profileAlignmentPositionMap.containsKey(profile2.getName())) {
            int offset = this.alignmentMatrix.getAlignmentValue(pair.i, pair.j);
            this.profileAlignmentPositionMap.put(profile1.getName(), 0);
            this.profileAlignmentPositionMap.put(profile2.getName(), offset);
            if (this.debug) {
                System.out.println("Neither profile has been positioned.");
                System.out.println("Inserting " + profile1.getName() + " at position 0");
                System.out.println("Inserting " + profile2.getName() + " at position " + offset);
            }
            return;
        }
        if (this.profileAlignmentPositionMap.containsKey(profile1.getName())) {
            int position = (Integer)this.profileAlignmentPositionMap.get(profile1.getName());
            int offset = this.alignmentMatrix.getAlignmentValue(pair.i, pair.j);
            this.profileAlignmentPositionMap.put(profile2.getName(), position + offset);
            if (this.debug) {
                System.out.println(String.valueOf(profile1.getName()) + " is already positioned at positiion " + position);
                System.out.println(String.valueOf(profile2.getName()) + " is not positioned.");
                System.out.println(String.valueOf(profile2.getName()) + " is offset by " + offset + " relative to " + profile1.getName());
                System.out.println("Inserting " + profile2.getName() + "at position " + (position + offset));
            }
            return;
        }
        if (this.profileAlignmentPositionMap.containsKey(profile2.getName())) {
            int position = (Integer)this.profileAlignmentPositionMap.get(profile2.getName());
            int offset = this.alignmentMatrix.getAlignmentValue(pair.j, pair.i);
            this.profileAlignmentPositionMap.put(profile1.getName(), position + offset);
            if (this.debug) {
                System.out.println(String.valueOf(profile2.getName()) + " is already positioned at positiion " + position);
                System.out.println(String.valueOf(profile1.getName()) + " is not positioned.");
                System.out.println(String.valueOf(profile1.getName()) + " is offset by " + offset + " relative to " + profile2.getName());
                System.out.println("Inserting " + profile1.getName() + "at position " + (position + offset));
            }
            return;
        }
    }

    private void normalizePositionMapToZero() {
        String name;
        if (this.debug) {
            System.out.println("Adjusting absolute positions...");
        }
        int minPosition = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.alignedProfileList.size()) {
            name = ((ProteinProfile)this.alignedProfileList.get(i)).getName();
            minPosition = Math.min(minPosition, (Integer)this.profileAlignmentPositionMap.get(name));
            ++i;
        }
        if (this.debug) {
            System.out.println("Minimum Position: " + minPosition);
        }
        i = 0;
        while (i < this.alignedProfileList.size()) {
            name = ((ProteinProfile)this.alignedProfileList.get(i)).getName();
            int position = (Integer)this.profileAlignmentPositionMap.get(name);
            this.profileAlignmentPositionMap.put(name, position - minPosition);
            ++i;
        }
        if (this.debug) {
            minPosition = Integer.MAX_VALUE;
            i = 0;
            while (i < this.alignedProfileList.size()) {
                name = ((ProteinProfile)this.alignedProfileList.get(i)).getName();
                minPosition = Math.min(minPosition, (Integer)this.profileAlignmentPositionMap.get(name));
                ++i;
            }
            System.out.println("New Minimum Position: " + minPosition + "\n");
        }
    }

    private void displayAbsoluteAlignmentPositions() {
        int i = 0;
        while (i < this.alignedProfileList.size()) {
            String name = ((ProteinProfile)this.alignedProfileList.get(i)).getName();
            System.out.println(String.valueOf(name) + "\t" + this.profileAlignmentPositionMap.get(name));
            ++i;
        }
    }

    public int getAbsoluteAlignmentPosition(ProteinProfile profile) {
        return (Integer)this.profileAlignmentPositionMap.get(profile.getName());
    }

    private boolean isUsedPair(Pair pair) {
        return this.alignmentPairs.contains(pair);
    }

    private void buildClosestPairList() {
        if (this.alignedProfileList.size() == this.profileList.size()) {
            return;
        }
        Pair closestPair = this.findClosestPair();
        if (closestPair == null) {
            throw new IllegalStateException(String.valueOf(this.getClass().getName()) + ": Closest pair not found in distance matrix");
        }
        this.addPair(closestPair);
        this.buildClosestPairList();
    }

    private Pair findClosestPair() {
        Pair result = new Pair();
        Pair thisPair = new Pair();
        double distance = Double.MAX_VALUE;
        boolean found = false;
        int i = 0;
        while (i < this.alignmentMatrix.getMatrixDimension()) {
            int j = 0;
            while (j < i) {
                thisPair.i = i;
                thisPair.j = j;
                if (!this.isUsedPair(thisPair) && this.alignmentMatrix.getValue(i, j) < distance) {
                    distance = this.alignmentMatrix.getValue(i, j);
                    result.i = i;
                    result.j = j;
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        if (found) {
            return result;
        }
        return null;
    }

    private void addPair(Pair pair) {
        if (pair == null) {
            System.out.println(String.valueOf(this.getClass().getName()) + ": Null argument provided.");
            throw new IllegalArgumentException();
        }
        this.addPairToAlignedProfileList(pair);
        this.addPairToPositionMap(pair);
        this.alignmentPairs.add(pair);
        this.alignmentPairsCopy.add(pair);
        this.alignmentOffset.add(this.alignmentMatrix.getAlignmentValue(pair.i, pair.j));
        this.alignmentTarget.put(pair.i, pair.j);
    }

    private void addPairToAlignedProfileList(Pair pair) {
        ProteinProfile profile = (ProteinProfile)this.profileList.get(pair.i);
        if (!this.alignedProfileList.contains(profile)) {
            this.alignedProfileList.add(profile);
        }
        if (!this.alignedProfileList.contains(profile = (ProteinProfile)this.profileList.get(pair.j))) {
            this.alignedProfileList.add(profile);
        }
    }

    private void align(int a, int b) {
        if (b == -1) {
            return;
        }
        this.addPairToAlignment(a, b);
        this.align(a, this.relatedProfile(a));
        this.align(b, this.relatedProfile(b));
    }

    private int relatedProfile(int index) {
        Pair pair = new Pair();
        boolean found = false;
        int i = 0;
        while (i < this.alignmentPairsCopy.size()) {
            pair = (Pair)this.alignmentPairsCopy.get(i);
            if (pair.i == index || pair.j == index) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            int iFound = pair.i;
            int jFound = pair.j;
            this.alignmentPairsCopy.remove(i);
            if (pair.i == index) {
                return pair.j;
            }
            if (pair.j == index) {
                return pair.i;
            }
        }
        return -1;
    }

    private void addPairToAlignment(int a, int b) {
        if (!this.alignmentResultIndex.containsKey(a)) {
            this.alignmentResult.add(this.getAlignmentString(a, -1));
            this.alignmentResultIndex.put(a, this.alignmentResult.indexOf(a));
        }
        this.alignmentResult.add(this.getAlignmentString(b, a));
        this.alignmentResultIndex.put(b, this.alignmentResult.indexOf(b));
    }

    private String getAlignmentString(int sourceIndex, int targetIndex) {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        ProteinProfile profile = (ProteinProfile)this.profileList.get(sourceIndex);
        sb.append(profile.getName());
        if (targetIndex != -1) {
            ProteinProfile targetProfile = (ProteinProfile)this.profileList.get(targetIndex);
            sb.append("\t" + targetProfile.getName());
            sb.append("\t" + this.alignmentMatrix.getAlignmentValue(sourceIndex, targetIndex));
        }
        return sb.toString();
    }

    public AlignmentMatrix getAlignmentMatrixCopy() {
        return this.alignmentMatrix.copyAlignment();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        int i = 0;
        while (i < this.alignmentPairs.size()) {
            Pair pair = (Pair)this.alignmentPairs.get(i);
            ProteinProfile profileI = (ProteinProfile)this.profileList.get(pair.i);
            ProteinProfile profileJ = (ProteinProfile)this.profileList.get(pair.j);
            sb.append(String.valueOf(profileI.getName()) + "\t" + profileJ.getName());
            sb.append(lineSep);
            ++i;
        }
        sb.append(lineSep);
        return sb.toString();
    }

    private class Pair {
        public int i = 0;
        public int j = 0;

        public boolean equals(Object arg) {
            if (arg != null && arg instanceof Pair) {
                Pair pair = (Pair)arg;
                if (pair.i == this.i && pair.j == this.j) {
                    return true;
                }
                if (pair.j == this.i && pair.i == this.j) {
                    return true;
                }
            }
            return false;
        }
    }
}

