/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.brain.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.baderlab.brain.AlignedProteinSequenceIdentityDistance;
import org.baderlab.brain.AvgLinkHierarchicalClustering;
import org.baderlab.brain.DistanceMatrix;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.io.SeqIOTools;

public class AvgLinkHierarchicalClusteringTest
extends TestCase {
    DistanceMatrix distanceMatrix = null;

    public void setUp() throws FileNotFoundException, BioException {
        BufferedReader brCluster = new BufferedReader(new FileReader("testData" + File.separator + "optimalClusterLeafOrderingTest.txt"));
        SequenceIterator clusterProteins = (SequenceIterator)SeqIOTools.fileToBiojava("fasta", "PROTEIN", brCluster);
        ArrayList<String> clusterProteinSequenceStringList = new ArrayList<String>();
        ArrayList<String> clusterProteinNameList = new ArrayList<String>();
        ArrayList<Sequence> clusterProteinSequenceList = new ArrayList<Sequence>();
        while (clusterProteins.hasNext()) {
            Sequence sequence = clusterProteins.nextSequence();
            clusterProteinSequenceList.add(sequence);
            clusterProteinSequenceStringList.add(sequence.seqString());
            clusterProteinNameList.add(sequence.getName());
        }
        this.distanceMatrix = new DistanceMatrix(clusterProteinSequenceStringList.size());
        this.distanceMatrix.setLabels(clusterProteinNameList);
        this.distanceMatrix.calcDistances(clusterProteinSequenceStringList, new AlignedProteinSequenceIdentityDistance());
    }

    public void testOptimalLeafOrdering() {
        AvgLinkHierarchicalClustering cluster = new AvgLinkHierarchicalClustering(this.distanceMatrix);
        cluster.setOptimalLeafOrdering(true);
        cluster.run();
        System.out.println("Optimal and heuristic GTR format:");
        System.out.print(cluster.writeResultsToGTRFormat());
        System.out.println();
        System.out.println("Optimal CDT format:");
        System.out.print(cluster.toCDTString());
        System.out.println();
        cluster.setOptimalLeafOrdering(false);
        cluster.run();
        System.out.println("Heuristic CDT format:");
        System.out.print(cluster.toCDTString());
        System.out.println();
    }
}

