/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.baderlab.brain.BrainAlgorithm;
import org.baderlab.brain.PeptideToProfileReader;
import org.baderlab.brain.ProteinProfile;
import org.baderlab.brain.ProteinSequenceUtil;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoGenerator;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.ProfileSet;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.Symbol;

public class GenerateLogoTask
implements Task {
    private TaskMonitor taskMonitor = null;
    BrainAlgorithm alg = null;
    ProfileSet profileSet;
    LolaParameterSet paramSet;

    public GenerateLogoTask(ProfileSet profileSet, LolaParameterSet paramSet) {
        this.profileSet = profileSet;
        this.paramSet = paramSet;
        this.alg = new BrainAlgorithm();
    }

    @Override
    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        this.alg.setTaskMonitor(this.taskMonitor);
        this.taskMonitor.setStatus("Loading profiles");
        List profileList = PeptideToProfileReader.readPeptidesAsProfiles(this.paramSet.getProfileFile(), this.paramSet.getFuzzFactor(), this.paramSet.getCodonBiasFile(), this.paramSet.getUniquePeptides(), true);
        this.profileSet.clear();
        this.taskMonitor.setStatus("Drawing logos");
        int i = 0;
        while (i < profileList.size()) {
            ProteinProfile proteinProfile = (ProteinProfile)profileList.get(i);
            BufferedImage image = LogoGenerator.generateImage(proteinProfile, this.paramSet, "_logo");
            Profile profile = new Profile();
            profile.set(proteinProfile);
            profile.setImage(image);
            this.profileSet.addElement(profile);
            ++i;
        }
    }

    private ArrayList get20aaAlphabet() {
        ArrayList<Symbol> alphabet = new ArrayList<Symbol>(20);
        HashMap alphabetMap = ProteinSequenceUtil.get20aaAlphabet();
        Collection symbols = alphabetMap.values();
        for (Symbol symbol : symbols) {
            alphabet.add(symbol);
        }
        return alphabet;
    }

    public void correctForAmbiguitySymbolX(ProteinProfile proteinProfile) {
        ArrayList alphabet = this.get20aaAlphabet();
        if (alphabet == null) {
            throw new IllegalStateException("Alphabet array could not be set.");
        }
        SimpleWeightMatrix wm = proteinProfile.getWeightMatrix();
        SimpleAlignment align = new SimpleAlignment(proteinProfile.getSequenceHashMap());
        Distribution[] dists = null;
        ArrayList<Double> distWeightSum = new ArrayList<Double>();
        try {
            dists = DistributionTools.distOverAlignment(align, false, this.paramSet.getFuzzFactor());
        }
        catch (IllegalAlphabetException e1) {
            e1.printStackTrace();
        }
        int i = 0;
        while (i < dists.length) {
            double weightSum = 0.0;
            Distribution d = dists[i];
            for (Symbol symbol : alphabet) {
                try {
                    double weight = d.getWeight(symbol);
                    weightSum += weight;
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
            }
            distWeightSum.add(i, weightSum);
            ++i;
        }
        List seqs = align.getLabels();
        ArrayList<Integer> xFrequency = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < align.length()) {
            xFrequency.add(i2, 0);
            ++i2;
        }
        i2 = 0;
        while (i2 < align.length()) {
            for (Object seqLabel : seqs) {
                Symbol s = align.symbolAt(seqLabel, i2 + 1);
                try {
                    String symbolString = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(s);
                    if (!symbolString.equalsIgnoreCase("X")) continue;
                    xFrequency.set(i2, (Integer)xFrequency.get(i2) + 1);
                }
                catch (IllegalSymbolException e) {
                    e.printStackTrace();
                }
                catch (BioException e) {
                    e.printStackTrace();
                }
            }
            ++i2;
        }
        System.out.println("WM Columns: " + wm.columns() + " | Alignment Length: " + align.length());
        i2 = 0;
        while (i2 < xFrequency.size()) {
            System.out.println("Xs at position " + i2 + ": " + xFrequency.get(i2) + " | weightSum = " + distWeightSum.get(i2));
            ++i2;
        }
        SimpleDistributionTrainerContext dtc = new SimpleDistributionTrainerContext();
        try {
            int i3 = 0;
            while (i3 < wm.columns()) {
                Distribution d = wm.getColumn(i3);
                double weight = 0.0;
                Symbol symbolX = AlphabetManager.getAllAmbiguitySymbol(ProteinTools.getAlphabet());
                String symbolStringX = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(symbolX);
                dtc.registerDistribution(d);
                double weightX = d.getWeight(symbolX);
                System.out.println("weight(" + symbolStringX + ")[" + i3 + "] = " + weightX);
                for (Symbol symbol : alphabet) {
                    String symbolString = ProteinTools.getAlphabet().getTokenization("token").tokenizeSymbol(symbol);
                    if (symbolString.equals("U")) continue;
                    int xFreq = (Integer)xFrequency.get(i3);
                    double weight0 = d.getWeight(symbol);
                    weight = d.getWeight(symbol) - (double)xFreq + (double)(xFreq / alphabet.size());
                    System.out.println("weight0(" + symbolString + ") = " + weight0 + " | " + "weight1(" + symbolString + ") = " + weight);
                }
                ++i3;
            }
        }
        catch (BioException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void halt() {
    }

    @Override
    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    @Override
    public String getTitle() {
        return new String("Generating Sequence Logos");
    }
}

