/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.lola.view;

import cytoscape.util.OpenBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import org.baderlab.brain.AminoAcidGrouping;
import org.baderlab.brain.Brain;
import org.baderlab.brain.util.JMultiLineToolTip;
import org.baderlab.lola.LolaCurrentParameters;
import org.baderlab.lola.LolaParameterSet;
import org.baderlab.lola.model.LogoTree;
import org.baderlab.lola.model.Profile;
import org.baderlab.lola.model.ProfileSet;
import org.baderlab.lola.resources.LolaResources;
import org.baderlab.lola.view.actions.MakeLogoTreeAction;
import org.baderlab.lola.view.actions.MakeLogosFromProfileSetAction;
import org.baderlab.lola.view.actions.SaveLogoTreeToFile;
import org.baderlab.lola.view.actions.SaveLogosToFileAction;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;

public class LolaMainFrame
implements Runnable {
    private ProfileSet allProfiles = new ProfileSet();
    private ProfileSet selectedProfiles = new ProfileSet();
    private LolaParameterSet currentParamsCopy;
    private JTabbedPane tabbedPane;
    private JTextField profileFileNameTextField;
    private JTextField biasFileNameTextField;
    private JTextField outputPathTextField;
    private JCheckBox uniquePeptidesCheckBox;
    private JButton openProfileButton;
    private JButton drawLogoButton;
    private JButton saveLogoButton;
    private JButton closeSelectedProfilesButton;
    private JButton closeAllProfilesButton;
    private JButton quitButton;
    private JPanel logoPanel;
    private colorStyleDialog logoColorStyleDialog;
    private JFormattedTextField logoStartIndexTextField;
    private JFormattedTextField logoHeightTextField;
    private JFormattedTextField logoTrimPercentageTextField;
    private JComboBox logoFormatComboBox;
    private JComboBox logoColorComboBox;
    private ArrayList<JFormattedTextField> logoColorTextFields;
    private ArrayList<JTextField> logoColorBoxes;
    private boolean isCustomColoring;
    private ArrayList<JButton> logoColorButtons;
    private int logoColorCategories;
    private JPanel treePanel;
    private JTextField logoTreeTitle;
    private JTextField logoTreeOutputFilename;
    private JFormattedTextField logoTreeLeafTrimFactor;
    private JFormattedTextField logoTreeInternalNodeTrimFactor;
    private JButton createLogoTreeButton;
    private JButton saveLogoTreeButton;
    private JComboBox logoTreeLeafOrderingComboBox;
    private JComboBox groupingMethodComboBox;
    JList profileList;
    private JScrollPane logoPane;
    private static final JFrame mainFrame = new JFrame("LOLA 1.35 beta");

    public LolaMainFrame() {
        this.allProfiles.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                LolaMainFrame.this.drawLogoButton.setEnabled(true);
                LolaMainFrame.this.saveLogoButton.setEnabled(true);
                if (LolaMainFrame.this.allProfiles.size() > 1) {
                    LolaMainFrame.this.createLogoTreeButton.setEnabled(true);
                    LolaMainFrame.this.saveLogoTreeButton.setEnabled(true);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (LolaMainFrame.this.allProfiles.size() == 0) {
                    LolaMainFrame.this.drawLogoButton.setEnabled(false);
                    LolaMainFrame.this.saveLogoButton.setEnabled(false);
                    LolaMainFrame.this.createLogoTreeButton.setEnabled(false);
                    LolaMainFrame.this.saveLogoTreeButton.setEnabled(false);
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.logoColorBoxes = new ArrayList();
        this.logoColorTextFields = new ArrayList();
        this.isCustomColoring = false;
    }

    @Override
    public void run() {
        mainFrame.setDefaultCloseOperation(3);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        JSplitPane leftSplitPane = new JSplitPane(0);
        leftSplitPane.setContinuousLayout(true);
        leftSplitPane.setOneTouchExpandable(true);
        JScrollPane paramPane = new JScrollPane(this.getParameterPanel());
        this.profileList = new JList(this.allProfiles);
        JPanel profilePanel = new JPanel(new BorderLayout());
        JScrollPane profilePane = new JScrollPane(this.profileList);
        profilePane.setBorder(BorderFactory.createEtchedBorder());
        this.profileList.setSelectionMode(2);
        this.profileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Object[] objs = ((JList)listSelectionEvent.getSource()).getSelectedValues();
                if (objs.length < 1) {
                    return;
                }
                LolaMainFrame.this.selectedProfiles.removeAllElements();
                int i = 0;
                while (i < objs.length) {
                    Profile profile = null;
                    if (objs[i] != null) {
                        profile = (Profile)objs[i];
                        LolaMainFrame.this.selectedProfiles.addElement(profile);
                    }
                    ImageIcon icon = new ImageIcon(profile.getImage());
                    LolaMainFrame.this.logoPane.setViewportView(new JLabel(icon));
                    ++i;
                }
                LolaMainFrame.this.closeSelectedProfilesButton.setEnabled(true);
            }
        });
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.closeSelectedProfilesButton = new JButton("Close Selected");
        this.closeSelectedProfilesButton.addActionListener(new closeSelectedProfilesAction());
        this.closeSelectedProfilesButton.setEnabled(false);
        bottomPanel.add(this.closeSelectedProfilesButton);
        this.closeAllProfilesButton = new JButton("Close All");
        this.closeAllProfilesButton.addActionListener(new closeAllProfilesAction());
        this.closeAllProfilesButton.setEnabled(true);
        bottomPanel.add(this.closeAllProfilesButton);
        this.quitButton = new JButton("Quit");
        this.quitButton.addActionListener(new quitAction());
        this.quitButton.setEnabled(true);
        bottomPanel.add(this.quitButton);
        profilePanel.add((Component)profilePane, "Center");
        profilePanel.add((Component)bottomPanel, "Last");
        leftSplitPane.setTopComponent(paramPane);
        leftSplitPane.setBottomComponent(profilePanel);
        ImageIcon icon = null;
        URL imageURL = LolaMainFrame.class.getResource("/org/baderlab/lola/resources/lola_logo.png");
        if (imageURL != null) {
            icon = new ImageIcon(imageURL);
        }
        JLabel imageLabel = new JLabel(icon);
        this.logoPane = new JScrollPane(imageLabel);
        this.logoPane.setBorder(BorderFactory.createEtchedBorder());
        splitPane.setLeftComponent(leftSplitPane);
        splitPane.setRightComponent(this.logoPane);
        mainFrame.add((Component)splitPane, "Center");
        mainFrame.setSize(1400, 900);
        mainFrame.setLocationRelativeTo(null);
        mainFrame.setVisible(true);
    }

    private JPanel getParameterPanel() {
        this.currentParamsCopy = LolaCurrentParameters.getInstance().getParamsCopy();
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Files", null, this.getFilesPanel(), "Set parameters that affect how sequence logos are generated.");
        this.logoPanel = this.getLogoGenerationParamsPanel();
        this.tabbedPane.addTab("Logo Options", null, this.logoPanel);
        this.treePanel = this.getLogoTreeParamsPanel();
        this.tabbedPane.addTab("Logo Tree", null, this.treePanel);
        this.tabbedPane.addTab("About", null, this.getAboutPanel());
        this.tabbedPane.addMouseListener(new tabbedPaneMouseListener());
        mainPanel.add((Component)this.tabbedPane, "Center");
        return mainPanel;
    }

    private JPanel getFilesPanel() {
        JPanel filesPanel = new JPanel(new BorderLayout());
        JPanel profileSelectionPanel = new JPanel(new BorderLayout());
        profileSelectionPanel.setBorder(BorderFactory.createTitledBorder("Profile Selection"));
        JPanel profileChooserPanel = new JPanel();
        this.profileFileNameTextField = new JTextField();
        this.profileFileNameTextField.setToolTipText("The file name of the profile or list of profiles.");
        if (this.currentParamsCopy.getProfileFile() != null) {
            this.profileFileNameTextField.setText(this.currentParamsCopy.getProfileFile().toString());
        }
        this.profileFileNameTextField.setColumns(30);
        this.profileFileNameTextField.addActionListener(new profileFileNameAction());
        this.profileFileNameTextField.getDocument().addDocumentListener(new profileFileNameAction());
        profileChooserPanel.add(this.profileFileNameTextField);
        JButton profileChooseFileButton = new JButton("Browse...");
        profileChooseFileButton.addActionListener(new chooseProfileAction());
        profileChooserPanel.add(profileChooseFileButton);
        profileSelectionPanel.add((Component)profileChooserPanel, "North");
        JPanel profileChooserSubSubPanel = new JPanel();
        this.uniquePeptidesCheckBox = new JCheckBox("Unique peptides", false){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        this.uniquePeptidesCheckBox.addItemListener(new uniquePeptidesCheckBoxAction());
        this.uniquePeptidesCheckBox.setToolTipText("If checked, only unique peptide sequences will be loaded from the profile.");
        this.uniquePeptidesCheckBox.setSelected(this.currentParamsCopy.getUniquePeptides());
        profileChooserSubSubPanel.add(this.uniquePeptidesCheckBox);
        profileSelectionPanel.add((Component)profileChooserSubSubPanel, "South");
        JPanel biasSelectionPanel = new JPanel(new BorderLayout());
        biasSelectionPanel.setBorder(BorderFactory.createTitledBorder("Codon Bias File"));
        JPanel biasFileChooserPanel = new JPanel();
        this.biasFileNameTextField = new JTextField();
        this.biasFileNameTextField.setToolTipText("The file name of the codon bias file specification.");
        if (this.currentParamsCopy.getCodonBiasFile() != null) {
            this.biasFileNameTextField.setText(this.currentParamsCopy.getCodonBiasFile().toString());
        }
        this.biasFileNameTextField.setColumns(30);
        this.biasFileNameTextField.addActionListener(new codonBiasFileNameAction());
        this.biasFileNameTextField.getDocument().addDocumentListener(new codonBiasFileNameAction());
        biasFileChooserPanel.add(this.biasFileNameTextField);
        JButton biasFileChooseFileButton = new JButton("Browse...");
        biasFileChooseFileButton.addActionListener(new chooseCodonBiasAction());
        biasFileChooserPanel.add(biasFileChooseFileButton);
        biasSelectionPanel.add((Component)biasFileChooserPanel, "North");
        JPanel outputPathSelectionPanel = new JPanel(new BorderLayout());
        outputPathSelectionPanel.setBorder(BorderFactory.createTitledBorder("Output Directory"));
        JPanel outputPathChooserPanel = new JPanel();
        this.outputPathTextField = new JTextField();
        this.outputPathTextField.setToolTipText("The directory path where output files will be saved.");
        if (this.currentParamsCopy.getOutputPath() != null) {
            this.outputPathTextField.setText(this.currentParamsCopy.getOutputPath().toString());
        }
        this.outputPathTextField.setColumns(30);
        this.outputPathTextField.addActionListener(new outputPathAction());
        this.outputPathTextField.getDocument().addDocumentListener(new outputPathAction());
        outputPathChooserPanel.add(this.outputPathTextField);
        JButton outputPathChooseFileButton = new JButton("Browse...");
        outputPathChooseFileButton.addActionListener(new chooseOutputPathAction());
        outputPathChooserPanel.add(outputPathChooseFileButton);
        outputPathSelectionPanel.add((Component)outputPathChooserPanel, "North");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.openProfileButton = new JButton("Open");
        this.openProfileButton.addActionListener(new MakeLogosFromProfileSetAction(this.allProfiles, this.currentParamsCopy));
        this.openProfileButton.setEnabled(false);
        bottomPanel.add(this.openProfileButton);
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new clearFileFieldsAction());
        bottomPanel.add(clearButton);
        JPanel tab1Panel = new JPanel();
        tab1Panel.setMinimumSize(new Dimension(100, 200));
        tab1Panel.setLayout(new BoxLayout(tab1Panel, 1));
        tab1Panel.add(profileSelectionPanel);
        tab1Panel.add(biasSelectionPanel);
        tab1Panel.add(outputPathSelectionPanel);
        tab1Panel.add(bottomPanel);
        filesPanel.add((Component)tab1Panel, "North");
        return tab1Panel;
    }

    private JPanel old_getAboutPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new FlowLayout());
        JTextArea aboutTextArea = new JTextArea();
        aboutTextArea.setText("\n\nLOLA - LOgos Look Amazing!\nVersion 1.35 beta(June 5, 2009)\n\nMoyez Dharsee\nGary Bader\n\nwww.baderlab.org");
        aboutTextArea.setAlignmentX(0.5f);
        aboutTextArea.setAlignmentY(0.5f);
        aboutTextArea.setEditable(false);
        aboutTextArea.setRows(10);
        aboutTextArea.setOpaque(false);
        aboutPanel.setAlignmentX(0.5f);
        aboutPanel.add(aboutTextArea);
        return aboutPanel;
    }

    private JPanel getAboutPanel() {
        JPanel aboutPanel = new JPanel();
        aboutPanel.setLayout(new FlowLayout());
        JEditorPane editorPane = new JEditorPane();
        editorPane.setOpaque(false);
        editorPane.setMargin(new Insets(10, 10, 10, 10));
        editorPane.setEditable(false);
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.addHyperlinkListener(new HyperlinkAction(editorPane));
        editorPane.setText("<html><body><P align=center><b>LOLA - LOgos Look Amazing!</b><BR>Version 1.35 beta<BR>June 5, 2009<BR><BR>Moyez Dharsee<BR>Gary Bader<BR><BR><a href='http://www.baderlab.org'>Bader Lab<BR>www.baderlab.org</a>");
        aboutPanel.add(editorPane);
        return aboutPanel;
    }

    private JPanel getLogoTreeParamsPanel() {
        JPanel logoTreeOutputPanel = new JPanel();
        logoTreeOutputPanel.setAlignmentX(0.0f);
        logoTreeOutputPanel.setLayout(new BorderLayout());
        logoTreeOutputPanel.setBorder(BorderFactory.createTitledBorder("Basic Options"));
        JPanel leftOutputPanel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        leftOutputPanel.setLayout(layout);
        leftOutputPanel.setAlignmentX(0.0f);
        JPanel titlePanel = new JPanel();
        BoxLayout titleLayout = new BoxLayout(titlePanel, 0);
        titlePanel.setLayout(titleLayout);
        JLabel treeTitleLabel = new JLabel("Title: ");
        treeTitleLabel.setAlignmentX(0.0f);
        this.logoTreeTitle = new JFormattedTextField();
        this.logoTreeTitle.setAlignmentX(0.0f);
        this.logoTreeTitle.setToolTipText("Title to be displayed at the top of the logo tree image.");
        this.logoTreeTitle.setColumns(30);
        this.logoTreeTitle.addPropertyChangeListener("value", new textFieldChangeListener());
        String title = this.currentParamsCopy.getTreeTitle();
        if (title != null) {
            this.logoTreeTitle.setText(title);
        }
        LolaMainFrame.addGridBagComponent(leftOutputPanel, treeTitleLabel, 0, 0, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoTreeTitle, 1, 0, 1, 1, 10, 1);
        JPanel outputPanel = new JPanel();
        BoxLayout outputLayout = new BoxLayout(outputPanel, 0);
        outputPanel.setLayout(outputLayout);
        JLabel outputNameLabel = new JLabel();
        outputNameLabel.setText("Output Filename: ");
        outputNameLabel.setAlignmentX(0.0f);
        this.logoTreeOutputFilename = new JFormattedTextField();
        this.logoTreeOutputFilename.setAlignmentX(0.0f);
        this.logoTreeOutputFilename.setToolTipText("Name of logo tree output file. DIRECTORY PATH IS NOT REQUIRED.   The file will be saved in the Output Directory set in the Files panel.");
        this.logoTreeOutputFilename.setColumns(30);
        this.logoTreeOutputFilename.addPropertyChangeListener("value", new textFieldChangeListener());
        LolaMainFrame.addGridBagComponent(leftOutputPanel, outputNameLabel, 0, 1, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoTreeOutputFilename, 1, 1, 1, 1, 10, 1);
        JPanel rightOutputPanel = new JPanel();
        rightOutputPanel.setLayout(new FlowLayout());
        JPanel logoFormatPanel = new JPanel();
        JLabel logoFormatLabel = new JLabel();
        logoFormatLabel.setText("Output Format:");
        this.logoFormatComboBox = new JComboBox<String>(LolaResources.TREE_IMAGE_FORMAT_STRINGS);
        this.logoFormatComboBox.setToolTipText("Ouput file format of logo tree.");
        String currentFormat = this.currentParamsCopy.getLogoImageFileFormat();
        if (currentFormat != null) {
            int i = 0;
            while (i < LolaResources.TREE_IMAGE_FORMAT_STRINGS.length) {
                if (currentFormat.equalsIgnoreCase(LolaResources.TREE_IMAGE_FORMAT_STRINGS[i])) {
                    this.logoFormatComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        this.logoFormatComboBox.addActionListener(new selectLogoTreeFormatAction());
        LolaMainFrame.addGridBagComponent(leftOutputPanel, logoFormatLabel, 0, 2, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(leftOutputPanel, this.logoFormatComboBox, 1, 2, 1, 1, 21, 0);
        logoTreeOutputPanel.add((Component)leftOutputPanel, "First");
        logoTreeOutputPanel.add((Component)rightOutputPanel, "Last");
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.createLogoTreeButton = new JButton("Generate");
        this.createLogoTreeButton.addActionListener(new generateLogoTreeAction());
        this.createLogoTreeButton.setEnabled(false);
        bottomPanel.add(this.createLogoTreeButton);
        this.saveLogoTreeButton = new JButton("Save");
        this.saveLogoTreeButton.addActionListener(new SaveLogoTreeToFile(this.allProfiles, this.currentParamsCopy));
        this.saveLogoTreeButton.setEnabled(false);
        bottomPanel.add(this.saveLogoTreeButton);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)logoTreeOutputPanel, "North");
        thePanel.add((Component)this.createLogoTreeAdvancedOptionsPanel(), "Center");
        thePanel.add((Component)bottomPanel, "South");
        return thePanel;
    }

    private JCollapsablePanel createLogoTreeAdvancedOptionsPanel() {
        JCollapsablePanel mainPanel = new JCollapsablePanel("Advanced Options");
        mainPanel.setAlignmentX(0.0f);
        JPanel subPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        subPanel.setLayout(mainLayout);
        subPanel.setAlignmentX(0.0f);
        JPanel leafTrimFactorPanel = new JPanel();
        leafTrimFactorPanel.setAlignmentX(0.0f);
        BoxLayout leafTrimFactorLayout = new BoxLayout(leafTrimFactorPanel, 0);
        leafTrimFactorPanel.setLayout(leafTrimFactorLayout);
        JLabel leafTrimFactorLabel = new JLabel();
        leafTrimFactorLabel.setText("Trim Factor for Leaf Nodes: ");
        leafTrimFactorLabel.setAlignmentX(0.0f);
        this.logoTreeLeafTrimFactor = new JFormattedTextField();
        this.logoTreeLeafTrimFactor.setAlignmentX(0.0f);
        this.logoTreeLeafTrimFactor.setToolTipText("Trim factor for leaf nodes");
        this.logoTreeLeafTrimFactor.setColumns(5);
        this.logoTreeLeafTrimFactor.addPropertyChangeListener("value", new textFieldChangeListener());
        LolaMainFrame.addGridBagComponent(subPanel, leafTrimFactorLabel, 0, 0, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.logoTreeLeafTrimFactor, 1, 0, 1, 1, 21, 0);
        this.logoTreeLeafTrimFactor.setValue(0.1);
        JPanel internalNodeTrimFactorPanel = new JPanel();
        internalNodeTrimFactorPanel.setAlignmentX(0.0f);
        BoxLayout internalNodeTrimFactorLayout = new BoxLayout(internalNodeTrimFactorPanel, 0);
        internalNodeTrimFactorPanel.setLayout(internalNodeTrimFactorLayout);
        JLabel internalNodeTrimFactorLabel = new JLabel();
        internalNodeTrimFactorLabel.setText("Trim Factor for Internal Nodes: ");
        internalNodeTrimFactorLabel.setAlignmentX(0.0f);
        this.logoTreeInternalNodeTrimFactor = new JFormattedTextField();
        this.logoTreeInternalNodeTrimFactor.setAlignmentX(0.0f);
        this.logoTreeInternalNodeTrimFactor.setToolTipText("Trim factor for leaf nodes");
        this.logoTreeInternalNodeTrimFactor.setColumns(5);
        this.logoTreeInternalNodeTrimFactor.addPropertyChangeListener("value", new textFieldChangeListener());
        LolaMainFrame.addGridBagComponent(subPanel, internalNodeTrimFactorLabel, 0, 1, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.logoTreeInternalNodeTrimFactor, 1, 1, 1, 1, 21, 0);
        this.logoTreeInternalNodeTrimFactor.setValue(0.1);
        JPanel leafOrderingPanel = new JPanel();
        leafOrderingPanel.setLayout(new FlowLayout());
        JLabel leafOrderingLabel = new JLabel("Leaf Ordering Method:");
        this.logoTreeLeafOrderingComboBox = new JComboBox<String>(Brain.LEAF_ORDERING_METHODS);
        this.logoTreeLeafOrderingComboBox.setToolTipText("Algorithm used for ordering leaf nodes");
        String currentOrdering = "Bar-Joseph";
        if (currentOrdering != null) {
            int i = 0;
            while (i < Brain.LEAF_ORDERING_METHODS.length) {
                if (currentOrdering.equalsIgnoreCase(Brain.LEAF_ORDERING_METHODS[i])) {
                    this.logoTreeLeafOrderingComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        this.logoTreeLeafOrderingComboBox.addActionListener(new selectLogoTreeOrderingAction());
        LolaMainFrame.addGridBagComponent(subPanel, leafOrderingLabel, 0, 2, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.logoTreeLeafOrderingComboBox, 1, 2, 1, 1, 21, 0);
        JPanel groupingPanel = new JPanel();
        groupingPanel.setLayout(new FlowLayout());
        JLabel groupingLabel = new JLabel("Amino Acid Grouping:");
        this.groupingMethodComboBox = new JComboBox<String>(AminoAcidGrouping.GROUPING_METHODS);
        this.groupingMethodComboBox.setToolTipText(this.getGroupingComboBoxTooltip());
        String selectedGrouping = this.currentParamsCopy.getAminoAcidGrouping().getSelectedGrouping();
        int i = 0;
        while (i < AminoAcidGrouping.GROUPING_METHODS.length) {
            if (selectedGrouping.equalsIgnoreCase(AminoAcidGrouping.GROUPING_METHODS[i])) {
                this.groupingMethodComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.groupingMethodComboBox.addActionListener(new selectGroupingMethodAction());
        LolaMainFrame.addGridBagComponent(subPanel, groupingLabel, 0, 3, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.groupingMethodComboBox, 1, 3, 1, 1, 21, 0);
        mainPanel.getContentPane().add((Component)subPanel, "North");
        return mainPanel;
    }

    private static void addGridBagComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        Insets insets = new Insets(10, 10, 10, 10);
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 1, 0);
        container.add(component, gbc);
    }

    private JPanel getLogoGenerationParamsPanel() {
        JPanel logoSettingsPanel = new JPanel();
        logoSettingsPanel.setLayout(new FlowLayout());
        logoSettingsPanel.setBorder(BorderFactory.createTitledBorder("Basic Options"));
        JPanel leftSettingsPanel = new JPanel();
        leftSettingsPanel.setLayout(new BoxLayout(leftSettingsPanel, 1));
        JPanel startIndexPanel = new JPanel(new BorderLayout());
        JLabel startIndexLabel = new JLabel();
        startIndexLabel.setText("Start Index:");
        this.logoStartIndexTextField = new JFormattedTextField();
        this.logoStartIndexTextField.setToolTipText("The first index on the X-axis of the logo graph.");
        this.logoStartIndexTextField.setValue(this.currentParamsCopy.getLogoStartIndex());
        this.logoStartIndexTextField.setColumns(3);
        this.logoStartIndexTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        startIndexPanel.add((Component)startIndexLabel, "West");
        startIndexPanel.add((Component)this.logoStartIndexTextField, "East");
        startIndexPanel.setAlignmentX(1.0f);
        leftSettingsPanel.add(startIndexPanel);
        JPanel logoHeightPanel = new JPanel(new BorderLayout());
        JLabel logoHeightLabel = new JLabel();
        logoHeightLabel.setText("Height:");
        this.logoHeightTextField = new JFormattedTextField();
        this.logoHeightTextField.setToolTipText("The height of the logo image, in pixels.");
        this.logoHeightTextField.setValue(this.currentParamsCopy.getLogoHeight());
        this.logoHeightTextField.setColumns(3);
        this.logoHeightTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        logoHeightPanel.add((Component)logoHeightLabel, "West");
        logoHeightPanel.add((Component)this.logoHeightTextField, "East");
        logoHeightPanel.setAlignmentX(1.0f);
        leftSettingsPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        leftSettingsPanel.add(logoHeightPanel);
        JPanel rightSettingsPanel = new JPanel();
        rightSettingsPanel.setLayout(new BoxLayout(rightSettingsPanel, 1));
        JPanel logoFormatPanel = new JPanel();
        JLabel logoFormatLabel = new JLabel();
        logoFormatLabel.setText("Output Format:");
        this.logoFormatComboBox = new JComboBox<String>(LolaResources.IMAGE_FORMAT_STRINGS);
        this.logoFormatComboBox.setToolTipText("Ouput file format of logo image.");
        String currentFormat = this.currentParamsCopy.getLogoImageFileFormat();
        if (currentFormat != null) {
            int i = 0;
            while (i < LolaResources.IMAGE_FORMAT_STRINGS.length) {
                if (currentFormat.equalsIgnoreCase(LolaResources.IMAGE_FORMAT_STRINGS[i])) {
                    this.logoFormatComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        this.logoFormatComboBox.addActionListener(new selectLogoFormatAction());
        logoFormatPanel.add(logoFormatLabel);
        logoFormatPanel.add(this.logoFormatComboBox);
        logoFormatPanel.setAlignmentX(0.0f);
        rightSettingsPanel.add(logoFormatPanel);
        JPanel bottomPanel = new JPanel(new FlowLayout());
        this.drawLogoButton = new JButton("Redraw All");
        this.drawLogoButton.addActionListener(new MakeLogosFromProfileSetAction(this.allProfiles, this.currentParamsCopy));
        this.drawLogoButton.setEnabled(false);
        bottomPanel.add(this.drawLogoButton);
        this.saveLogoButton = new JButton("Save All");
        this.saveLogoButton.addActionListener(new SaveLogosToFileAction(this.allProfiles, this.currentParamsCopy));
        this.saveLogoButton.setEnabled(false);
        bottomPanel.add(this.saveLogoButton);
        logoSettingsPanel.add(leftSettingsPanel);
        logoSettingsPanel.add(Box.createRigidArea(new Dimension(0, 50)));
        logoSettingsPanel.add(rightSettingsPanel);
        JPanel thePanel = new JPanel(new BorderLayout());
        thePanel.add((Component)logoSettingsPanel, "North");
        thePanel.add((Component)this.createLogoAdvancedOptionsPanel(), "Center");
        thePanel.add((Component)bottomPanel, "South");
        return thePanel;
    }

    private JCollapsablePanel createLogoAdvancedOptionsPanel() {
        JCollapsablePanel mainPanel = new JCollapsablePanel("Advanced Options");
        mainPanel.setAlignmentX(0.0f);
        JPanel subPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        subPanel.setLayout(mainLayout);
        subPanel.setAlignmentX(0.0f);
        JLabel logoTrimPercentageLabel = new JLabel();
        logoTrimPercentageLabel.setText("Trim Percentage:");
        this.logoTrimPercentageTextField = new JFormattedTextField(){

            @Override
            public JToolTip createToolTip() {
                JMultiLineToolTip t = new JMultiLineToolTip();
                t.setColumns(40);
                return t;
            }
        };
        this.logoTrimPercentageTextField.setToolTipText("If columns on either end of the profile are not above this height (in terms of percentage of total possible column height), they will be trimmed. This has the effect of highlighting the most informative contiguous region. The value must be between 0 and 1, inclusively.");
        this.logoTrimPercentageTextField.setValue(this.currentParamsCopy.getLogoTrimPercentage());
        this.logoTrimPercentageTextField.setColumns(3);
        this.logoTrimPercentageTextField.addPropertyChangeListener("value", new textFieldChangeListener());
        LolaMainFrame.addGridBagComponent(subPanel, logoTrimPercentageLabel, 0, 0, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.logoTrimPercentageTextField, 1, 0, 1, 1, 21, 0);
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new FlowLayout());
        JLabel logoColorLabel = new JLabel();
        logoColorLabel.setText("Color Style: ");
        this.logoColorComboBox = new JComboBox(AminoAcidGrouping.COLORING_METHODS){

            @Override
            public JToolTip createToolTip() {
                JMultiLineToolTip t = new JMultiLineToolTip();
                t.setColumns(40);
                return t;
            }
        };
        this.logoColorComboBox.setToolTipText(this.getColorComboBoxTooltip());
        String selectedColor = this.currentParamsCopy.getAminoAcidGrouping().getSelectedColoring();
        if (selectedColor != null) {
            int i = 0;
            while (i < AminoAcidGrouping.COLORING_METHODS.length) {
                if (selectedColor.equalsIgnoreCase(AminoAcidGrouping.COLORING_METHODS[i])) {
                    this.logoColorComboBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        this.logoColorComboBox.addActionListener(new selectColorStyleAction());
        JButton customizeColorButton = new JButton("Customize...");
        customizeColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LolaMainFrame.this.logoColorStyleDialog = new colorStyleDialog(mainFrame, "Customize Color Style");
                LolaMainFrame.this.logoColorStyleDialog.setResizable(false);
                LolaMainFrame.this.logoColorStyleDialog.pack();
                LolaMainFrame.this.logoColorStyleDialog.setVisible(true);
            }
        });
        LolaMainFrame.addGridBagComponent(subPanel, logoColorLabel, 0, 2, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, this.logoColorComboBox, 1, 2, 1, 1, 21, 0);
        LolaMainFrame.addGridBagComponent(subPanel, customizeColorButton, 2, 2, 1, 1, 21, 0);
        mainPanel.getContentPane().add((Component)subPanel, "North");
        return mainPanel;
    }

    private String getColorComboBoxTooltip() {
        AminoAcidGrouping aaGroup = this.currentParamsCopy.getAminoAcidGrouping();
        ArrayList symbolList = aaGroup.getColorSymbolList();
        ArrayList categoryList = aaGroup.getColorCategoryList();
        String tooltip = aaGroup.getSelectedDescription();
        int i = 0;
        while (i < categoryList.size()) {
            tooltip = String.valueOf(tooltip) + " - " + symbolList.get(i) + " (" + categoryList.get(i) + ")";
            ++i;
        }
        return tooltip;
    }

    private String getGroupingComboBoxTooltip() {
        AminoAcidGrouping aaGroup = this.currentParamsCopy.getAminoAcidGrouping();
        ArrayList symbolList = aaGroup.getGroupList();
        ArrayList categoryList = aaGroup.getGroupCategoryList();
        String tooltip = aaGroup.getSelectedDescription();
        int i = 0;
        while (i < categoryList.size()) {
            tooltip = String.valueOf(tooltip) + " - " + symbolList.get(i) + " (" + categoryList.get(i) + ")";
            ++i;
        }
        return tooltip;
    }

    private File browseDirectory(String title, boolean directoryOnly) {
        JFileChooser fileDialog = new JFileChooser();
        if (directoryOnly) {
            fileDialog.setFileSelectionMode(1);
        }
        fileDialog.setDialogTitle(title);
        fileDialog.setVisible(true);
        fileDialog.showDialog(mainFrame, "OK");
        File file = fileDialog.getSelectedFile();
        return file;
    }

    private File browseFile(String title, boolean directoryOnly) {
        FileDialog fileDialog = new FileDialog((Frame)mainFrame, title, 0);
        fileDialog.setTitle(title);
        fileDialog.setVisible(true);
        String filePath = fileDialog.getFile();
        if (filePath != null) {
            return new File(String.valueOf(fileDialog.getDirectory()) + "/" + fileDialog.getFile());
        }
        return null;
    }

    private void displayLogoTree() {
        block3: {
            try {
                LogoTree tree = this.allProfiles.getLogoTree();
                if (tree == null) break block3;
                BufferedImage image = tree.getImage();
                if (image != null) {
                    ImageIcon icon = new ImageIcon(image);
                    this.logoPane.setViewportView(new JLabel(icon));
                    break block3;
                }
                throw new Exception("Could not obtain logo tree image.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void displaySelectedLogo() {
        Object[] objs = this.profileList.getSelectedValues();
        if (objs.length < 1) {
            return;
        }
        Profile profile = (Profile)objs[objs.length - 1];
        ImageIcon icon = new ImageIcon(profile.getImage());
        this.logoPane.setViewportView(new JLabel(icon));
    }

    public class ColorPicker
    extends JFrame {
        public ColorPicker() {
            super("JColorChooser Test Frame");
            this.setSize(200, 100);
            final Container contentPane = this.getContentPane();
            JButton go = new JButton("Show JColorChooser");
            go.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(((Component)e.getSource()).getParent(), "Demo", Color.blue);
                    contentPane.setBackground(c);
                }
            });
            contentPane.add((Component)go, "South");
            this.setDefaultCloseOperation(3);
        }
    }

    private class HyperlinkAction
    implements HyperlinkListener {
        JEditorPane pane;

        public HyperlinkAction(JEditorPane pane) {
            this.pane = pane;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                OpenBrowser.openURL(event.getURL().toString());
            }
        }
    }

    private class chooseCodonBiasAction
    extends AbstractAction {
        chooseCodonBiasAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseFile("Select Codon Bias Specification File", false);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setCodonBiasFile(chosenFile);
                LolaMainFrame.this.biasFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class chooseOutputPathAction
    extends AbstractAction {
        chooseOutputPathAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseDirectory("Select Output Path", true);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setOutputPath(chosenFile);
                LolaMainFrame.this.outputPathTextField.setText(chosenFile.toString());
            }
        }
    }

    private class chooseProfileAction
    extends AbstractAction {
        chooseProfileAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File chosenFile = LolaMainFrame.this.browseFile("Select Profile File", false);
            if (chosenFile != null) {
                LolaMainFrame.this.currentParamsCopy.setProfileFile(chosenFile);
                LolaMainFrame.this.profileFileNameTextField.setText(chosenFile.toString());
            }
        }
    }

    private class clearFileFieldsAction
    extends AbstractAction {
        clearFileFieldsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LolaMainFrame.this.profileFileNameTextField.setText(null);
            LolaMainFrame.this.biasFileNameTextField.setText(null);
            LolaMainFrame.this.outputPathTextField.setText(null);
            LolaMainFrame.this.logoTreeOutputFilename.setText(null);
            LolaMainFrame.this.openProfileButton.setEnabled(false);
            LolaMainFrame.this.createLogoTreeButton.setEnabled(false);
            LolaMainFrame.this.saveLogoTreeButton.setEnabled(false);
        }
    }

    private class closeAllProfilesAction
    implements ActionListener {
        private closeAllProfilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LolaMainFrame.this.allProfiles.removeAllElements();
            LolaMainFrame.this.closeSelectedProfilesButton.setEnabled(false);
            LolaMainFrame.this.logoPane.setViewportView(null);
        }
    }

    private class closeSelectedProfilesAction
    implements ActionListener {
        private closeSelectedProfilesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            while (LolaMainFrame.this.selectedProfiles.size() > 0) {
                Profile p = (Profile)LolaMainFrame.this.selectedProfiles.get(0);
                LolaMainFrame.this.allProfiles.removeElement(p);
                LolaMainFrame.this.selectedProfiles.removeElement(p);
            }
            LolaMainFrame.this.profileList.setSelectedIndex(0);
        }
    }

    private class codonBiasFileNameAction
    extends AbstractAction
    implements DocumentListener {
        codonBiasFileNameAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.biasFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setCodonBiasFile(file);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class colorStyleDialog
    extends JDialog {
        private JTextArea errorTextArea;
        private JButton okButton;

        public colorStyleDialog(Frame frame, String s) {
            super(frame, s);
            JPanel mainPanel = new JPanel(new BorderLayout());
            JPanel colorPanel = new JPanel();
            GridBagLayout panelLayout = new GridBagLayout();
            colorPanel.setLayout(panelLayout);
            colorPanel.setAlignmentX(0.5f);
            JLabel symbolLabel = new JLabel("Group");
            JLabel colourLabel = new JLabel("Color");
            LolaMainFrame.addGridBagComponent(colorPanel, symbolLabel, 0, 0, 1, 1, 21, 0);
            LolaMainFrame.addGridBagComponent(colorPanel, colourLabel, 1, 0, 1, 1, 21, 0);
            LolaMainFrame.this.logoColorBoxes.clear();
            LolaMainFrame.this.logoColorTextFields.clear();
            int originalNumberOfColors = LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().getNumberOfColors();
            int i = 0;
            while (i < originalNumberOfColors) {
                final int j = i;
                final JTextField colorBox = new JTextField();
                LolaMainFrame.this.logoColorBoxes.add(colorBox);
                colorBox.setColumns(3);
                colorBox.setEditable(false);
                colorBox.setBackground((Color)LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().getColorList().get(j));
                JFormattedTextField groupTextField = new JFormattedTextField();
                LolaMainFrame.this.logoColorTextFields.add(groupTextField);
                groupTextField.setColumns(10);
                groupTextField.setValue(LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().getColorSymbolList().get(j));
                groupTextField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        LolaMainFrame.this.logoColorStyleDialog.setErrorMessage("");
                        char charTyped = keyEvent.getKeyChar();
                        if (Character.isLetter(charTyped) && "ACDEFGHIKLMNPQRSTVWY".contains(Character.toString(charTyped).toUpperCase())) {
                            LolaMainFrame.this.logoColorStyleDialog.setErrorMessage("");
                            LolaMainFrame.this.logoColorStyleDialog.okButtonSetEnabled(true);
                        } else if (charTyped != '\b' && charTyped != '\u007f') {
                            LolaMainFrame.this.logoColorStyleDialog.setErrorMessage("Invalid symbol: " + charTyped);
                            LolaMainFrame.this.logoColorStyleDialog.okButtonSetEnabled(false);
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 27) {
                            colorStyleDialog.this.setVisible(false);
                        }
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                    }
                });
                JButton selectColorButton = new JButton("Select...");
                selectColorButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Color c = JColorChooser.showDialog(((Component)e.getSource()).getParent(), "Select Symbol Color", (Color)LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().getColorList().get(j));
                        colorBox.setBackground(c);
                    }
                });
                LolaMainFrame.addGridBagComponent(colorPanel, groupTextField, 0, i + 1, 1, 1, 21, 0);
                LolaMainFrame.addGridBagComponent(colorPanel, colorBox, 1, i + 1, 1, 1, 21, 0);
                LolaMainFrame.addGridBagComponent(colorPanel, selectColorButton, 2, i + 1, 1, 1, 21, 0);
                ++i;
            }
            JPanel errorPanel = new JPanel(new FlowLayout());
            this.errorTextArea = new JTextArea();
            this.errorTextArea.setColumns(30);
            this.errorTextArea.setRows(4);
            this.errorTextArea.setLineWrap(true);
            this.errorTextArea.setFont(new Font(null, 0, 10));
            this.errorTextArea.setForeground(Color.RED);
            this.errorTextArea.setBackground(LolaMainFrame.this.logoPanel.getBackground());
            this.errorTextArea.setEditable(false);
            errorPanel.add(this.errorTextArea);
            JPanel bottomPanel = new JPanel(new FlowLayout());
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new validateLogoColorStyleAction());
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    colorStyleDialog.this.setVisible(false);
                }
            });
            bottomPanel.add(this.okButton);
            bottomPanel.add(cancelButton);
            mainPanel.add((Component)colorPanel, "North");
            mainPanel.add((Component)errorPanel, "Center");
            mainPanel.add((Component)bottomPanel, "South");
            this.setContentPane(mainPanel);
            this.setLocationRelativeTo(frame);
            this.setModal(true);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        LolaMainFrame.this.logoColorStyleDialog.setVisible(false);
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        LolaMainFrame.this.logoColorStyleDialog.setVisible(false);
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        LolaMainFrame.this.logoColorStyleDialog.setVisible(false);
                    }
                }
            });
        }

        public void setErrorMessage(String errorMessage) {
            if (errorMessage != null) {
                this.errorTextArea.setText(errorMessage);
                this.errorTextArea.setVisible(true);
            }
        }

        public void okButtonSetEnabled(boolean flag) {
            this.okButton.setEnabled(flag);
        }
    }

    private class generateLogoTreeAction
    implements ActionListener {
        private generateLogoTreeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MakeLogoTreeAction action = null;
            try {
                action = new MakeLogoTreeAction(LolaMainFrame.this.allProfiles, LolaMainFrame.this.currentParamsCopy);
            }
            catch (OutOfMemoryError e) {
                System.out.println("Out of memory!!");
                JOptionPane.showMessageDialog(mainFrame, "Out of memory!");
            }
            action.actionPerformed(actionEvent);
            LolaMainFrame.this.displayLogoTree();
        }
    }

    private class logoStartIndexTextFieldAction
    extends AbstractAction
    implements DocumentListener {
        logoStartIndexTextFieldAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.logoStartIndexTextField.getText();
            if (value != null) {
                try {
                    LolaMainFrame.this.currentParamsCopy.setLogoStartIndex(Integer.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    class numericalTextVerifier
    extends InputVerifier {
        numericalTextVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (jComponent instanceof JTextField) {
                String text = ((JTextField)jComponent).getText();
                if (text != null) {
                    try {
                        int i = Integer.valueOf(text);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return false;
            }
            return false;
        }

        public boolean shouldYieldFocus() {
            return false;
        }
    }

    public class origColorPicker
    extends JFrame {
        public origColorPicker() {
            super("JColorChooser Test Frame");
            this.setSize(200, 100);
            final Container contentPane = this.getContentPane();
            JButton go = new JButton("Show JColorChooser");
            go.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color c = JColorChooser.showDialog(((Component)e.getSource()).getParent(), "Demo", Color.blue);
                    contentPane.setBackground(c);
                }
            });
            contentPane.add((Component)go, "South");
            this.setDefaultCloseOperation(3);
        }
    }

    private class outputPathAction
    extends AbstractAction
    implements DocumentListener {
        outputPathAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.outputPathTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setOutputPath(file);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class profileFileNameAction
    extends AbstractAction
    implements DocumentListener {
        profileFileNameAction() {
        }

        private void handleChange() {
            String value = LolaMainFrame.this.profileFileNameTextField.getText();
            if (value != null) {
                File file = new File(value);
                LolaMainFrame.this.currentParamsCopy.setProfileFile(file);
                LolaMainFrame.this.openProfileButton.setEnabled(true);
                String parentPath = file.getParent();
                if (parentPath != null) {
                    LolaMainFrame.this.outputPathTextField.setText(parentPath);
                }
                String fileName = String.valueOf(file.getName()) + ".LogoTree" + LolaResources.getFileExtension(LolaMainFrame.this.currentParamsCopy.getTreeImageFormat());
                LolaMainFrame.this.logoTreeOutputFilename.setText(fileName);
                LolaMainFrame.this.currentParamsCopy.setTreeFilename(fileName);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.handleChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }
    }

    private class quitAction
    implements ActionListener {
        private quitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Runtime.getRuntime().exit(0);
        }
    }

    private class selectColorStyleAction
    extends AbstractAction {
        selectColorStyleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String colorName = (String)cb.getSelectedItem();
                if (!LolaMainFrame.this.logoColorComboBox.getSelectedItem().toString().equalsIgnoreCase("Custom")) {
                    LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().setColoring(colorName);
                }
                LolaMainFrame.this.logoColorComboBox.setToolTipText(LolaMainFrame.this.getColorComboBoxTooltip());
            }
        }
    }

    private class selectGroupingMethodAction
    extends AbstractAction {
        selectGroupingMethodAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String methodName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().setGrouping(methodName);
                LolaMainFrame.this.groupingMethodComboBox.setToolTipText(LolaMainFrame.this.getGroupingComboBoxTooltip());
                if (!methodName.equalsIgnoreCase("No Grouping") && !LolaMainFrame.this.isCustomColoring) {
                    LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().setColoring(methodName);
                    int i = 0;
                    while (i < AminoAcidGrouping.COLORING_METHODS.length) {
                        if (methodName.equalsIgnoreCase(AminoAcidGrouping.COLORING_METHODS[i])) {
                            LolaMainFrame.this.logoColorComboBox.setSelectedIndex(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private class selectLogoFormatAction
    extends AbstractAction {
        selectLogoFormatAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String formatName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setLogoImageFormat(formatName);
            }
        }
    }

    private class selectLogoTreeFormatAction
    extends AbstractAction {
        selectLogoTreeFormatAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String formatName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setTreeImageFormat(formatName);
            }
        }
    }

    private class selectLogoTreeOrderingAction
    extends AbstractAction {
        selectLogoTreeOrderingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                JComboBox cb = (JComboBox)event.getSource();
                String methodName = (String)cb.getSelectedItem();
                LolaMainFrame.this.currentParamsCopy.setTreeLeafOrderingMethod(methodName);
            }
        }
    }

    private class tabbedPaneMouseListener
    implements MouseListener {
        private tabbedPaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Component selectedComponent = LolaMainFrame.this.tabbedPane.getSelectedComponent();
            if (selectedComponent.equals(LolaMainFrame.this.treePanel)) {
                LolaMainFrame.this.displayLogoTree();
            } else if (selectedComponent.equals(LolaMainFrame.this.logoPanel)) {
                LolaMainFrame.this.displaySelectedLogo();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    private class textFieldChangeListener
    implements PropertyChangeListener {
        private textFieldChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JTextField textField;
            String text;
            Object obj = event.getSource();
            if (obj instanceof JTextField && (text = (textField = (JTextField)obj).getText()) != null) {
                Number value;
                boolean isNegative = false;
                if (text.length() > 1 && text.substring(0, 1).equals("-")) {
                    isNegative = true;
                    Integer n = Integer.valueOf(text);
                }
                if (textField == LolaMainFrame.this.logoStartIndexTextField) {
                    value = (Number)LolaMainFrame.this.logoStartIndexTextField.getValue();
                    if (value != null) {
                        LolaMainFrame.this.currentParamsCopy.setLogoStartIndex(value.intValue());
                    } else {
                        LolaMainFrame.this.logoStartIndexTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoStartIndex());
                    }
                } else if (textField == LolaMainFrame.this.logoHeightTextField) {
                    value = (Number)LolaMainFrame.this.logoHeightTextField.getValue();
                    if (value != null && value.intValue() >= 10 && value.intValue() <= 2000) {
                        LolaMainFrame.this.currentParamsCopy.setLogoHeight(value.intValue());
                    } else {
                        LolaMainFrame.this.logoHeightTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoHeight());
                    }
                } else if (textField == LolaMainFrame.this.logoTrimPercentageTextField) {
                    value = (Number)LolaMainFrame.this.logoTrimPercentageTextField.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        LolaMainFrame.this.currentParamsCopy.setLogoTrimPercentage(value.doubleValue());
                    } else {
                        LolaMainFrame.this.logoTrimPercentageTextField.setValue(LolaMainFrame.this.currentParamsCopy.getLogoTrimPercentage());
                    }
                } else if (textField == LolaMainFrame.this.logoTreeTitle) {
                    if (text != null && text.length() > 0) {
                        LolaMainFrame.this.currentParamsCopy.setTreeTitle(text);
                    } else {
                        LolaMainFrame.this.currentParamsCopy.setTreeTitle("");
                    }
                } else if (textField == LolaMainFrame.this.logoTreeOutputFilename) {
                    if (text != null && text.length() > 0) {
                        LolaMainFrame.this.currentParamsCopy.setTreeFilename(text);
                    }
                } else if (textField == LolaMainFrame.this.logoTreeLeafTrimFactor) {
                    value = (Number)LolaMainFrame.this.logoTreeLeafTrimFactor.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        LolaMainFrame.this.currentParamsCopy.setTreeLeafTrimFactor(value.doubleValue());
                    } else {
                        LolaMainFrame.this.logoTreeLeafTrimFactor.setValue(LolaMainFrame.this.currentParamsCopy.getTreeLeafTrimFactor());
                    }
                } else if (textField == LolaMainFrame.this.logoTreeInternalNodeTrimFactor) {
                    value = (Number)LolaMainFrame.this.logoTreeInternalNodeTrimFactor.getValue();
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        LolaMainFrame.this.currentParamsCopy.setTreeInternalNodeTrimFactor(value.doubleValue());
                    } else {
                        LolaMainFrame.this.logoTreeInternalNodeTrimFactor.setValue(LolaMainFrame.this.currentParamsCopy.getTreeInternalNodeTrimFactor());
                    }
                }
            }
        }
    }

    private class uniquePeptidesCheckBoxAction
    implements ItemListener {
        private uniquePeptidesCheckBoxAction() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                LolaMainFrame.this.currentParamsCopy.setUniquePeptides(false);
            } else if (e.getStateChange() == 1) {
                LolaMainFrame.this.currentParamsCopy.setUniquePeptides(true);
            }
        }
    }

    private class validateLogoColorStyleAction
    implements ActionListener {
        private validateLogoColorStyleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AminoAcidGrouping aaGrouping = LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping();
            int numColors = LolaMainFrame.this.currentParamsCopy.getAminoAcidGrouping().getNumberOfColors();
            String errorMessage = "";
            boolean isError = false;
            ArrayList<Character> givenSymbols = new ArrayList<Character>();
            String givenSymbolsString = "";
            int i = 0;
            while (i < LolaMainFrame.this.logoColorTextFields.size()) {
                char[] s = ((JFormattedTextField)LolaMainFrame.this.logoColorTextFields.get(i)).getText().toUpperCase().toCharArray();
                int j = 0;
                while (j < s.length) {
                    givenSymbols.add(Character.valueOf(s[j]));
                    givenSymbolsString = String.valueOf(givenSymbolsString) + s[j];
                    ++j;
                }
                ++i;
            }
            String missingResidues = "";
            int i2 = 0;
            while (i2 < LolaResources.AMINO_ACIDS.length) {
                if (!givenSymbols.contains(Character.valueOf(LolaResources.AMINO_ACIDS[i2]))) {
                    missingResidues = String.valueOf(missingResidues) + LolaResources.AMINO_ACIDS[i2];
                }
                ++i2;
            }
            errorMessage = "Please correct the following errors:";
            if (missingResidues.length() > 0) {
                isError = true;
                errorMessage = String.valueOf(errorMessage) + "\nSome symbols are missing: " + missingResidues;
            }
            if (!this.containsValidSymbols(givenSymbolsString.toCharArray())) {
                isError = true;
                errorMessage = String.valueOf(errorMessage) + "\nSome characters provided are not valid symbols.";
            }
            if (!this.containsUniqueSymbols(givenSymbolsString.toCharArray())) {
                isError = true;
                errorMessage = String.valueOf(errorMessage) + "\nSome symbols have been provided more than once.";
            }
            if (isError) {
                LolaMainFrame.this.logoColorStyleDialog.setErrorMessage(errorMessage);
                return;
            }
            if (LolaMainFrame.this.logoColorBoxes.size() == numColors) {
                i2 = 0;
                while (i2 < LolaMainFrame.this.logoColorBoxes.size()) {
                    aaGrouping.setColorSymbols(i2, ((JFormattedTextField)LolaMainFrame.this.logoColorTextFields.get(i2)).getText().toUpperCase());
                    aaGrouping.setColor(i2, ((JTextField)LolaMainFrame.this.logoColorBoxes.get(i2)).getBackground());
                    ++i2;
                }
            }
            if (!LolaMainFrame.this.isCustomColoring) {
                LolaMainFrame.this.logoColorComboBox.addItem(new String("Custom"));
                LolaMainFrame.this.logoColorComboBox.setSelectedIndex(LolaMainFrame.this.logoColorComboBox.getModel().getSize() - 1);
                LolaMainFrame.this.isCustomColoring = true;
            }
            LolaMainFrame.this.logoColorStyleDialog.setVisible(false);
        }

        private boolean containsValidSymbols(char[] symbols) {
            if (symbols == null) {
                throw new IllegalArgumentException("Null argument received by symbol validator");
            }
            int i = 0;
            while (i < symbols.length) {
                if (!"ACDEFGHIKLMNPQRSTVWY".contains(Character.toString(symbols[i]).toUpperCase())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean containsUniqueSymbols(char[] symbols) {
            if (symbols == null) {
                throw new IllegalArgumentException("Null argument received by symbol uniqueness validator");
            }
            int i = 0;
            while (i < symbols.length) {
                int j = 0;
                while (j < symbols.length) {
                    if (i != j && symbols[i] == symbols[j]) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
    }
}

