/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.program.indexdb.IndexStore;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ParserException;
import org.biojava.utils.SmallMap;
import org.biojava.utils.io.CountedBufferedReader;
import org.biojava.utils.io.RAF;

public class Indexer
implements TagValueListener {
    private final RAF file;
    private final CountedBufferedReader reader;
    private final IndexStore indexStore;
    private final Map seccondaryKeys;
    private String primaryKeyName;
    private String primaryKey;
    private Object tag;
    private long offset;
    private int depth;

    public Indexer(File file, IndexStore indexStore) throws FileNotFoundException {
        this.file = new RAF(file, "r");
        this.reader = new CountedBufferedReader(new FileReader(file));
        this.indexStore = indexStore;
        this.seccondaryKeys = new SmallMap();
        this.depth = 0;
    }

    public CountedBufferedReader getReader() {
        return this.reader;
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void addSecondaryKey(String secKeyName) {
        this.seccondaryKeys.put(secKeyName, new ArrayList());
    }

    public void removeSecondaryKey(String secKeyName) {
        this.seccondaryKeys.remove(secKeyName);
    }

    public void startRecord() {
        if (this.depth == 0) {
            this.offset = this.reader.getFilePointer();
            this.primaryKey = null;
            Iterator i = this.seccondaryKeys.values().iterator();
            while (i.hasNext()) {
                List list = (List)i.next();
                list.clear();
            }
        }
        ++this.depth;
    }

    public void startTag(Object tag) {
        this.tag = tag;
    }

    public void value(TagValueContext ctxt, Object value) {
        List l;
        if (this.tag.equals(this.primaryKeyName)) {
            this.primaryKey = value.toString();
        }
        if ((l = (List)this.seccondaryKeys.get(this.tag)) != null) {
            l.add(value.toString());
        }
    }

    public void endTag() {
    }

    public void endRecord() throws ParserException {
        --this.depth;
        if (this.depth == 0) {
            if (this.primaryKey == null) {
                throw new NullPointerException("No primary key");
            }
            int length = (int)(this.reader.getFilePointer() - this.offset);
            this.indexStore.writeRecord(this.file, this.offset, length, this.primaryKey, this.seccondaryKeys);
        }
    }
}

