/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Iterator;
import java.util.Set;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMClassifierModel;
import org.biojava.stats.svm.TrainingContext;
import org.biojava.stats.svm.TrainingEvent;
import org.biojava.stats.svm.TrainingListener;

public class SMOTrainer {
    private double _C = 1000.0;
    private double _epsilon = 1.0E-6;

    public void setC(double C) {
        this._C = C;
    }

    public double getC() {
        return this._C;
    }

    public void setEpsilon(double epsilon) {
        this._epsilon = epsilon;
    }

    public double getEpsilon() {
        return this._epsilon;
    }

    private boolean takeStep(SMOTrainingContext trainingContext, int i1, int i2) {
        double b;
        double H;
        double L;
        if (i1 == i2) {
            return false;
        }
        double y1 = trainingContext.getTarget(i1);
        double y2 = trainingContext.getTarget(i2);
        double alpha1 = trainingContext.getAlpha(i1);
        double alpha2 = trainingContext.getAlpha(i2);
        double E1 = trainingContext.getError(i1);
        double E2 = trainingContext.getError(i2);
        double s = y1 * y2;
        double C = trainingContext.getC();
        double epsilon = trainingContext.getEpsilon();
        if (y2 != y1) {
            L = Math.max(0.0, alpha2 - alpha1);
            H = Math.min(C, C + alpha2 - alpha1);
        } else {
            L = Math.max(0.0, alpha1 + alpha2 - C);
            H = Math.min(C, alpha1 + alpha2);
        }
        if (L == H) {
            return false;
        }
        double k11 = trainingContext.getKernelValue(i1, i1);
        double k12 = trainingContext.getKernelValue(i1, i2);
        double k22 = trainingContext.getKernelValue(i2, i2);
        double eta = 2.0 * k12 - k11 - k22;
        double a1 = 0.0;
        double a2 = 0.0;
        if (eta > 0.0 && eta < epsilon) {
            eta = 0.0;
        }
        if (eta < 0.0) {
            a2 = alpha2 - y2 * (E1 - E2) / eta;
            if (a2 < L) {
                a2 = L;
            } else if (a2 > H) {
                a2 = H;
            }
        } else {
            return false;
        }
        a1 = alpha1 + s * (alpha2 - a2);
        if (Math.abs(a1 - alpha1) < epsilon * (a1 + alpha1 + 1.0 + epsilon)) {
            return false;
        }
        double bOLD = trainingContext.getThreshold();
        if (0.0 < a1 && a1 < C) {
            b = E1 + y1 * (a1 - alpha1) * k11 + y2 * (a2 - alpha2) * k12 + bOLD;
        } else if (0.0 < a2 && a2 < C) {
            b = E2 + y1 * (a1 - alpha1) * k12 + y2 * (a2 - alpha2) * k22 + bOLD;
        } else {
            double b1 = E1 + y1 * (a1 - alpha1) * k11 + y2 * (a2 - alpha2) * k12 + bOLD;
            double b2 = E2 + y1 * (a1 - alpha1) * k12 + y2 * (a2 - alpha2) * k22 + bOLD;
            b = (b1 + b2) / 2.0;
        }
        trainingContext.setThreshold(b);
        trainingContext.setAlpha(i1, a1);
        trainingContext.setAlpha(i2, a2);
        trainingContext.resetError(i1);
        trainingContext.resetError(i2);
        for (int l = 0; l < trainingContext.size(); ++l) {
            if (l == i1 || l == i2 || trainingContext.isBound(trainingContext.getAlpha(l))) continue;
            trainingContext.updateError(l, y1 * (a1 - alpha1) * trainingContext.getKernelValue(i1, l) + y2 * (a2 - alpha2) * trainingContext.getKernelValue(i2, l) + bOLD - b);
        }
        return true;
    }

    private int examineExample(SMOTrainingContext trainingContext, int i2) {
        double y2 = trainingContext.getTarget(i2);
        double alpha2 = trainingContext.getAlpha(i2);
        double E2 = trainingContext.getError(i2);
        double r2 = E2 * y2;
        double epsilon = trainingContext.getEpsilon();
        double C = trainingContext.getC();
        if (r2 < -epsilon && alpha2 < C || r2 > epsilon && alpha2 > 0.0) {
            int i1;
            int l;
            int secondChoice = -1;
            double step = 0.0;
            for (int l2 = 0; l2 < trainingContext.size(); ++l2) {
                double thisStep;
                if (trainingContext.isBound(trainingContext.getAlpha(l2)) || !((thisStep = Math.abs(trainingContext.getError(l2) - E2)) > step)) continue;
                step = thisStep;
                secondChoice = l2;
            }
            if (secondChoice >= 0 && this.takeStep(trainingContext, secondChoice, i2)) {
                return 1;
            }
            int randomStart = (int)Math.floor(Math.random() * (double)trainingContext.size());
            for (l = 0; l < trainingContext.size(); ++l) {
                i1 = (l + randomStart) % trainingContext.size();
                if (trainingContext.isBound(trainingContext.getAlpha(i1)) || !this.takeStep(trainingContext, i1, i2)) continue;
                return 1;
            }
            for (l = 0; l < trainingContext.size(); ++l) {
                i1 = (l + randomStart) % trainingContext.size();
                if (!trainingContext.isBound(trainingContext.getAlpha(i1)) || !this.takeStep(trainingContext, i1, i2)) continue;
                return 1;
            }
        }
        return 0;
    }

    public SVMClassifierModel trainModel(SVMTarget target, SVMKernel kernel, TrainingListener l) {
        SMOTrainingContext trainingContext = new SMOTrainingContext(target, kernel, l);
        int numChanged = 0;
        boolean examineAll = true;
        while (numChanged > 0 || examineAll) {
            int i;
            numChanged = 0;
            if (examineAll) {
                for (i = 0; i < trainingContext.size(); ++i) {
                    numChanged += this.examineExample(trainingContext, i);
                }
            } else {
                for (i = 0; i < trainingContext.size(); ++i) {
                    double alpha = trainingContext.getAlpha(i);
                    if (trainingContext.isBound(alpha)) continue;
                    numChanged += this.examineExample(trainingContext, i);
                }
            }
            examineAll = examineAll ? false : numChanged == 0;
            trainingContext.trainingCycleCompleted();
        }
        trainingContext.trainingCompleted();
        return trainingContext.getModel();
    }

    final class SMOTrainingContext
    implements TrainingContext {
        private double C;
        private double epsilon;
        private TrainingListener listener;
        private int cycle = 0;
        private TrainingEvent ourEvent;
        private SVMTarget target;
        private SVMClassifierModel model;
        private Object[] items;
        private double[] alphas;
        private double[] targets;
        private double[] E;

        private boolean isBound(double alpha) {
            return alpha <= 0.0 || alpha >= this.getC();
        }

        public int size() {
            return this.items.length;
        }

        public int getCurrentCycle() {
            return this.cycle;
        }

        public void trainingCycleCompleted() {
            ++this.cycle;
            if (this.listener != null) {
                this.listener.trainingCycleComplete(this.ourEvent);
            }
        }

        public void trainingCompleted() {
            for (int i = 0; i < this.size(); ++i) {
                if (this.getAlpha(i) != 0.0) continue;
                this.model.removeItem(this.getItem(i));
            }
            if (this.listener != null) {
                this.listener.trainingComplete(this.ourEvent);
            }
        }

        public Object getItem(int i) {
            return this.items[i];
        }

        public double getAlpha(int i) {
            return this.alphas[i];
        }

        public void setAlpha(int i, double a) {
            this.alphas[i] = a;
            this.model.setAlpha(this.getItem(i), this.getAlpha(i) * this.getTarget(i));
        }

        public double getTarget(int i) {
            return this.targets[i];
        }

        public double getC() {
            return this.C;
        }

        public double getEpsilon() {
            return this.epsilon;
        }

        public SVMTarget getTarget() {
            return this.target;
        }

        public SVMClassifierModel getModel() {
            return this.model;
        }

        public void setThreshold(double t) {
            this.model.setThreshold(t);
        }

        public double getThreshold() {
            return this.model.getThreshold();
        }

        public double getError(int i) {
            double target = this.getTarget(i);
            double alpha = this.getAlpha(i);
            if (this.isBound(alpha)) {
                this.E[i] = this.getModel().classify(this.getItem(i)) - this.getTarget(i);
                return this.E[i];
            }
            return this.E[i];
        }

        public void updateError(int i, double delta) {
            int n = i;
            this.E[n] = this.E[n] + delta;
        }

        public void resetError(int i) {
            this.E[i] = this.getModel().classify(this.getItem(i)) - this.getTarget(i);
        }

        public double getKernelValue(int i1, int i2) {
            return this.getModel().getKernel().evaluate(this.getItem(i1), this.getItem(i2));
        }

        public SMOTrainingContext(SVMTarget target, SVMKernel kernel, TrainingListener l) {
            this.C = SMOTrainer.this.getC();
            this.epsilon = SMOTrainer.this.getEpsilon();
            this.model = new SimpleSVMClassifierModel(kernel, target);
            this.model.setThreshold(0.0);
            this.listener = l;
            this.ourEvent = new TrainingEvent(this);
            this.cycle = 0;
            Set itemSet = target.items();
            int size = itemSet.size();
            this.items = new Object[size];
            this.alphas = new double[size];
            this.targets = new double[size];
            this.E = new double[size];
            Iterator itemI = itemSet.iterator();
            int i = 0;
            while (itemI.hasNext()) {
                Object item = itemI.next();
                this.items[i] = item;
                this.targets[i] = target.getTarget(item);
                this.alphas[i] = this.model.getAlpha(item) / this.targets[i];
                this.E[i] = -this.targets[i];
                ++i;
            }
        }
    }
}

